﻿<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('perangkat_desa', function (Blueprint $table) {
            if (!Schema::hasColumn('perangkat_desa', 'alamat')) {
                $table->text('alamat')->nullable()->after('jabatan');
            }
            if (!Schema::hasColumn('perangkat_desa', 'telepon')) {
                $table->string('telepon', 20)->nullable()->after('alamat');
            }
            if (!Schema::hasColumn('perangkat_desa', 'email')) {
                $table->string('email')->nullable()->after('telepon');
            }
            if (!Schema::hasColumn('perangkat_desa', 'pendidikan')) {
                $table->string('pendidikan', 50)->nullable()->after('email');
            }
            if (!Schema::hasColumn('perangkat_desa', 'tanggal_mulai_tugas')) {
                $table->date('tanggal_mulai_tugas')->nullable()->after('pendidikan');
            }
            if (!Schema::hasColumn('perangkat_desa', 'status_kepegawaian')) {
                $table->enum('status_kepegawaian', ['PNS', 'Non-PNS', 'Kontrak', 'Honorer'])->default('Non-PNS')->after('tanggal_mulai_tugas');
            }
            if (!Schema::hasColumn('perangkat_desa', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('status_kepegawaian');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('perangkat_desa', function (Blueprint $table) {
            $columns = ['alamat', 'telepon', 'email', 'pendidikan', 'tanggal_mulai_tugas', 'status_kepegawaian', 'is_active'];
            
            foreach ($columns as $column) {
                if (Schema::hasColumn('perangkat_desa', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
