<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            $table->string('password')->nullable()->after('no_wa');
            $table->timestamp('password_set_at')->nullable()->after('password');
            $table->boolean('password_must_change')->default(true)->after('password_set_at');
            $table->timestamp('last_login_at')->nullable()->after('password_must_change');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            $table->dropColumn(['password', 'password_set_at', 'password_must_change', 'last_login_at']);
        });
    }
}; 