<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('ottopay_api_key')->nullable()->after('tripay_channels');
            $table->string('ottopay_secret_key')->nullable()->after('ottopay_api_key');
            $table->string('ottopay_merchant_code')->nullable()->after('ottopay_secret_key');
            $table->enum('ottopay_mode', ['sandbox', 'production'])->default('sandbox')->after('ottopay_merchant_code');
            $table->integer('ottopay_expiry_time')->default(24)->after('ottopay_mode');
            $table->boolean('ottopay_fee_customer')->default(false)->after('ottopay_expiry_time');
            $table->json('ottopay_channels')->nullable()->after('ottopay_fee_customer');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn([
                'ottopay_api_key',
                'ottopay_secret_key',
                'ottopay_merchant_code',
                'ottopay_mode',
                'ottopay_expiry_time',
                'ottopay_fee_customer',
                'ottopay_channels'
            ]);
        });
    }
};
