<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('umkm', function (Blueprint $table) {
            // Remove verification related columns
            $table->dropColumn([
                'is_verified',
                'verified_at', 
                'verified_by',
                'catatan_verifikasi'
            ]);
            
            // Update status enum to remove pending_verifikasi
            $table->enum('status', ['aktif', 'nonaktif'])->default('aktif')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('umkm', function (Blueprint $table) {
            // Add back verification columns
            $table->boolean('is_verified')->default(false);
            $table->timestamp('verified_at')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users')->onDelete('set null');
            $table->text('catatan_verifikasi')->nullable();
            
            // Restore original status enum
            $table->enum('status', ['aktif', 'nonaktif', 'pending_verifikasi'])->default('pending_verifikasi')->change();
        });
    }
};