<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TemplateSurat;
use App\Models\Pbb;
use App\Models\TagihanPbb;
use App\Models\Polling;
use App\Models\PollingOpsi;
use App\Models\PerangkatDesa;
use App\Models\AgendaDesa;
use App\Models\InventarisDesa;
use App\Models\ArsipSuratKeluar;

class EnhancedSystemSeeder extends Seeder
{
    public function run()
    {
        $this->call([
            TemplateSuratSeeder::class,
            PbbSeeder::class,
            PollingSeeder::class,
            PerangkatDesaSeeder::class,
            AgendaDesaSeeder::class,
            InventarisDesaSeeder::class,
            ArsipSuratKeluarSeeder::class,
        ]);
    }
}

class TemplateSuratSeeder extends Seeder
{
    public function run()
    {
        $templates = [
            [
                'nama_template' => 'Surat Keterangan Domisili',
                'jenis_surat' => 'Surat Keterangan',
                'deskripsi' => 'Template surat keterangan domisili penduduk',
                'variabel_tersedia' => json_encode([
                    '{{nama}}', '{{nik}}', '{{alamat}}', '{{rt}}', '{{rw}}'
                ]),
                'konten_template' => 'SURAT KETERANGAN DOMISILI\nNomor: {{nomor_surat}}\n\nYang bertanda tangan di bawah ini menerangkan bahwa:\n\nNama: {{nama}}\nNIK: {{nik}}\nAlamat: {{alamat}}\n\nAdalah benar berdomisili di alamat tersebut.',
                'format_nomor' => 'DOM/{{urut}}/{{tahun}}',
                'is_active' => true,
                'created_by' => 1
            ],
            [
                'nama_template' => 'Surat Keterangan Tidak Mampu',
                'jenis_surat' => 'Surat Keterangan',
                'deskripsi' => 'Template surat keterangan tidak mampu',
                'variabel_tersedia' => json_encode([
                    '{{nama}}', '{{nik}}', '{{alamat}}', '{{pekerjaan}}'
                ]),
                'konten_template' => 'SURAT KETERANGAN TIDAK MAMPU\nNomor: {{nomor_surat}}\n\nYang bertanda tangan di bawah ini menerangkan bahwa:\n\nNama: {{nama}}\nNIK: {{nik}}\nPekerjaan: {{pekerjaan}}\n\nAdalah benar warga tidak mampu.',
                'format_nomor' => 'TM/{{urut}}/{{tahun}}',
                'is_active' => true,
                'created_by' => 1
            ]
        ];

        foreach ($templates as $template) {
            TemplateSurat::create($template);
        }
    }
}

class PbbSeeder extends Seeder
{
    public function run()
    {
        $pbbData = [
            [
                'nop' => '3201012001001001',
                'nama_wajib_pajak' => 'Budi Santoso',
                'alamat_wajib_pajak' => 'Jl. Merdeka No. 123',
                'alamat_objek_pajak' => 'Jl. Merdeka No. 123 RT 01/RW 01',
                'luas_tanah' => 200,
                'luas_bangunan' => 150,
                'njop_tanah' => 100000000,
                'njop_bangunan' => 112500000,
                'njop_total' => 212500000,
                'pbb_terutang' => 1002500,
                'is_active' => true,
                'created_by' => 1
            ]
        ];

        foreach ($pbbData as $data) {
            $pbb = Pbb::create($data);
            
            TagihanPbb::create([
                'pbb_id' => $pbb->id,
                'tahun_pajak' => now()->year,
                'jumlah_pajak' => $pbb->pbb_terutang,
                'total_tagihan' => $pbb->pbb_terutang,
                'status_bayar' => 'belum_bayar',
                'created_by' => 1
            ]);
        }
    }
}

class PollingSeeder extends Seeder  
{
    public function run()
    {
        $polling = Polling::create([
            'judul' => 'Prioritas Pembangunan Desa 2024',
            'deskripsi' => 'Voting untuk menentukan prioritas pembangunan desa',
            'mulai_voting' => now(),
            'selesai_voting' => now()->addDays(30),
            'jenis' => 'Usulan Pembangunan',
            'status' => 'Aktif',
            'created_by' => 1
        ]);

        $options = ['Perbaikan Jalan', 'Balai Desa', 'Irigasi', 'UMKM'];
        foreach ($options as $index => $option) {
            PollingOpsi::create([
                'polling_id' => $polling->id,
                'judul_opsi' => $option,
                'urutan' => $index + 1
            ]);
        }
    }
}

class PerangkatDesaSeeder extends Seeder
{
    public function run()
    {
        $perangkat = [
            [
                'nama' => 'H. Ahmad Wijaya',
                'jabatan' => 'Kepala Desa',
                'level_jabatan' => 1,
                'alamat' => 'Jl. Raya Desa No. 1',
                'status' => 'aktif',
                'created_by' => 1
            ],
            [
                'nama' => 'Bambang Sutrisno',
                'jabatan' => 'Sekretaris Desa',
                'level_jabatan' => 2,
                'alamat' => 'Jl. Mawar No. 15',
                'status' => 'aktif',
                'created_by' => 1
            ]
        ];

        foreach ($perangkat as $data) {
            PerangkatDesa::create($data);
        }
    }
}

class AgendaDesaSeeder extends Seeder
{
    public function run()
    {
        AgendaDesa::create([
            'judul' => 'Rapat Bulanan BPD',
            'deskripsi' => 'Rapat koordinasi bulanan',
            'tanggal_mulai' => now()->addDays(7),
            'tanggal_selesai' => now()->addDays(7)->addHours(3),
            'lokasi' => 'Balai Desa',
            'kategori' => 'Rapat',
            'status' => 'dijadwalkan',
            'created_by' => 1
        ]);
    }
}

class InventarisDesaSeeder extends Seeder
{
    public function run()
    {
        $inventaris = [
            [
                'nama_barang' => 'Komputer Desktop',
                'kategori' => 'Elektronik',
                'tahun_perolehan' => 2022,
                'harga_perolehan' => 8500000,
                'nilai_sekarang' => 7500000,
                'kondisi' => 'Baik',
                'status_pemakaian' => 'Digunakan',
                'lokasi_penyimpanan' => 'Kantor Desa',
                'penanggung_jawab' => 'Sekretaris Desa',
                'created_by' => 1
            ]
        ];

        foreach ($inventaris as $data) {
            InventarisDesa::create($data);
        }
    }
}

class ArsipSuratKeluarSeeder extends Seeder
{
    public function run()
    {
        ArsipSuratKeluar::create([
            'tipe_surat' => 'Surat Undangan',
            'perihal' => 'Undangan Rapat Koordinasi',
            'tujuan' => 'Kepala Dinas PMD',
            'tanggal_surat' => now()->subDays(10),
            'created_by' => 1
        ]);
    }
} 