<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Penduduk;
use App\Models\Keluarga;

class KeluargaSeeder extends Seeder
{
    public function run()
    {
        echo "Creating Keluarga data from existing Penduduk data...\n";
        
        // Get unique KK numbers from penduduk
        $uniqueKK = Penduduk::select('no_kk')
                           ->distinct()
                           ->whereNotNull('no_kk')
                           ->where('no_kk', '!=', '')
                           ->get();
        
        $totalCreated = 0;
        
        foreach ($uniqueKK as $kk) {
            $noKK = $kk->no_kk;
            
            // Check if keluarga already exists
            if (Keluarga::where('no_kk', $noKK)->exists()) {
                continue;
            }
            
            // Get all members of this family
            $anggotaKeluarga = Penduduk::where('no_kk', $noKK)->get();
            
            if ($anggotaKeluarga->isEmpty()) {
                continue;
            }
            
            // Find kepala keluarga (prioritas: ayah, atau yang tertua)
            $kepalaKeluarga = $anggotaKeluarga->where('jenis_kelamin', 'L')->first() 
                           ?? $anggotaKeluarga->sortBy('tanggal_lahir')->first();
            
            // Get representative coordinates (from kepala keluarga or first member)
            $representative = $anggotaKeluarga->whereNotNull('latitude')->first() ?? $kepalaKeluarga;
            
            // Create Keluarga record
            Keluarga::create([
                'no_kk' => $noKK,
                'kepala_keluarga_nik' => $kepalaKeluarga->nik,
                'alamat' => $kepalaKeluarga->alamat,
                'dusun' => $kepalaKeluarga->dusun,
                'rt' => $kepalaKeluarga->rt,
                'rw' => $kepalaKeluarga->rw,
                'created_at' => now(),
                'updated_at' => now()
            ]);
            
            $totalCreated++;
            
            if ($totalCreated % 10 == 0) {
                echo "Created {$totalCreated} keluarga records...\n";
            }
        }
        
        echo "✅ Successfully created {$totalCreated} Keluarga records\n";
        echo "Total families: " . Keluarga::count() . "\n";
    }
} 
