<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Umkm;
use App\Models\ProdukUmkm;
use Illuminate\Support\Str;

class ProdukUmkmSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // First create some UMKM
        $umkmData = [
            [
                'nama_umkm' => 'Warung Makan Sari',
                'kategori' => 'makanan_minuman',
                'deskripsi' => 'Warung makan tradisional dengan berbagai olahan makanan ringan',
                'alamat' => 'Dusun 1, RT 01/RW 01',
                'nomor_telepon' => '081234567890',
                'status' => 'aktif',
                'is_verified' => true,
                'aktif_marketplace' => true,
                'bisa_cod' => true,
            ],
            [
                'nama_umkm' => 'Kerajinan Bambu Jaya',
                'kategori' => 'kerajinan_tangan',
                'deskripsi' => 'Pengrajin tas, keranjang dan peralatan dari rotan dan bambu',
                'alamat' => 'Dusun 2, RT 02/RW 01',
                'nomor_telepon' => '081234567891',
                'status' => 'aktif',
                'is_verified' => true,
                'aktif_marketplace' => true,
                'bisa_cod' => true,
            ],
            [
                'nama_umkm' => 'Tani Lebah Makmur',
                'kategori' => 'pertanian_perkebunan',
                'deskripsi' => 'Produsen madu murni dan produk lebah lainnya',
                'alamat' => 'Dusun 3, RT 01/RW 02',
                'nomor_telepon' => '081234567892',
                'status' => 'aktif',
                'is_verified' => true,
                'aktif_marketplace' => true,
                'bisa_cod' => true,
            ],
            [
                'nama_umkm' => 'Batik Nusantara',
                'kategori' => 'fashion_tekstil',
                'deskripsi' => 'Pengrajin batik tulis dan cap dengan motif tradisional',
                'alamat' => 'Dusun 1, RT 03/RW 01',
                'nomor_telepon' => '081234567893',
                'status' => 'aktif',
                'is_verified' => true,
                'aktif_marketplace' => true,
                'bisa_cod' => true,
            ],
            [
                'nama_umkm' => 'Ibu Sari Makanan',
                'kategori' => 'makanan_minuman',
                'deskripsi' => 'Produsen emping dan keripik berbagai rasa',
                'alamat' => 'Dusun 2, RT 01/RW 02',
                'nomor_telepon' => '081234567894',
                'status' => 'aktif',
                'is_verified' => true,
                'aktif_marketplace' => true,
                'bisa_cod' => true,
            ],
            [
                'nama_umkm' => 'Tenun Tradisional',
                'kategori' => 'fashion_tekstil',
                'deskripsi' => 'Pengrajin kain tenun ikat dengan motif khas daerah',
                'alamat' => 'Dusun 3, RT 02/RW 02',
                'nomor_telepon' => '081234567895',
                'status' => 'aktif',
                'is_verified' => true,
                'aktif_marketplace' => true,
                'bisa_cod' => true,
            ],
        ];

        foreach ($umkmData as $data) {
            $data['slug'] = Str::slug($data['nama_umkm']);
            Umkm::create($data);
        }

        // Then create products for each UMKM
        $produkData = [
            // Warung Makan Sari (UMKM ID: 1)
            [
                'umkm_id' => 1,
                'nama_produk' => 'Keripik Singkong',
                'deskripsi' => 'Keripik singkong renyah dengan berbagai rasa: original, balado, dan keju',
                'kategori_produk' => 'Makanan Ringan',
                'harga_jual' => 30000,
                'harga_diskon' => 25000,
                'stok' => 50,
                'satuan' => 'pack',
                'rating_rata_rata' => 4.2,
                'jumlah_review' => 23,
                'total_terjual' => 156,
                'status' => 'aktif',
                'is_featured' => true,
                'is_bestseller' => false,
            ],
            [
                'umkm_id' => 1,
                'nama_produk' => 'Rempeyek Kacang',
                'deskripsi' => 'Rempeyek kacang tanah renyah, cocok untuk camilan atau lauk',
                'kategori_produk' => 'Makanan Ringan',
                'harga_jual' => 15000,
                'stok' => 30,
                'satuan' => 'pack',
                'rating_rata_rata' => 4.5,
                'jumlah_review' => 18,
                'total_terjual' => 89,
                'status' => 'aktif',
                'is_featured' => false,
                'is_bestseller' => false,
            ],

            // Kerajinan Bambu Jaya (UMKM ID: 2)
            [
                'umkm_id' => 2,
                'nama_produk' => 'Tas Rotan',
                'deskripsi' => 'Tas rotan handmade berkualitas tinggi, tahan lama dan ramah lingkungan',
                'kategori_produk' => 'Kerajinan',
                'harga_jual' => 150000,
                'stok' => 15,
                'satuan' => 'pcs',
                'rating_rata_rata' => 4.8,
                'jumlah_review' => 15,
                'total_terjual' => 45,
                'status' => 'aktif',
                'is_featured' => true,
                'is_bestseller' => true,
            ],
            [
                'umkm_id' => 2,
                'nama_produk' => 'Keranjang Bambu',
                'deskripsi' => 'Keranjang bambu multifungsi untuk penyimpanan dan dekorasi',
                'kategori_produk' => 'Kerajinan',
                'harga_jual' => 75000,
                'stok' => 25,
                'satuan' => 'pcs',
                'rating_rata_rata' => 4.3,
                'jumlah_review' => 12,
                'total_terjual' => 67,
                'status' => 'aktif',
                'is_featured' => false,
                'is_bestseller' => false,
            ],

            // Tani Lebah Makmur (UMKM ID: 3)
            [
                'umkm_id' => 3,
                'nama_produk' => 'Madu Murni',
                'deskripsi' => 'Madu murni 100% dari lebah lokal, kaya nutrisi dan antioksidan',
                'kategori_produk' => 'Kesehatan',
                'harga_jual' => 75000,
                'stok' => 40,
                'satuan' => 'botol',
                'rating_rata_rata' => 4.7,
                'jumlah_review' => 32,
                'total_terjual' => 128,
                'status' => 'aktif',
                'is_featured' => true,
                'is_bestseller' => false,
            ],

            // Batik Nusantara (UMKM ID: 4)
            [
                'umkm_id' => 4,
                'nama_produk' => 'Batik Tulis',
                'deskripsi' => 'Kain batik tulis motif tradisional, berkualitas premium untuk berbagai keperluan',
                'kategori_produk' => 'Fashion',
                'harga_jual' => 280000,
                'stok' => 8,
                'satuan' => 'lembar',
                'rating_rata_rata' => 4.9,
                'jumlah_review' => 7,
                'total_terjual' => 23,
                'status' => 'aktif',
                'is_featured' => false,
                'is_bestseller' => false,
            ],

            // Ibu Sari Makanan (UMKM ID: 5)
            [
                'umkm_id' => 5,
                'nama_produk' => 'Emping Jagung',
                'deskripsi' => 'Emping jagung crispy, camilan sehat dan bergizi untuk keluarga',
                'kategori_produk' => 'Makanan Ringan',
                'harga_jual' => 35000,
                'stok' => 60,
                'satuan' => 'pack',
                'rating_rata_rata' => 4.1,
                'jumlah_review' => 11,
                'total_terjual' => 94,
                'status' => 'aktif',
                'is_featured' => false,
                'is_bestseller' => false,
            ],

            // Tenun Tradisional (UMKM ID: 6)
            [
                'umkm_id' => 6,
                'nama_produk' => 'Kain Tenun',
                'deskripsi' => 'Kain tenun ikat berkualitas tinggi dengan motif khas daerah',
                'kategori_produk' => 'Fashion',
                'harga_jual' => 450000,
                'stok' => 5,
                'satuan' => 'lembar',
                'rating_rata_rata' => 4.6,
                'jumlah_review' => 9,
                'total_terjual' => 18,
                'status' => 'aktif',
                'is_featured' => false,
                'is_bestseller' => false,
            ],
        ];

        foreach ($produkData as $data) {
            $data['slug'] = Str::slug($data['nama_produk']) . '-' . $data['umkm_id'];
            $data['sku'] = 'PRD-' . strtoupper(Str::random(6));
            ProdukUmkm::create($data);
        }
    }
} 