<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TemplateSurat;

class TemplateSuratSeeder extends Seeder
{
    public function run()
    {
        $templates = [
            [
                'nama_template' => 'Template Surat Keterangan Domisili',
                'jenis_surat' => 'Surat Keterangan Domisili',
                'kode_surat' => 'SKD-DESA',
                'format_nomor' => '{counter}/SKD-DESA/{bulan}/{tahun}',
                'template_content' => 'Yang bertanda tangan di bawah ini, {penandatangan_jabatan} {nama_desa}, Kecamatan {nama_kecamatan}, Kabupaten {nama_kabupaten}, Provinsi {nama_provinsi}, dengan ini menerangkan bahwa:

Nama Lengkap    : {nama}
NIK             : {nik}
Tempat/Tgl Lahir: {tempat_lahir}, {tanggal_lahir}
Jenis Kelamin   : {jenis_kelamin}
Agama           : {agama}
Pekerjaan       : {pekerjaan}
Status Perkawinan: {status_perkawinan}
Alamat          : {alamat}, RT {rt}/RW {rw}, Dusun {dusun}

Adalah benar-benar penduduk {nama_desa} yang berdomisili di alamat tersebut di atas.

Surat keterangan ini dibuat untuk keperluan: {keperluan}

Demikian surat keterangan domisili ini dibuat dengan sebenarnya dan dapat digunakan sebagaimana mestinya.',
                'variabel_tersedia' => json_encode([
                    'nama', 'nik', 'tempat_lahir', 'tanggal_lahir', 'jenis_kelamin', 
                    'agama', 'pekerjaan', 'status_perkawinan', 'alamat', 'rt', 'rw', 
                    'dusun', 'keperluan', 'nama_desa', 'nama_kecamatan', 'nama_kabupaten', 
                    'nama_provinsi', 'penandatangan_jabatan'
                ]),
                'penandatangan_default' => 'Kepala Desa',
                'aktif' => true,
                'urutan' => 1,
                'keterangan' => 'Template untuk surat keterangan domisili penduduk'
            ],
            [
                'nama_template' => 'Template Surat Keterangan Usaha',
                'jenis_surat' => 'Surat Keterangan Usaha',
                'kode_surat' => 'SKU-DESA',
                'format_nomor' => '{counter}/SKU-DESA/{bulan}/{tahun}',
                'template_content' => 'Yang bertanda tangan di bawah ini, {penandatangan_jabatan} {nama_desa}, Kecamatan {nama_kecamatan}, Kabupaten {nama_kabupaten}, Provinsi {nama_provinsi}, dengan ini menerangkan bahwa:

Nama Lengkap    : {nama}
NIK             : {nik}
Tempat/Tgl Lahir: {tempat_lahir}, {tanggal_lahir}
Jenis Kelamin   : {jenis_kelamin}
Agama           : {agama}
Alamat          : {alamat}, RT {rt}/RW {rw}, Dusun {dusun}

Adalah benar-benar penduduk {nama_desa} yang memiliki usaha dengan keterangan sebagai berikut:
- Jenis Usaha: {keperluan}
- Lokasi Usaha: {alamat}

Yang bersangkutan telah menjalankan usaha tersebut dengan baik dan tidak pernah melakukan pelanggaran hukum.

Surat keterangan ini dibuat untuk keperluan administrasi usaha dan dapat digunakan sebagaimana mestinya.

Demikian surat keterangan usaha ini dibuat dengan sebenarnya.',
                'variabel_tersedia' => json_encode([
                    'nama', 'nik', 'tempat_lahir', 'tanggal_lahir', 'jenis_kelamin', 
                    'agama', 'alamat', 'rt', 'rw', 'dusun', 'keperluan', 'nama_desa', 
                    'nama_kecamatan', 'nama_kabupaten', 'nama_provinsi', 'penandatangan_jabatan'
                ]),
                'penandatangan_default' => 'Kepala Desa',
                'aktif' => true,
                'urutan' => 2,
                'keterangan' => 'Template untuk surat keterangan usaha'
            ],
            [
                'nama_template' => 'Template Surat Keterangan Tidak Mampu',
                'jenis_surat' => 'Surat Keterangan Tidak Mampu',
                'kode_surat' => 'SKTM-DESA',
                'format_nomor' => '{counter}/SKTM-DESA/{bulan}/{tahun}',
                'template_content' => 'Yang bertanda tangan di bawah ini, {penandatangan_jabatan} {nama_desa}, Kecamatan {nama_kecamatan}, Kabupaten {nama_kabupaten}, Provinsi {nama_provinsi}, dengan ini menerangkan bahwa:

Nama Lengkap    : {nama}
NIK             : {nik}
Tempat/Tgl Lahir: {tempat_lahir}, {tanggal_lahir}
Jenis Kelamin   : {jenis_kelamin}
Agama           : {agama}
Pekerjaan       : {pekerjaan}
Alamat          : {alamat}, RT {rt}/RW {rw}, Dusun {dusun}

Adalah benar-benar penduduk {nama_desa} yang tergolong keluarga tidak mampu/kurang mampu.

Berdasarkan pengamatan dan keterangan yang dapat dipercaya, yang bersangkutan memang layak mendapat bantuan sosial dari pemerintah.

Surat keterangan ini dibuat untuk keperluan: {keperluan}

Demikian surat keterangan tidak mampu ini dibuat dengan sebenarnya dan dapat digunakan sebagaimana mestinya.',
                'variabel_tersedia' => json_encode([
                    'nama', 'nik', 'tempat_lahir', 'tanggal_lahir', 'jenis_kelamin', 
                    'agama', 'pekerjaan', 'alamat', 'rt', 'rw', 'dusun', 'keperluan', 
                    'nama_desa', 'nama_kecamatan', 'nama_kabupaten', 'nama_provinsi', 
                    'penandatangan_jabatan'
                ]),
                'penandatangan_default' => 'Kepala Desa',
                'aktif' => true,
                'urutan' => 3,
                'keterangan' => 'Template untuk surat keterangan tidak mampu'
            ],
            [
                'nama_template' => 'Template Surat Keterangan Kelahiran',
                'jenis_surat' => 'Surat Keterangan Kelahiran',
                'kode_surat' => 'SKL-DESA',
                'format_nomor' => '{counter}/SKL-DESA/{bulan}/{tahun}',
                'template_content' => 'Yang bertanda tangan di bawah ini, {penandatangan_jabatan} {nama_desa}, Kecamatan {nama_kecamatan}, Kabupaten {nama_kabupaten}, Provinsi {nama_provinsi}, dengan ini menerangkan bahwa:

Telah lahir seorang bayi dengan keterangan sebagai berikut:
- Nama Bayi     : {nama}
- Tempat Lahir  : {tempat_lahir}
- Tanggal Lahir : {tanggal_lahir}
- Jenis Kelamin : {jenis_kelamin}
- Anak ke       : (sesuai keperluan)

Dari pasangan suami istri:
- Nama Ayah     : (sesuai keperluan)
- Nama Ibu      : (sesuai keperluan)
- Alamat        : {alamat}, RT {rt}/RW {rw}, Dusun {dusun}

Surat keterangan ini dibuat berdasarkan keterangan pelapor dan untuk keperluan: {keperluan}

Demikian surat keterangan kelahiran ini dibuat dengan sebenarnya.',
                'variabel_tersedia' => json_encode([
                    'nama', 'tempat_lahir', 'tanggal_lahir', 'jenis_kelamin', 
                    'alamat', 'rt', 'rw', 'dusun', 'keperluan', 'nama_desa', 
                    'nama_kecamatan', 'nama_kabupaten', 'nama_provinsi', 'penandatangan_jabatan'
                ]),
                'penandatangan_default' => 'Kepala Desa',
                'aktif' => true,
                'urutan' => 4,
                'keterangan' => 'Template untuk surat keterangan kelahiran'
            ],
            [
                'nama_template' => 'Template Surat Keterangan Kematian',
                'jenis_surat' => 'Surat Keterangan Kematian',
                'kode_surat' => 'SKM-DESA',
                'format_nomor' => '{counter}/SKM-DESA/{bulan}/{tahun}',
                'template_content' => 'Yang bertanda tangan di bawah ini, {penandatangan_jabatan} {nama_desa}, Kecamatan {nama_kecamatan}, Kabupaten {nama_kabupaten}, Provinsi {nama_provinsi}, dengan ini menerangkan bahwa:

Nama Lengkap    : {nama}
NIK             : {nik}
Tempat/Tgl Lahir: {tempat_lahir}, {tanggal_lahir}
Jenis Kelamin   : {jenis_kelamin}
Agama           : {agama}
Alamat          : {alamat}, RT {rt}/RW {rw}, Dusun {dusun}

Adalah benar-benar telah meninggal dunia pada:
- Hari/Tanggal  : (sesuai keperluan)
- Tempat        : {alamat}
- Penyebab      : (sesuai keperluan)

Surat keterangan ini dibuat berdasarkan keterangan keluarga dan untuk keperluan: {keperluan}

Demikian surat keterangan kematian ini dibuat dengan sebenarnya.',
                'variabel_tersedia' => json_encode([
                    'nama', 'nik', 'tempat_lahir', 'tanggal_lahir', 'jenis_kelamin', 
                    'agama', 'alamat', 'rt', 'rw', 'dusun', 'keperluan', 'nama_desa', 
                    'nama_kecamatan', 'nama_kabupaten', 'nama_provinsi', 'penandatangan_jabatan'
                ]),
                'penandatangan_default' => 'Kepala Desa',
                'aktif' => true,
                'urutan' => 5,
                'keterangan' => 'Template untuk surat keterangan kematian'
            ]
        ];

        foreach ($templates as $template) {
            TemplateSurat::updateOrCreate(
                ['jenis_surat' => $template['jenis_surat']],
                $template
            );
        }
    }
} 