<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\WilayahAdministratif;
use App\Models\User;

class WilayahAdministratifSeeder extends Seeder
{
    public function run()
    {
        // Get a user for foreign key
        $user = User::first();
        if (!$user) {
            echo "No users found. Please run user seeder first.\n";
            return;
        }

        echo "Creating Wilayah Administratif structure...\n";

        // Create Dusun - WITHOUT DUMMY DATA for KK and Penduduk
        $dusun1 = WilayahAdministratif::create([
            'jenis_wilayah' => 'dusun',
            'kode_wilayah' => 'DSN001',
            'nama_wilayah' => 'Dusun Maju',
            'parent_id' => null,
            'kepala_wilayah' => 'Budi Santoso',
            'nomor_hp_kepala' => '081234567890',
            'jumlah_kk' => 0, // Will be calculated from real penduduk data
            'jumlah_penduduk' => 0, // Will be calculated from real penduduk data
            'luas_wilayah' => 25.50,
            'batas_wilayah' => 'Utara: Desa Makmur, Selatan: Sungai Jernih, Timur: Hutan Lindung, Barat: Jalan Raya',
            'status' => 'aktif',
            'urutan_tampil' => 1,
            'user_id' => $user->id
        ]);

        $dusun2 = WilayahAdministratif::create([
            'jenis_wilayah' => 'dusun',
            'kode_wilayah' => 'DSN002',
            'nama_wilayah' => 'Dusun Sejahtera',
            'parent_id' => null,
            'kepala_wilayah' => 'Siti Aminah',
            'nomor_hp_kepala' => '081234567891',
            'jumlah_kk' => 0, // Will be calculated from real penduduk data
            'jumlah_penduduk' => 0, // Will be calculated from real penduduk data
            'luas_wilayah' => 18.75,
            'batas_wilayah' => 'Utara: Kebun Sawit, Selatan: Dusun Maju, Timur: Persawahan, Barat: Jalan Desa',
            'status' => 'aktif',
            'urutan_tampil' => 2,
            'user_id' => $user->id
        ]);

        // Create RW for Dusun Maju
        $rw1_dsn1 = WilayahAdministratif::create([
            'jenis_wilayah' => 'rw',
            'kode_wilayah' => 'RW001',
            'nama_wilayah' => 'RW 01',
            'parent_id' => $dusun1->id,
            'kepala_wilayah' => 'Ahmad Hidayat',
            'nomor_hp_kepala' => '081234567892',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 12.25,
            'batas_wilayah' => 'Utara: RW 02, Selatan: Sungai Kecil, Timur: Kebun, Barat: Jalan Utama',
            'status' => 'aktif',
            'urutan_tampil' => 1,
            'user_id' => $user->id
        ]);

        $rw2_dsn1 = WilayahAdministratif::create([
            'jenis_wilayah' => 'rw',
            'kode_wilayah' => 'RW002',
            'nama_wilayah' => 'RW 02',
            'parent_id' => $dusun1->id,
            'kepala_wilayah' => 'Fatimah Zahra',
            'nomor_hp_kepala' => '081234567893',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 13.25,
            'batas_wilayah' => 'Utara: Hutan, Selatan: RW 01, Timur: Ladang, Barat: Gang Masjid',
            'status' => 'aktif',
            'urutan_tampil' => 2,
            'user_id' => $user->id
        ]);

        // Create RW for Dusun Sejahtera
        $rw1_dsn2 = WilayahAdministratif::create([
            'jenis_wilayah' => 'rw',
            'kode_wilayah' => 'RW003',
            'nama_wilayah' => 'RW 01',
            'parent_id' => $dusun2->id,
            'kepala_wilayah' => 'Muhammad Yusuf',
            'nomor_hp_kepala' => '081234567894',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 18.75,
            'batas_wilayah' => 'Utara: Sawah, Selatan: Kolam, Timur: Kebun Jagung, Barat: Jalan Poros',
            'status' => 'aktif',
            'urutan_tampil' => 1,
            'user_id' => $user->id
        ]);

        // Create RT for RW 01 - Dusun Maju
        WilayahAdministratif::create([
            'jenis_wilayah' => 'rt',
            'kode_wilayah' => 'RT001',
            'nama_wilayah' => 'RT 01',
            'parent_id' => $rw1_dsn1->id,
            'kepala_wilayah' => 'Joko Widodo',
            'nomor_hp_kepala' => '081234567895',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 4.12,
            'batas_wilayah' => 'Utara: RT 02, Selatan: Sungai, Timur: Pos Ronda, Barat: Jalan Kampung',
            'status' => 'aktif',
            'urutan_tampil' => 1,
            'user_id' => $user->id
        ]);

        WilayahAdministratif::create([
            'jenis_wilayah' => 'rt',
            'kode_wilayah' => 'RT002',
            'nama_wilayah' => 'RT 02',
            'parent_id' => $rw1_dsn1->id,
            'kepala_wilayah' => 'Mega Sari',
            'nomor_hp_kepala' => '081234567896',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 4.06,
            'batas_wilayah' => 'Utara: RT 03, Selatan: RT 01, Timur: Lapangan, Barat: Warung',
            'status' => 'aktif',
            'urutan_tampil' => 2,
            'user_id' => $user->id
        ]);

        WilayahAdministratif::create([
            'jenis_wilayah' => 'rt',
            'kode_wilayah' => 'RT003',
            'nama_wilayah' => 'RT 03',
            'parent_id' => $rw1_dsn1->id,
            'kepala_wilayah' => 'Susilo Bambang',
            'nomor_hp_kepala' => '081234567897',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 4.07,
            'batas_wilayah' => 'Utara: Hutan Kecil, Selatan: RT 02, Timur: Kebun Warga, Barat: Sekolah',
            'status' => 'aktif',
            'urutan_tampil' => 3,
            'user_id' => $user->id
        ]);

        // Create RT for RW 02 - Dusun Maju
        WilayahAdministratif::create([
            'jenis_wilayah' => 'rt',
            'kode_wilayah' => 'RT004',
            'nama_wilayah' => 'RT 01',
            'parent_id' => $rw2_dsn1->id,
            'kepala_wilayah' => 'Habibie Ainun',
            'nomor_hp_kepala' => '081234567898',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 4.42,
            'batas_wilayah' => 'Utara: Masjid, Selatan: Toko, Timur: RT 02, Barat: Kantor Desa',
            'status' => 'aktif',
            'urutan_tampil' => 1,
            'user_id' => $user->id
        ]);

        WilayahAdministratif::create([
            'jenis_wilayah' => 'rt',
            'kode_wilayah' => 'RT005',
            'nama_wilayah' => 'RT 02',
            'parent_id' => $rw2_dsn1->id,
            'kepala_wilayah' => 'Gus Dur',
            'nomor_hp_kepala' => '081234567899',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 4.41,
            'batas_wilayah' => 'Utara: Balai Desa, Selatan: Puskesmas, Timur: RT 03, Barat: RT 01',
            'status' => 'aktif',
            'urutan_tampil' => 2,
            'user_id' => $user->id
        ]);

        WilayahAdministratif::create([
            'jenis_wilayah' => 'rt',
            'kode_wilayah' => 'RT006',
            'nama_wilayah' => 'RT 03',
            'parent_id' => $rw2_dsn1->id,
            'kepala_wilayah' => 'Abdurrahman Wahid',
            'nomor_hp_kepala' => '081234567900',
            'jumlah_kk' => 0,
            'jumlah_penduduk' => 0,
            'luas_wilayah' => 4.42,
            'batas_wilayah' => 'Utara: Pasar, Selatan: Terminal, Timur: Bank, Barat: RT 02',
            'status' => 'aktif',
            'urutan_tampil' => 3,
            'user_id' => $user->id
        ]);

        echo "Wilayah Administratif structure created successfully!\n";
        echo "Created: 2 Dusun, 3 RW, 6 RT\n";
        
        // ✅ IMPORTANT: Calculate real statistics from penduduk data
        echo "\n🔄 Calculating real statistics from penduduk data...\n";
        
        try {
            $result = WilayahAdministratif::updateAllStatistik();
            
            if ($result['success']) {
                echo "✅ Statistics calculated successfully!\n";
                echo "Updated {$result['total_updated']} wilayah:\n";
                echo "  - RT: {$result['updated_rt']}\n";
                echo "  - RW: {$result['updated_rw']}\n";
                echo "  - Dusun: {$result['updated_dusun']}\n";
                
                // Show final statistics
                $realStats = WilayahAdministratif::getRealTimeStatistik();
                if (!isset($realStats['error'])) {
                    echo "\n📊 Final Statistics:\n";
                    echo "  Total KK: {$realStats['total_kk_real']}\n";
                    echo "  Total Penduduk: {$realStats['total_penduduk_real']}\n";
                }
            } else {
                echo "⚠️ Warning: Could not calculate statistics: {$result['error']}\n";
                echo "You can run statistics calculation later using Sinkron Data button.\n";
            }
        } catch (\Exception $e) {
            echo "⚠️ Warning: Statistics calculation failed: {$e->getMessage()}\n";
            echo "You can run statistics calculation later using Sinkron Data button.\n";
        }
        
        echo "\n✅ Seeder completed! All data will be calculated from real penduduk records.\n";
    }
}
