<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Fixing all password hashes in database...\n";

try {
    // Get all penduduk with passwords
    $pendudukList = \App\Models\Penduduk::whereNotNull('password')->get();
    
    echo "Found " . $pendudukList->count() . " penduduk with passwords\n\n";
    
    $fixedCount = 0;
    $errorCount = 0;
    
    foreach ($pendudukList as $penduduk) {
        echo "Processing NIK: " . $penduduk->nik . " (" . $penduduk->nama . ")\n";
        
        // Check if password is already properly hashed
        if (str_starts_with($penduduk->password, '$2y$') || 
            str_starts_with($penduduk->password, '$2a$') || 
            str_starts_with($penduduk->password, '$2b$')) {
            echo "  Password already properly hashed, skipping...\n";
            continue;
        }
        
        // If password is plain text, use it as the new password
        $plainPassword = $penduduk->password;
        
        try {
            // Rehash the password
            $penduduk->setPassword($plainPassword);
            echo "  Password rehashed successfully\n";
            $fixedCount++;
        } catch (Exception $e) {
            echo "  ERROR rehashing password: " . $e->getMessage() . "\n";
            $errorCount++;
        }
        
        echo "\n";
    }
    
    echo "Summary:\n";
    echo "  Total processed: " . $pendudukList->count() . "\n";
    echo "  Fixed: " . $fixedCount . "\n";
    echo "  Errors: " . $errorCount . "\n";
    
    if ($fixedCount > 0) {
        echo "\n✅ Password hashing fixed successfully!\n";
        echo "You can now test the login functionality.\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
}
