<?php
/**
 * Script untuk memeriksa data UMKM dan file gambar
 */

require_once __DIR__ . '/../vendor/autoload.php';

// Bootstrap Laravel
$app = require_once __DIR__ . '/../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "=== UMKM Data Check ===\n\n";

// Check UMKM with logo
$umkmWithLogo = \App\Models\Umkm::whereNotNull('logo')->get(['id', 'nama_umkm', 'logo']);

echo "UMKM dengan logo:\n";
foreach ($umkmWithLogo as $umkm) {
    echo "ID: {$umkm->id}, Nama: {$umkm->nama_umkm}, Logo: {$umkm->logo}\n";
    
    // Check if file exists
    $storagePath = storage_path('app/public/umkm/logo/' . $umkm->logo);
    $publicPath = public_path('storage/umkm/logo/' . $umkm->logo);
    
    echo "  Storage path: " . $storagePath . " - " . (file_exists($storagePath) ? "EXISTS" : "NOT FOUND") . "\n";
    echo "  Public path: " . $publicPath . " - " . (file_exists($publicPath) ? "EXISTS" : "NOT FOUND") . "\n";
    
    // Test URL generation
    $logoUrl = \App\Helpers\SharedHostingHelper::getUmkmLogoUrl($umkm->logo);
    echo "  Generated URL: " . $logoUrl . "\n";
    echo "\n";
}

// Check UMKM with gallery
$umkmWithGallery = \App\Models\Umkm::whereNotNull('galeri_foto')->get(['id', 'nama_umkm', 'galeri_foto']);

echo "UMKM dengan galeri:\n";
foreach ($umkmWithGallery as $umkm) {
    echo "ID: {$umkm->id}, Nama: {$umkm->nama_umkm}\n";
    
    $galeri = is_array($umkm->galeri_foto) ? $umkm->galeri_foto : json_decode($umkm->galeri_foto, true);
    if ($galeri) {
        foreach ($galeri as $index => $foto) {
            echo "  Gallery {$index}: {$foto}\n";
            
            $storagePath = storage_path('app/public/umkm/galeri/' . $foto);
            $publicPath = public_path('storage/umkm/galeri/' . $foto);
            
            echo "    Storage path: " . $storagePath . " - " . (file_exists($storagePath) ? "EXISTS" : "NOT FOUND") . "\n";
            echo "    Public path: " . $publicPath . " - " . (file_exists($publicPath) ? "EXISTS" : "NOT FOUND") . "\n";
        }
    }
    echo "\n";
}

echo "=== Check Complete ===\n";
