<?php
/**
 * Debug Objek Wisata Data
 */

require_once __DIR__ . '/../vendor/autoload.php';

// Load Laravel application
$app = require_once __DIR__ . '/../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ObjekWisata;

header('Content-Type: text/html; charset=utf-8');

?>
<!DOCTYPE html>
<html>
<head>
    <title>Debug Objek Wisata Data</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .data-row { margin: 10px 0; padding: 10px; background: #f5f5f5; border-radius: 4px; }
        .field-name { font-weight: bold; color: #333; }
        .field-value { color: #666; }
        .null-value { color: #999; font-style: italic; }
    </style>
</head>
<body>
    <h1>Debug Objek Wisata Data</h1>

    <?php
    try {
        $obj = ObjekWisata::find(1);
        
        if ($obj) {
            echo "<h2>✅ Data found for ID 1:</h2>";
            
            $fields = [
                'id',
                'nama_wisata',
                'kategori_wisata', 
                'status',
                'deskripsi',
                'alamat',
                'desa',
                'kecamatan',
                'harga_tiket_dewasa',
                'harga_tiket_anak',
                'total_pengunjung',
                'rating_rata_rata',
                'jumlah_review',
                'jam_operasional',
                'nama_pengelola',
                'telepon',
                'email',
                'website',
                'latitude',
                'longitude',
                'foto_utama',
                'galeri_foto',
                'created_at',
                'updated_at'
            ];
            
            foreach ($fields as $field) {
                $value = $obj->$field;
                echo "<div class='data-row'>";
                echo "<span class='field-name'>{$field}:</span> ";
                
                if ($value === null) {
                    echo "<span class='null-value'>NULL</span>";
                } elseif (is_array($value)) {
                    echo "<span class='field-value'>[ARRAY] " . json_encode($value, JSON_UNESCAPED_UNICODE) . "</span>";
                } elseif (is_string($value) && strlen($value) > 100) {
                    echo "<span class='field-value'>" . htmlspecialchars(substr($value, 0, 100)) . "...</span>";
                } else {
                    echo "<span class='field-value'>" . htmlspecialchars($value) . "</span>";
                }
                echo "</div>";
            }
            
            echo "<h3>Raw Attributes:</h3>";
            echo "<pre>" . print_r($obj->getAttributes(), true) . "</pre>";
            
        } else {
            echo "<h2>❌ No data found for ID 1</h2>";
            
            // Check if there are any data
            $count = ObjekWisata::count();
            echo "<p>Total records in objek_wisata table: {$count}</p>";
            
            if ($count > 0) {
                $first = ObjekWisata::first();
                echo "<p>First record ID: {$first->id}</p>";
                echo "<p>Available IDs: " . implode(', ', ObjekWisata::pluck('id')->toArray()) . "</p>";
            }
        }
        
    } catch (Exception $e) {
        echo "<h2>❌ Error: " . $e->getMessage() . "</h2>";
        echo "<pre>" . $e->getTraceAsString() . "</pre>";
    }
    ?>

</body>
</html>
