// Fix Cache Issues Script
// Run this in browser console or add to any page temporarily

console.log('🔧 Starting cache fix...');

async function fixCacheIssues() {
    try {
        // 1. Clear all caches
        console.log('1. Clearing all caches...');
        const cacheNames = await caches.keys();
        console.log('Found caches:', cacheNames);
        
        const deletePromises = cacheNames.map(cacheName => {
            console.log('Deleting cache:', cacheName);
            return caches.delete(cacheName);
        });
        
        await Promise.all(deletePromises);
        console.log('✅ All caches cleared');
        
        // 2. Unregister service workers
        if ('serviceWorker' in navigator) {
            console.log('2. Unregistering service workers...');
            const registrations = await navigator.serviceWorker.getRegistrations();
            console.log('Found service workers:', registrations.length);
            
            const unregisterPromises = registrations.map(registration => {
                console.log('Unregistering SW:', registration.scope);
                return registration.unregister();
            });
            
            await Promise.all(unregisterPromises);
            console.log('✅ All service workers unregistered');
        }
        
        // 3. Clear localStorage and sessionStorage
        console.log('3. Clearing storage...');
        localStorage.clear();
        sessionStorage.clear();
        console.log('✅ Storage cleared');
        
        // 4. Re-register service worker
        console.log('4. Re-registering service worker...');
        if ('serviceWorker' in navigator) {
            try {
                const registration = await navigator.serviceWorker.register('/sw.js', {
                    scope: '/'
                });
                console.log('✅ Service worker re-registered:', registration.scope);
            } catch (error) {
                console.warn('⚠️ Service worker registration failed:', error);
            }
        }
        
        console.log('🎉 Cache fix completed! Reloading page in 3 seconds...');
        
        // 5. Reload page
        setTimeout(() => {
            window.location.reload(true);
        }, 3000);
        
    } catch (error) {
        console.error('❌ Error fixing cache:', error);
    }
}

// Auto-run the fix
fixCacheIssues(); 