<?php
/**
 * Script untuk memperbaiki path UMKM di database
 * Akses via: https://susukannet.id/fix-umkm-paths.php
 */

// Include Laravel bootstrap
require_once __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Umkm;

echo "<h1>🔧 Fix UMKM Paths Script</h1>";

try {
    $umkmList = Umkm::all();
    
    echo "<h2>📋 Current UMKM Data</h2>";
    
    foreach ($umkmList as $umkm) {
        echo "<h3>UMKM: {$umkm->nama_umkm} (ID: {$umkm->id})</h3>";
        echo "<div class='info'>📋 Current logo: {$umkm->logo}</div>";
        echo "<div class='info'>📋 Current gallery: " . json_encode($umkm->galeri_foto) . "</div>";
        
        // Fix logo path
        if ($umkm->logo && strpos($umkm->logo, 'umkm/logo/') === 0) {
            // Remove the umkm/logo/ prefix if it exists
            $newLogo = str_replace('umkm/logo/', '', $umkm->logo);
            $umkm->logo = $newLogo;
            echo "<div class='success'>✅ Fixed logo path: {$newLogo}</div>";
        }
        
        // Fix gallery paths
        if ($umkm->galeri_foto && is_array($umkm->galeri_foto)) {
            $newGallery = [];
            foreach ($umkm->galeri_foto as $foto) {
                if (strpos($foto, 'umkm/galeri/') === 0) {
                    // Remove the umkm/galeri/ prefix if it exists
                    $newFoto = str_replace('umkm/galeri/', '', $foto);
                    $newGallery[] = $newFoto;
                    echo "<div class='success'>✅ Fixed gallery path: {$newFoto}</div>";
                } else {
                    $newGallery[] = $foto;
                }
            }
            $umkm->galeri_foto = $newGallery;
        }
        
        // Save the changes
        $umkm->save();
        echo "<div class='success'>✅ Saved changes for {$umkm->nama_umkm}</div>";
        echo "<br>";
    }
    
    echo "<hr>";
    
    // Test the fixed URLs
    echo "<h2>🧪 Test Fixed URLs</h2>";
    
    foreach ($umkmList as $umkm) {
        echo "<h3>Testing: {$umkm->nama_umkm}</h3>";
        
        $logoUrl = $umkm->logo_url;
        $galleryUrls = $umkm->galeri_foto_urls;
        
        echo "<div class='success'>✅ Logo URL: <a href='{$logoUrl}' target='_blank'>{$logoUrl}</a></div>";
        echo "<div class='success'>✅ Gallery URLs: " . count($galleryUrls) . " items</div>";
        
        foreach ($galleryUrls as $index => $url) {
            echo "<div class='info'>📋 Gallery {$index}: <a href='{$url}' target='_blank'>{$url}</a></div>";
        }
        
        echo "<br>";
    }
    
} catch (Exception $e) {
    echo "<div class='error'>❌ Error: " . $e->getMessage() . "</div>";
    echo "<div class='error'>❌ File: " . $e->getFile() . " Line: " . $e->getLine() . "</div>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h2>✅ Path Fix Completed</h2>";
echo "<p><a href='/admin/umkm'>Kembali ke Admin UMKM</a></p>";

?>
<style>
body { font-family: Arial, sans-serif; margin: 20px; }
.success { color: green; font-weight: bold; background: #d4edda; padding: 5px; border-radius: 3px; margin: 2px 0; }
.error { color: red; font-weight: bold; background: #f8d7da; padding: 5px; border-radius: 3px; margin: 2px 0; }
.info { color: blue; background: #d1ecf1; padding: 5px; border-radius: 3px; margin: 2px 0; }
pre { background: #f8f9fa; padding: 10px; border-radius: 3px; overflow-x: auto; }
</style>
