

<?php $__env->startSection('title', 'Detail Transaksi'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Detail Transaksi</h1>
        <a href="<?php echo e(route('admin.transaksi.index')); ?>" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Transaction Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Transaksi</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Kode Transaksi</strong></td>
                                    <td>: <?php echo e($transaksi->kode_transaksi); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Jenis Transaksi</strong></td>
                                    <td>: 
                                        <span class="badge badge-info">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $transaksi->jenis_transaksi))); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status</strong></td>
                                    <td>: 
                                        <?php if($transaksi->status === 'berhasil'): ?>
                                            <span class="badge badge-success">Berhasil</span>
                                        <?php elseif($transaksi->status === 'pending'): ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php elseif($transaksi->status === 'gagal'): ?>
                                            <span class="badge badge-danger">Gagal</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">Dibatalkan</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Total Bayar</strong></td>
                                    <td>: <span class="h6 text-primary">Rp <?php echo e(number_format($transaksi->total_bayar)); ?></span></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Metode Pembayaran</strong></td>
                                    <td>: <?php echo e($transaksi->metode_pembayaran ?? '-'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal Transaksi</strong></td>
                                    <td>: <?php echo e($transaksi->created_at->format('d/m/Y H:i')); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal Bayar</strong></td>
                                    <td>: <?php echo e($transaksi->tanggal_bayar ? $transaksi->tanggal_bayar->format('d/m/Y H:i') : '-'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Expired At</strong></td>
                                    <td>: <?php echo e($transaksi->tanggal_expired ? $transaksi->tanggal_expired->format('d/m/Y H:i') : '-'); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Pelanggan</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Nama</strong></td>
                                    <td>: <?php echo e($transaksi->nama_pelanggan); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Email</strong></td>
                                    <td>: <?php echo e($transaksi->email_pelanggan); ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Telepon</strong></td>
                                    <td>: <?php echo e($transaksi->telepon_pelanggan); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Alamat</strong></td>
                                    <td>: <?php echo e($transaksi->alamat_pelanggan ?? '-'); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transaction Details -->
            <?php if($transaksi->detail_transaksi): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Detail Item</h6>
                    </div>
                    <div class="card-body">
                        <?php
                            $details = is_array($transaksi->detail_transaksi) ? $transaksi->detail_transaksi : json_decode($transaksi->detail_transaksi, true);
                        ?>
                        <?php if($details): ?>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Item</th>
                                            <th>Harga</th>
                                            <th>Jumlah</th>
                                            <th>Subtotal</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($detail['nama'] ?? '-'); ?></td>
                                                <td>Rp <?php echo e(number_format($detail['harga'] ?? 0)); ?></td>
                                                <td><?php echo e($detail['jumlah'] ?? 1); ?></td>
                                                <td>Rp <?php echo e(number_format(($detail['harga'] ?? 0) * ($detail['jumlah'] ?? 1))); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Related Record -->
            <?php if($transaksi->tiketWisata): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Tiket Wisata</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h6><?php echo e($transaksi->tiketWisata->objekWisata->nama); ?></h6>
                                <p><strong>Kode Booking:</strong> <?php echo e($transaksi->tiketWisata->kode_booking); ?></p>
                                <p><strong>Tanggal Kunjungan:</strong> <?php echo e($transaksi->tiketWisata->tanggal_kunjungan->format('d/m/Y')); ?></p>
                                <p><strong>Pengunjung:</strong> <?php echo e($transaksi->tiketWisata->jumlah_dewasa + $transaksi->tiketWisata->jumlah_anak); ?> orang</p>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo e(route('admin.tiket-wisata.show', $transaksi->tiketWisata->id)); ?>" 
                                   class="btn btn-info btn-sm">
                                    <i class="fas fa-eye"></i> Lihat Detail Tiket
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Notes -->
            <?php if($transaksi->catatan): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Catatan</h6>
                    </div>
                    <div class="card-body">
                        <p><?php echo e($transaksi->catatan); ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Payment Gateway Info -->
            <?php if($transaksi->tripay_reference): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Info Payment Gateway</h6>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless table-sm">
                            <tr>
                                <td><strong>Reference</strong></td>
                                <td>: <?php echo e($transaksi->tripay_reference); ?></td>
                            </tr>
                            <?php if($transaksi->tripay_merchant_ref): ?>
                                <tr>
                                    <td><strong>Merchant Ref</strong></td>
                                    <td>: <?php echo e($transaksi->tripay_merchant_ref); ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if($transaksi->payment_url): ?>
                                <tr>
                                    <td><strong>Payment URL</strong></td>
                                    <td>: 
                                        <a href="<?php echo e($transaksi->payment_url); ?>" target="_blank" class="btn btn-link btn-sm p-0">
                                            Buka Link
                                        </a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Proof of Payment -->
            <?php if($transaksi->bukti_bayar): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Bukti Pembayaran</h6>
                    </div>
                    <div class="card-body text-center">
                        <img src="<?php echo e(Storage::url($transaksi->bukti_bayar)); ?>" 
                             alt="Bukti Pembayaran" 
                             class="img-fluid rounded"
                             data-toggle="modal" 
                             data-target="#proofModal"
                             style="cursor: pointer; max-height: 200px;">
                        <p class="mt-2 small text-muted">Klik untuk memperbesar</p>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Summary -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Ringkasan</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">Total Transaksi</small>
                        <div class="h5 text-primary">Rp <?php echo e(number_format($transaksi->total_bayar)); ?></div>
                    </div>
                    
                    <?php if($transaksi->biaya_admin > 0): ?>
                        <div class="mb-3">
                            <small class="text-muted">Biaya Admin</small>
                            <div>Rp <?php echo e(number_format($transaksi->biaya_admin)); ?></div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <small class="text-muted">Status Terakhir</small>
                        <div>
                            <?php if($transaksi->status === 'berhasil'): ?>
                                <span class="badge badge-success">Berhasil</span>
                            <?php elseif($transaksi->status === 'pending'): ?>
                                <span class="badge badge-warning">Pending</span>
                            <?php elseif($transaksi->status === 'gagal'): ?>
                                <span class="badge badge-danger">Gagal</span>
                            <?php else: ?>
                                <span class="badge badge-secondary">Dibatalkan</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <?php if($transaksi->status === 'pending'): ?>
                            <button class="btn btn-success btn-sm" onclick="confirmPayment()">
                                <i class="fas fa-check"></i> Konfirmasi Pembayaran
                            </button>
                            <button class="btn btn-warning btn-sm" onclick="cancelTransaction()">
                                <i class="fas fa-times"></i> Batalkan Transaksi
                            </button>
                        <?php endif; ?>
                        
                        <?php if($transaksi->status === 'berhasil' && $transaksi->jenis_transaksi === 'tiket_wisata'): ?>
                            <a href="<?php echo e(route('admin.tiket-wisata.print', $transaksi->tiket_wisata_id)); ?>" 
                               class="btn btn-info btn-sm" target="_blank">
                                <i class="fas fa-print"></i> Print Tiket
                            </a>
                        <?php endif; ?>

                        <button class="btn btn-secondary btn-sm" onclick="printInvoice()">
                            <i class="fas fa-file-pdf"></i> Print Invoice
                        </button>

                        <?php if($transaksi->tiketWisata): ?>
                            <a href="<?php echo e(route('admin.tiket-wisata.show', $transaksi->tiketWisata->id)); ?>" 
                               class="btn btn-info btn-sm">
                                <i class="fas fa-ticket-alt"></i> Lihat Tiket
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Proof Modal -->
<?php if($transaksi->bukti_bayar): ?>
    <div class="modal fade" id="proofModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Bukti Pembayaran</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img src="<?php echo e(Storage::url($transaksi->bukti_bayar)); ?>" 
                         alt="Bukti Pembayaran" 
                         class="img-fluid">
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function confirmPayment() {
    if (confirm('Konfirmasi pembayaran transaksi ini?')) {
        // Create form to confirm payment
        var form = $('<form>', {
            'method': 'POST',
            'action': '<?php echo e(route("admin.transaksi.confirm-payment", $transaksi->id)); ?>'
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': '<?php echo e(csrf_token()); ?>'}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        $('body').append(form);
        form.submit();
    }
}

function cancelTransaction() {
    if (confirm('Batalkan transaksi ini? Tindakan ini tidak dapat dibatalkan.')) {
        // Create form to cancel transaction
        var form = $('<form>', {
            'method': 'POST',
            'action': '<?php echo e(route("admin.transaksi.cancel", $transaksi->id)); ?>'
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': '<?php echo e(csrf_token()); ?>'}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        $('body').append(form);
        form.submit();
    }
}

function printInvoice() {
    window.open('<?php echo e(route("admin.transaksi.print", $transaksi->id)); ?>', '_blank');
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/transaksi/show.blade.php ENDPATH**/ ?>