

<?php $__env->startSection('title', 'Detail Data PBB'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Detail Data PBB - <?php echo e($pbb->formatted_nop); ?></h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('admin.pbb.edit', $pbb)); ?>" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('admin.pbb.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Data Objek Pajak -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Data Objek Pajak</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm">
                                        <tr>
                                            <td width="40%"><strong>NOP</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->formatted_nop); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>NIK Pemilik</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->nik); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Nama Pemilik</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->nama_pemilik); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Alamat Objek</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->alamat_objek); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Dusun</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->dusun ?? '-'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>RT/RW</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->rt ?? '-'); ?>/<?php echo e($pbb->rw ?? '-'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Status Objek</strong></td>
                                            <td>:</td>
                                            <td>
                                                <?php if($pbb->status_objek == 'Aktif'): ?>
                                                    <span class="badge badge-success"><?php echo e($pbb->status_objek); ?></span>
                                                <?php elseif($pbb->status_objek == 'Tidak Aktif'): ?>
                                                    <span class="badge badge-danger"><?php echo e($pbb->status_objek); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-warning"><?php echo e($pbb->status_objek); ?></span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php if($pbb->keterangan): ?>
                                        <tr>
                                            <td><strong>Keterangan</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->keterangan); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Data Tanah dan Bangunan -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Data Tanah dan Bangunan</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-sm">
                                        <tr>
                                            <td width="40%"><strong>Luas Tanah</strong></td>
                                            <td>:</td>
                                            <td><?php echo e(number_format($pbb->luas_tanah, 0, ',', '.')); ?> m²</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Luas Bangunan</strong></td>
                                            <td>:</td>
                                            <td><?php echo e(number_format($pbb->luas_bangunan, 0, ',', '.')); ?> m²</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Jenis Tanah</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->jenis_tanah); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Jenis Bangunan</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->jenis_bangunan); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>NJOP Tanah</strong></td>
                                            <td>:</td>
                                            <td>Rp <?php echo e(number_format($pbb->njop_tanah, 0, ',', '.')); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>NJOP Bangunan</strong></td>
                                            <td>:</td>
                                            <td>Rp <?php echo e(number_format($pbb->njop_bangunan, 0, ',', '.')); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>NJOP Total</strong></td>
                                            <td>:</td>
                                            <td><strong>Rp <?php echo e(number_format($pbb->njop_total, 0, ',', '.')); ?></strong></td>
                                        </tr>
                                        <tr>
                                            <td><strong>NJKP</strong></td>
                                            <td>:</td>
                                            <td>Rp <?php echo e(number_format($pbb->njkp, 0, ',', '.')); ?></td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>PBB Terhutang</strong></td>
                                            <td>:</td>
                                            <td><strong>Rp <?php echo e(number_format($pbb->pbb_terhutang, 0, ',', '.')); ?></strong></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Koordinat -->
                    <?php if($pbb->latitude && $pbb->longitude): ?>
                    <div class="card mt-3">
                        <div class="card-header">
                            <h5 class="card-title">Koordinat Lokasi</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-sm">
                                        <tr>
                                            <td width="30%"><strong>Latitude</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->latitude); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Longitude</strong></td>
                                            <td>:</td>
                                            <td><?php echo e($pbb->longitude); ?></td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <a href="https://maps.google.com?q=<?php echo e($pbb->latitude); ?>,<?php echo e($pbb->longitude); ?>" 
                                       target="_blank" class="btn btn-info btn-sm">
                                        <i class="fas fa-map-marker-alt"></i> Lihat di Google Maps
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Riwayat Tagihan -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h5 class="card-title">Riwayat Tagihan PBB</h5>
                            <div class="card-tools">
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modalBayar">
                                    <i class="fas fa-money-bill"></i> Catat Pembayaran
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if($pbb->tagihanPbb->count() > 0): ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Tahun Pajak</th>
                                                <th>Nilai Pajak</th>
                                                <th>Denda</th>
                                                <th>Total Tagihan</th>
                                                <th>Jumlah Bayar</th>
                                                <th>Sisa Tagihan</th>
                                                <th>Status</th>
                                                <th>Jatuh Tempo</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $pbb->tagihanPbb->sortByDesc('tahun_pajak'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tagihan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($tagihan->tahun_pajak); ?></td>
                                                    <td>Rp <?php echo e(number_format($tagihan->nilai_pajak, 0, ',', '.')); ?></td>
                                                    <td>Rp <?php echo e(number_format($tagihan->denda, 0, ',', '.')); ?></td>
                                                    <td>Rp <?php echo e(number_format($tagihan->total_tagihan, 0, ',', '.')); ?></td>
                                                    <td>Rp <?php echo e(number_format($tagihan->jumlah_bayar, 0, ',', '.')); ?></td>
                                                    <td>Rp <?php echo e(number_format($tagihan->sisa_tagihan, 0, ',', '.')); ?></td>
                                                    <td>
                                                        <span class="badge badge-<?php echo e($tagihan->status_badge_color); ?>">
                                                            <?php echo e($tagihan->status_bayar); ?>

                                                        </span>
                                                    </td>
                                                    <td>
                                                        <?php echo e($tagihan->jatuh_tempo ? $tagihan->jatuh_tempo->format('d/m/Y') : '-'); ?>

                                                        <?php if($tagihan->isJatuhTempo()): ?>
                                                            <br><small class="text-danger">Sudah Jatuh Tempo</small>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($tagihan->status_bayar !== 'Lunas'): ?>
                                                            <button type="button" class="btn btn-sm btn-success btn-bayar" 
                                                                    data-tahun="<?php echo e($tagihan->tahun_pajak); ?>"
                                                                    data-sisa="<?php echo e($tagihan->sisa_tagihan); ?>">
                                                                <i class="fas fa-money-bill"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                        <?php if($tagihan->nomor_kwitansi): ?>
                                                            <button type="button" class="btn btn-sm btn-info">
                                                                <i class="fas fa-receipt"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i> 
                                    Belum ada tagihan PBB yang dihasilkan untuk objek ini.
                                    <br>
                                    <small>Tagihan akan otomatis dibuat setiap tahun atau dapat dibuat manual oleh admin.</small>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Pembayaran -->
<div class="modal fade" id="modalBayar" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.pbb.bayar', $pbb)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Catat Pembayaran PBB</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="tahun_pajak">Tahun Pajak <span class="text-danger">*</span></label>
                        <select class="form-control" id="tahun_pajak" name="tahun_pajak" required>
                            <option value="">Pilih Tahun Pajak</option>
                            <?php for($year = now()->year; $year >= 2020; $year--): ?>
                                <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="jumlah_bayar">Jumlah Bayar (Rp) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="jumlah_bayar" name="jumlah_bayar" 
                               min="1" step="1" required>
                    </div>
                    <div class="form-group">
                        <label for="tanggal_bayar">Tanggal Bayar <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="tanggal_bayar" name="tanggal_bayar" 
                               value="<?php echo e(date('Y-m-d')); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="metode_bayar">Metode Pembayaran <span class="text-danger">*</span></label>
                        <select class="form-control" id="metode_bayar" name="metode_bayar" required>
                            <option value="">Pilih Metode</option>
                            <option value="Tunai">Tunai</option>
                            <option value="Transfer">Transfer Bank</option>
                            <option value="E-Wallet">E-Wallet</option>
                            <option value="QRIS">QRIS</option>
                            <option value="Lainnya">Lainnya</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="referensi_bayar">Nomor Referensi (Opsional)</label>
                        <input type="text" class="form-control" id="referensi_bayar" name="referensi_bayar" 
                               placeholder="Nomor transaksi/referensi">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save"></i> Simpan Pembayaran
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Handle quick payment button
    $('.btn-bayar').on('click', function() {
        var tahun = $(this).data('tahun');
        var sisa = $(this).data('sisa');
        
        $('#tahun_pajak').val(tahun);
        $('#jumlah_bayar').val(sisa);
        $('#modalBayar').modal('show');
    });
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/pbb/show.blade.php ENDPATH**/ ?>