

<?php $__env->startSection('title', 'Tambah Bantuan Sosial'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-plus me-2 text-primary"></i>Tambah Bantuan Sosial
            </h2>
            <p class="text-muted mb-0">Buat program bantuan sosial baru</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.bantuan.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-hand-holding-heart me-2"></i>Informasi Bantuan</h5>
                </div>
                <div class="card-body">
                    <form id="createBantuanForm">
                        <?php echo csrf_field(); ?>
                        
                        <div class="mb-3">
                            <label class="form-label">Jenis Bantuan</label>
                            <select class="form-select" name="jenis_bantuan" required>
                                <option value="">Pilih Jenis Bantuan</option>
                                <option value="blt">Bantuan Langsung Tunai (BLT)</option>
                                <option value="pkh">Program Keluarga Harapan (PKH)</option>
                                <option value="bpnt">Bantuan Pangan Non Tunai (BPNT)</option>
                                <option value="bansos">Bantuan Sosial</option>
                                <option value="bpjs">Bantuan BPJS</option>
                                <option value="lainnya">Lainnya</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Nama Program</label>
                            <input type="text" class="form-control" name="nama_program" required 
                                   placeholder="Masukkan nama program bantuan">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Deskripsi</label>
                            <textarea class="form-control" name="deskripsi" rows="4" 
                                      placeholder="Jelaskan detail program bantuan"></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Periode Mulai</label>
                                    <input type="date" class="form-control" name="periode_mulai" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Periode Selesai</label>
                                    <input type="date" class="form-control" name="periode_selesai">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah Bantuan</label>
                                    <input type="number" class="form-control" name="jumlah_bantuan" 
                                           placeholder="Nominal bantuan per penerima">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Satuan</label>
                                    <select class="form-select" name="satuan">
                                        <option value="rupiah">Rupiah</option>
                                        <option value="kg">Kilogram</option>
                                        <option value="liter">Liter</option>
                                        <option value="paket">Paket</option>
                                        <option value="unit">Unit</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Target Penerima</label>
                            <input type="number" class="form-control" name="target_penerima" 
                                   placeholder="Jumlah target penerima">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Sumber Dana</label>
                            <select class="form-select" name="sumber_dana">
                                <option value="">Pilih Sumber Dana</option>
                                <option value="apbd">APBD</option>
                                <option value="apbn">APBN</option>
                                <option value="csr">CSR</option>
                                <option value="swadaya">Swadaya Masyarakat</option>
                                <option value="lainnya">Lainnya</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Syarat & Ketentuan</label>
                            <textarea class="form-control" name="syarat_ketentuan" rows="4" 
                                      placeholder="Masukkan syarat dan ketentuan penerima bantuan"></textarea>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan Program Bantuan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Informasi</h6>
                </div>
                <div class="card-body">
                    <p class="text-muted">Form untuk menambah program bantuan sosial baru.</p>
                    
                    <div class="alert alert-info">
                        <h6 class="alert-heading">
                            <i class="fas fa-lightbulb me-2"></i>Tips
                        </h6>
                        <ul class="mb-0 small">
                            <li>Pastikan periode bantuan sudah benar</li>
                            <li>Isi syarat & ketentuan dengan jelas</li>
                            <li>Tentukan target penerima sesuai kuota</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Template Bantuan -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-file-alt me-2"></i>Template Bantuan</h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <a href="#" class="list-group-item list-group-item-action">
                            <i class="fas fa-download me-2"></i>Template Penerima BLT
                        </a>
                        <a href="#" class="list-group-item list-group-item-action">
                            <i class="fas fa-download me-2"></i>Template Penerima PKH
                        </a>
                        <a href="#" class="list-group-item list-group-item-action">
                            <i class="fas fa-download me-2"></i>Template Penerima BPNT
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('createBantuanForm').addEventListener('submit', function(e) {
    e.preventDefault();
    showToast('Program bantuan berhasil disimpan', 'success');
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/bantuan/create.blade.php ENDPATH**/ ?>