<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - Produk UMKM</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
</head>
<body class="bg-gray-50 min-h-screen">
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="bg-white shadow-sm border-b px-4 py-3">
            <div class="flex items-center">
                <button onclick="history.back()" class="mr-3 text-gray-600">
                    <i class="fas fa-arrow-left text-xl"></i>
                </button>
                <h1 class="text-lg font-semibold text-gray-800">Checkout</h1>
            </div>
        </div>

        <form action="<?php echo e(route('checkout.process')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            
            <!-- Order Summary -->
            <div class="px-4 py-4">
                <div class="bg-white rounded-xl shadow-lg p-4">
                    <h3 class="font-semibold text-gray-800 mb-4">Ringkasan Pesanan</h3>
                    
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center space-x-3 mb-4">
                        <img src="<?php echo e($item['produk']->gambar_utama ? asset('storage/' . $item['produk']->gambar_utama) : asset('images/no-image.png')); ?>" 
                             alt="<?php echo e($item['produk']->nama_produk); ?>" 
                             class="w-16 h-16 rounded-lg object-cover">
                        <div class="flex-1">
                            <h4 class="font-medium text-gray-800 text-sm"><?php echo e($item['produk']->nama_produk); ?></h4>
                            <p class="text-gray-600 text-xs"><?php echo e($item['quantity']); ?> x Rp <?php echo e(number_format($item['produk']->harga_akhir, 0, ',', '.')); ?></p>
                        </div>
                        <div class="text-right">
                            <span class="text-sm font-medium text-gray-800">Rp <?php echo e(number_format($item['subtotal'], 0, ',', '.')); ?></span>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                    <!-- Order totals -->
                    <div class="border-t pt-3 space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Subtotal</span>
                            <span class="text-gray-800">Rp <?php echo e(number_format($subtotal, 0, ',', '.')); ?></span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Ongkir</span>
                            <span class="text-gray-800">Rp <?php echo e(number_format($shippingCost, 0, ',', '.')); ?></span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Biaya Admin</span>
                            <span class="text-gray-800" id="admin-fee">Rp 0</span>
                        </div>
                        <div class="flex justify-between text-base font-semibold border-t pt-2">
                            <span class="text-gray-800">Total</span>
                            <span class="text-green-600" id="total-amount">Rp <?php echo e(number_format($total, 0, ',', '.')); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="px-4 mb-4">
                <div class="bg-white rounded-xl shadow-lg p-4">
                    <h3 class="font-semibold text-gray-800 mb-4">Informasi Pembeli</h3>
                    
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Nama Lengkap</label>
                            <input type="text" name="customer_name" required 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                   placeholder="Masukkan nama lengkap" value="<?php echo e(old('customer_name')); ?>">
                            <?php $__errorArgs = ['customer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                            <input type="email" name="customer_email" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                   placeholder="contoh@email.com" value="<?php echo e(old('customer_email')); ?>">
                            <?php $__errorArgs = ['customer_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">No. WhatsApp</label>
                            <input type="tel" name="customer_phone" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                   placeholder="08xxxxxxxxxx" value="<?php echo e(old('customer_phone')); ?>">
                            <?php $__errorArgs = ['customer_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Alamat Lengkap</label>
                            <textarea name="customer_address" rows="3" required
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                      placeholder="Masukkan alamat lengkap untuk pengiriman"><?php echo e(old('customer_address')); ?></textarea>
                            <?php $__errorArgs = ['customer_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Catatan (Opsional)</label>
                            <textarea name="notes" rows="2"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                      placeholder="Catatan khusus untuk pesanan"><?php echo e(old('notes')); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Method -->
            <div class="px-4 mb-4">
                <div class="bg-white rounded-xl shadow-lg p-4">
                    <h3 class="font-semibold text-gray-800 mb-4">Metode Pembayaran</h3>
                    
                    <?php
                        $groupedMethods = [];
                        foreach($paymentMethods as $method) {
                            $groupedMethods[$method['group']][] = $method;
                        }
                    ?>
                    
                    <?php $__currentLoopData = $groupedMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $groupMethods): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-4">
                        <h4 class="text-sm font-medium text-gray-700 mb-3"><?php echo e($groupName); ?></h4>
                        <div class="space-y-2">
                            <?php $__currentLoopData = $groupMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                                <input type="radio" name="payment_method" value="<?php echo e($method['code']); ?>" 
                                       class="payment-option" 
                                       data-fee="<?php echo e($method['fee'] ?? 0); ?>"
                                       data-fee-percentage="<?php echo e($method['fee_percentage'] ?? 0); ?>"
                                       <?php echo e(old('payment_method') == $method['code'] ? 'checked' : ''); ?>>
                                <div class="ml-3 flex items-center flex-1">
                                    <div class="w-8 h-8 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                        <?php if(filter_var($method['icon'], FILTER_VALIDATE_URL)): ?>
                                            <img src="<?php echo e($method['icon']); ?>" alt="<?php echo e($method['name']); ?>" class="w-6 h-6 object-contain">
                                        <?php else: ?>
                                            <i class="fas fa-credit-card text-gray-500 text-sm"></i>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex-1">
                                        <span class="text-sm font-medium text-gray-800"><?php echo e($method['name']); ?></span>
                                        <p class="text-xs text-gray-500">
                                            <?php if($method['fee'] > 0): ?>
                                                Biaya admin: Rp <?php echo e(number_format($method['fee'], 0, ',', '.')); ?>

                                            <?php elseif(isset($method['fee_percentage']) && $method['fee_percentage'] > 0): ?>
                                                Biaya admin: <?php echo e($method['fee_percentage']); ?>%
                                            <?php else: ?>
                                                Tanpa biaya admin
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                    <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <!-- Payment Button -->
            <div class="p-4">
                <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-xl font-semibold text-lg hover:bg-green-700 transition-colors">
                    Bayar Sekarang
                </button>
            </div>
        </form>

        <!-- Bottom spacing -->
        <div class="h-8"></div>
    </div>

    <script>
        // Calculate total with admin fee
        const paymentOptions = document.querySelectorAll('.payment-option');
        const adminFeeElement = document.getElementById('admin-fee');
        const totalAmountElement = document.getElementById('total-amount');
        
        const baseTotal = <?php echo e($total); ?>; // Base total without admin fee
        
        paymentOptions.forEach(option => {
            option.addEventListener('change', function() {
                if (this.checked) {
                    const fixedFee = parseInt(this.dataset.fee) || 0;
                    const feePercentage = parseFloat(this.dataset.feePercentage) || 0;
                    
                    let totalFee = 0;
                    if (fixedFee > 0) {
                        totalFee = fixedFee;
                    } else if (feePercentage > 0) {
                        totalFee = Math.round((baseTotal * feePercentage) / 100);
                    }
                    
                    const newTotal = baseTotal + totalFee;
                    
                    adminFeeElement.textContent = 'Rp ' + totalFee.toLocaleString('id-ID');
                    totalAmountElement.textContent = 'Rp ' + newTotal.toLocaleString('id-ID');
                }
            });
        });

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const paymentMethod = document.querySelector('input[name="payment_method"]:checked');
            
            if (!paymentMethod) {
                e.preventDefault();
                alert('Silakan pilih metode pembayaran');
                return false;
            }
        });

        // Show errors if any
        <?php if($errors->any()): ?>
            let errorMessage = 'Terjadi kesalahan:\n';
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                errorMessage += '- <?php echo e($error); ?>\n';
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            alert(errorMessage);
        <?php endif; ?>
    </script>
</body>
</html> <?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/frontend/checkout.blade.php ENDPATH**/ ?>