

<?php $__env->startSection('title', 'Tambah Data Keluarga'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.keluarga.index')); ?>">Data Keluarga</a></li>
    <li class="breadcrumb-item active">Tambah Keluarga</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-plus me-2 text-primary"></i>
                Tambah Data Keluarga
            </h2>
            <p class="text-muted mb-0">Buat data keluarga baru dan tentukan kepala keluarga</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.keluarga.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <form id="createKeluargaForm">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-users me-2"></i>Informasi Keluarga
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- No KK -->
                        <div class="mb-4">
                            <label class="form-label required">Nomor Kartu Keluarga</label>
                            <input type="text" class="form-control form-control-lg" name="no_kk" 
                                   placeholder="Masukkan 16 digit nomor KK..." required
                                   pattern="[0-9]{16}" maxlength="16">
                            <div class="form-text">
                                <i class="fas fa-info-circle me-1"></i>Nomor KK harus 16 digit angka
                            </div>
                        </div>
                        
                        <!-- Kepala Keluarga -->
                        <div class="mb-4">
                            <label class="form-label required">Kepala Keluarga</label>
                            <select class="form-select" name="kepala_keluarga_id" required id="kepalaKeluargaSelect">
                                <option value="">Pilih Kepala Keluarga</option>
                                <!-- Options will be loaded via AJAX -->
                            </select>
                            <div class="form-text">Pilih warga yang akan menjadi kepala keluarga</div>
                        </div>
                        
                        <!-- Alamat -->
                        <div class="mb-4">
                            <label class="form-label required">Alamat Keluarga</label>
                            <textarea class="form-control" name="alamat" rows="3" required
                                      placeholder="Masukkan alamat lengkap keluarga..." id="alamatInput"></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-4">
                                    <label class="form-label required">Dusun</label>
                                    <select class="form-select" name="dusun" required>
                                        <option value="">Pilih Dusun</option>
                                        <option value="Dusun 1">Dusun 1</option>
                                        <option value="Dusun 2">Dusun 2</option>
                                        <option value="Dusun 3">Dusun 3</option>
                                        <option value="Dusun 4">Dusun 4</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-4">
                                    <label class="form-label required">RT</label>
                                    <input type="text" class="form-control" name="rt" required placeholder="001" maxlength="3">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-4">
                                    <label class="form-label required">RW</label>
                                    <input type="text" class="form-control" name="rw" required placeholder="001" maxlength="3">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-4">
                                    <label class="form-label">Kode Pos</label>
                                    <input type="text" class="form-control" name="kode_pos" placeholder="12345" maxlength="5">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-user me-2"></i>Info Kepala Keluarga
                        </h6>
                    </div>
                    <div class="card-body" id="kepalaKeluargaInfo">
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-user fa-3x mb-3"></i>
                            <p>Pilih kepala keluarga untuk melihat informasi</p>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan Keluarga
                            </button>
                            <button type="button" class="btn btn-outline-warning" onclick="resetForm()">
                                <i class="fas fa-refresh me-2"></i>Reset Form
                            </button>
                            <a href="<?php echo e(route('admin.keluarga.index')); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-times me-2"></i>Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    loadPendudukOptions();
    
    $('#kepalaKeluargaSelect').on('change', function() {
        updateKepalaKeluargaInfo();
    });
});

function loadPendudukOptions() {
    fetch('/admin/penduduk/list')
        .then(response => response.json())
        .then(data => {
            const select = document.getElementById('kepalaKeluargaSelect');
            select.innerHTML = '<option value="">Pilih Kepala Keluarga</option>';
            
            data.forEach(penduduk => {
                const option = document.createElement('option');
                option.value = penduduk.id;
                option.textContent = `${penduduk.nama} - ${penduduk.nik}`;
                option.dataset.alamat = penduduk.alamat || '';
                select.appendChild(option);
            });
        })
        .catch(error => console.error('Error loading penduduk:', error));
}

function updateKepalaKeluargaInfo() {
    const select = document.getElementById('kepalaKeluargaSelect');
    const selectedOption = select.options[select.selectedIndex];
    
    if (selectedOption.value) {
        const nama = selectedOption.textContent.split(' - ')[0];
        const alamat = selectedOption.dataset.alamat;
        
        document.getElementById('kepalaKeluargaInfo').innerHTML = `
            <div class="text-center">
                <div class="avatar bg-primary text-white mx-auto mb-3" style="width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-user fa-lg"></i>
                </div>
                <h6 class="mb-2">${nama}</h6>
                <p class="text-muted small mb-0">${alamat || 'Alamat belum diisi'}</p>
            </div>
        `;
        
        // Auto-fill alamat if available
        if (alamat) {
            document.getElementById('alamatInput').value = alamat;
        }
    } else {
        document.getElementById('kepalaKeluargaInfo').innerHTML = `
            <div class="text-center text-muted py-4">
                <i class="fas fa-user fa-3x mb-3"></i>
                <p>Pilih kepala keluarga untuk melihat informasi</p>
            </div>
        `;
    }
}

function resetForm() {
    if (confirm('Apakah Anda yakin ingin mereset form?')) {
        document.getElementById('createKeluargaForm').reset();
        updateKepalaKeluargaInfo();
        showToast('Form berhasil direset', 'info');
    }
}

document.getElementById('createKeluargaForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo e(route("admin.keluarga.store")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Data keluarga berhasil disimpan', 'success');
            setTimeout(() => {
                window.location.href = '<?php echo e(route("admin.keluarga.index")); ?>';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal menyimpan data', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/keluarga/create.blade.php ENDPATH**/ ?>