

<?php $__env->startSection('title', 'Statistik Kunjungan Wisata'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Statistik Kunjungan Wisata</h1>
        <div class="d-sm-flex">
            <form method="GET" action="<?php echo e(route('admin.wisata.statistik')); ?>" class="d-flex">
                <select name="year" class="form-control mr-2">
                    <?php for($y = now()->year; $y >= now()->year - 5; $y--): ?>
                        <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                    <?php endfor; ?>
                </select>
                <select name="month" class="form-control mr-2">
                    <option value="">Semua Bulan</option>
                    <?php for($m = 1; $m <= 12; $m++): ?>
                        <option value="<?php echo e($m); ?>" <?php echo e($month == $m ? 'selected' : ''); ?>>
                            <?php echo e(now()->setMonth($m)->format('F')); ?>

                        </option>
                    <?php endfor; ?>
                </select>
                <button type="submit" class="btn btn-primary">Filter</button>
            </form>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Pengunjung</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(number_format($overallStats['total_pengunjung'])); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Pendapatan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rp <?php echo e(number_format($overallStats['total_pendapatan'])); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Tiket Terjual</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(number_format($overallStats['total_tiket'])); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-ticket-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Objek Wisata Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(number_format($overallStats['objek_wisata_aktif'])); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-map-marker-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row">
        <!-- Visitor Chart -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Grafik Pengunjung Bulanan <?php echo e($year); ?></h6>
                </div>
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="visitorChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue Chart -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Pendapatan per Bulan</h6>
                </div>
                <div class="card-body">
                    <div class="chart-pie pt-4 pb-2">
                        <canvas id="revenueChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Tables -->
    <div class="row">
        <!-- Monthly Statistics Table -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Statistik Bulanan <?php echo e($year); ?></h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Bulan</th>
                                    <th>Pengunjung</th>
                                    <th>Pendapatan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $monthlyStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($stat['nama_bulan']); ?></td>
                                    <td><?php echo e(number_format($stat['pengunjung'])); ?></td>
                                    <td>Rp <?php echo e(number_format($stat['pendapatan'])); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Tourism Objects -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Objek Wisata Terpopuler</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th>Objek Wisata</th>
                                    <th>Pengunjung</th>
                                    <th>Pendapatan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $objekWisataStats->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $objek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="font-weight-bold"><?php echo e($objek['nama']); ?></div>
                                        <small class="text-muted"><?php echo e(ucfirst(str_replace('_', ' ', $objek['kategori']))); ?></small>
                                    </td>
                                    <td><?php echo e(number_format($objek['total_pengunjung'])); ?></td>
                                    <td>Rp <?php echo e(number_format($objek['total_pendapatan'])); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($objekWisataStats->count() == 0): ?>
                                <tr>
                                    <td colspan="3" class="text-center">Tidak ada data</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Statistics Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Detail Statistik Semua Objek Wisata</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Objek Wisata</th>
                            <th>Kategori</th>
                            <th>Total Tiket</th>
                            <th>Total Pengunjung</th>
                            <th>Total Pendapatan</th>
                            <th>Rata-rata per Tiket</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $objekWisataStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $objek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td class="font-weight-bold"><?php echo e($objek['nama']); ?></td>
                            <td>
                                <span class="badge badge-info"><?php echo e(ucfirst(str_replace('_', ' ', $objek['kategori']))); ?></span>
                            </td>
                            <td><?php echo e(number_format($objek['total_tiket'])); ?></td>
                            <td><?php echo e(number_format($objek['total_pengunjung'])); ?></td>
                            <td>Rp <?php echo e(number_format($objek['total_pendapatan'])); ?></td>
                            <td>
                                <?php if($objek['total_tiket'] > 0): ?>
                                    Rp <?php echo e(number_format($objek['total_pendapatan'] / $objek['total_tiket'])); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($objekWisataStats->count() == 0): ?>
                        <tr>
                            <td colspan="7" class="text-center">Tidak ada data untuk periode yang dipilih</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Visitor Chart
const visitorCtx = document.getElementById('visitorChart').getContext('2d');
const visitorChart = new Chart(visitorCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode(collect($monthlyStats)->pluck('singkatan_bulan')); ?>,
        datasets: [{
            label: 'Pengunjung',
            data: <?php echo json_encode(collect($monthlyStats)->pluck('pengunjung')); ?>,
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Revenue Chart
const revenueCtx = document.getElementById('revenueChart').getContext('2d');
const revenueData = <?php echo json_encode(collect($monthlyStats)->where('pendapatan', '>', 0)); ?>;
const revenueChart = new Chart(revenueCtx, {
    type: 'doughnut',
    data: {
        labels: revenueData.map(item => item.singkatan_bulan),
        datasets: [{
            data: revenueData.map(item => item.pendapatan),
            backgroundColor: [
                '#FF6384',
                '#36A2EB',
                '#FFCE56',
                '#4BC0C0',
                '#9966FF',
                '#FF9F40',
                '#FF6384',
                '#C9CBCF',
                '#4BC0C0',
                '#FF6384',
                '#36A2EB',
                '#FFCE56'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});

// DataTable initialization
$(document).ready(function() {
    $('#dataTable').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.21/i18n/Indonesian.json"
        },
        "order": [[ 4, "desc" ]], // Sort by total pengunjung descending
        "pageLength": 25
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/objek-wisata/statistik.blade.php ENDPATH**/ ?>