<?php
/**
 * Test script untuk update objek wisata
 * Akses via: https://susukannet.id/test-objek-wisata-update.php
 */

// Include Laravel bootstrap
require_once __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ObjekWisata;
use App\Services\FileUploadService;
use Illuminate\Support\Facades\Storage;

echo "<h1>Test Update Objek Wisata</h1>";

try {
    // Get first tourism object
    $objekWisata = ObjekWisata::first();
    
    if (!$objekWisata) {
        echo "<div class='error'>❌ Tidak ada objek wisata ditemukan</div>";
        exit;
    }
    
    echo "<div class='success'>✅ Objek wisata ditemukan: {$objekWisata->nama_wisata}</div>";
    echo "<div class='info'>📋 ID: {$objekWisata->id}</div>";
    echo "<div class='info'>📋 Foto utama saat ini: " . ($objekWisata->foto_utama ?: 'Tidak ada') . "</div>";
    
    // Test file upload service
    echo "<h2>Test File Upload Service</h2>";
    
    $uploadService = new FileUploadService();
    
    // Create a test image file
    $testImagePath = __DIR__ . '/test-image.jpg';
    if (!file_exists($testImagePath)) {
        // Create a simple test image
        $image = imagecreate(100, 100);
        $bg = imagecolorallocate($image, 255, 255, 255);
        $text = imagecolorallocate($image, 0, 0, 0);
        imagestring($image, 5, 20, 40, 'TEST', $text);
        imagejpeg($image, $testImagePath, 90);
        imagedestroy($image);
        echo "<div class='info'>📋 Test image created</div>";
    }
    
    // Test upload
    $testFile = new \Illuminate\Http\UploadedFile(
        $testImagePath,
        'test-image.jpg',
        'image/jpeg',
        null,
        true
    );
    
    $uploadResult = $uploadService->uploadPhotoWithResize($testFile, 'wisata');
    
    if ($uploadResult['success']) {
        echo "<div class='success'>✅ Upload test berhasil: {$uploadResult['filename']}</div>";
        echo "<div class='info'>📋 Path: {$uploadResult['path']}</div>";
        
        // Test update objek wisata
        echo "<h2>Test Update Objek Wisata</h2>";
        
        $updateData = [
            'nama_wisata' => $objekWisata->nama_wisata . ' (Updated)',
            'kategori_wisata' => $objekWisata->kategori_wisata,
            'deskripsi' => $objekWisata->deskripsi,
            'alamat' => $objekWisata->alamat,
            'harga_tiket_dewasa' => $objekWisata->harga_tiket_dewasa,
            'harga_tiket_anak' => $objekWisata->harga_tiket_anak,
            'latitude' => $objekWisata->latitude,
            'longitude' => $objekWisata->longitude,
            'foto_utama' => $uploadResult['filename'],
            'last_updated_by' => 1
        ];
        
        $updateResult = $objekWisata->update($updateData);
        
        if ($updateResult) {
            echo "<div class='success'>✅ Update objek wisata berhasil</div>";
            
            // Refresh model
            $objekWisata->refresh();
            echo "<div class='info'>📋 Foto utama setelah update: {$objekWisata->foto_utama}</div>";
            echo "<div class='info'>📋 URL foto: {$objekWisata->foto_utama_url}</div>";
            
            // Test file exists
            $filePath = storage_path('app/public/wisata/' . $objekWisata->foto_utama);
            if (file_exists($filePath)) {
                echo "<div class='success'>✅ File foto tersimpan di: {$filePath}</div>";
            } else {
                echo "<div class='error'>❌ File foto tidak ditemukan di: {$filePath}</div>";
            }
            
        } else {
            echo "<div class='error'>❌ Update objek wisata gagal</div>";
        }
        
    } else {
        echo "<div class='error'>❌ Upload test gagal: {$uploadResult['error']}</div>";
    }
    
    // Clean up test file
    if (file_exists($testImagePath)) {
        unlink($testImagePath);
        echo "<div class='info'>📋 Test image cleaned up</div>";
    }
    
} catch (Exception $e) {
    echo "<div class='error'>❌ Error: " . $e->getMessage() . "</div>";
    echo "<div class='error'>❌ Stack trace: " . $e->getTraceAsString() . "</div>";
}

echo "<h2>Test Selesai</h2>";
echo "<p><a href='/admin/objek-wisata'>Kembali ke Admin Objek Wisata</a></p>";

?>
<style>
.success { color: green; font-weight: bold; }
.error { color: red; font-weight: bold; }
.info { color: blue; }
</style>
