<?php
/**
 * Script untuk menguji URL gambar UMKM
 * Akses: https://yourdomain.com/test-umkm-images.php
 */

echo "<h2>=== Test UMKM Images ===</h2>";

// Test URLs
$baseUrl = 'https://' . $_SERVER['HTTP_HOST'];
$testUrls = [
    'Sample Logo' => $baseUrl . '/storage/umkm/logo/sample-logo.png',
    'Sample Gallery' => $baseUrl . '/storage/umkm/galeri/sample-gallery1.png',
    'Default Logo' => $baseUrl . '/images/default-umkm-logo.png',
    'Direct Storage Logo' => $baseUrl . '/storage/app/public/umkm/logo/sample-logo.png',
    'Direct Storage Gallery' => $baseUrl . '/storage/app/public/umkm/galeri/sample-gallery1.png'
];

echo "<h3>Testing Image URLs:</h3>";
echo "<table border='1' cellpadding='10' cellspacing='0'>";
echo "<tr><th>Description</th><th>URL</th><th>Status</th><th>Preview</th></tr>";

foreach ($testUrls as $description => $url) {
    echo "<tr>";
    echo "<td><strong>$description</strong></td>";
    echo "<td><a href='$url' target='_blank'>$url</a></td>";
    
    // Test if URL is accessible
    $headers = @get_headers($url);
    $status = $headers && strpos($headers[0], '200') ? 'OK' : 'ERROR';
    $statusColor = $status === 'OK' ? 'green' : 'red';
    
    echo "<td style='color: $statusColor;'><strong>$status</strong></td>";
    
    if ($status === 'OK') {
        echo "<td><img src='$url' style='max-width: 100px; max-height: 100px; border: 1px solid #ccc;' onerror='this.style.display=\"none\";'></td>";
    } else {
        echo "<td style='color: red;'>Image not accessible</td>";
    }
    
    echo "</tr>";
}

echo "</table>";

// Test file existence
echo "<h3>File System Check:</h3>";
echo "<table border='1' cellpadding='10' cellspacing='0'>";
echo "<tr><th>Path</th><th>Exists</th><th>Size</th></tr>";

$testPaths = [
    'Storage Logo' => __DIR__ . '/../storage/app/public/umkm/logo/sample-logo.png',
    'Storage Gallery' => __DIR__ . '/../storage/app/public/umkm/galeri/sample-gallery1.png',
    'Public Storage Logo' => __DIR__ . '/storage/umkm/logo/sample-logo.png',
    'Public Storage Gallery' => __DIR__ . '/storage/umkm/galeri/sample-gallery1.png',
    'Default Image' => __DIR__ . '/images/default-umkm-logo.png'
];

foreach ($testPaths as $description => $path) {
    echo "<tr>";
    echo "<td><strong>$description</strong></td>";
    echo "<td>" . (file_exists($path) ? '<span style="color: green;">YES</span>' : '<span style="color: red;">NO</span>') . "</td>";
    echo "<td>" . (file_exists($path) ? filesize($path) . ' bytes' : 'N/A') . "</td>";
    echo "</tr>";
}

echo "</table>";

// Database check
echo "<h3>Database Check:</h3>";
try {
    $config = include(__DIR__ . '/../config/database.php');
    $mysql = $config['connections']['mysql'];
    
    $pdo = new PDO(
        "mysql:host={$mysql['host']};dbname={$mysql['database']};charset=utf8mb4",
        $mysql['username'],
        $mysql['password'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    $stmt = $pdo->query("SELECT id, nama_umkm, logo, galeri_foto FROM umkm WHERE logo IS NOT NULL OR galeri_foto IS NOT NULL LIMIT 5");
    $umkms = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($umkms) {
        echo "<table border='1' cellpadding='10' cellspacing='0'>";
        echo "<tr><th>ID</th><th>Nama UMKM</th><th>Logo</th><th>Galeri Count</th><th>Test URLs</th></tr>";
        
        foreach ($umkms as $umkm) {
            echo "<tr>";
            echo "<td>" . $umkm['id'] . "</td>";
            echo "<td>" . htmlspecialchars($umkm['nama_umkm']) . "</td>";
            echo "<td>" . ($umkm['logo'] ? htmlspecialchars($umkm['logo']) : 'No logo') . "</td>";
            
            $galeriCount = 0;
            if ($umkm['galeri_foto']) {
                $galeri = json_decode($umkm['galeri_foto'], true);
                $galeriCount = is_array($galeri) ? count($galeri) : 0;
            }
            echo "<td>$galeriCount</td>";
            
            echo "<td>";
            if ($umkm['logo']) {
                $logoUrl = $baseUrl . '/storage/umkm/logo/' . $umkm['logo'];
                echo "<a href='$logoUrl' target='_blank'>Test Logo</a><br>";
            }
            if ($galeriCount > 0) {
                $galeri = json_decode($umkm['galeri_foto'], true);
                if (is_array($galeri) && count($galeri) > 0) {
                    $galleryUrl = $baseUrl . '/storage/umkm/galeri/' . $galeri[0];
                    echo "<a href='$galleryUrl' target='_blank'>Test Gallery</a>";
                }
            }
            echo "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: orange;'>No UMKM with images found in database</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Database error: " . htmlspecialchars($e->getMessage()) . "</p>";
}

echo "<h3>Recommendations:</h3>";
echo "<ul>";
echo "<li>If images show 'ERROR', check file permissions and .htaccess files</li>";
echo "<li>If database shows UMKM with images but URLs fail, check filename encoding</li>";
echo "<li>Make sure storage symlink is working: <code>php artisan storage:link</code></li>";
echo "<li>Check .htaccess files in storage directories allow image access</li>";
echo "</ul>";

echo "<p><strong>Test completed!</strong> Check the results above to identify any issues.</p>";
?>
