@extends('layouts.admin')

@section('title', 'Arsip Surat Keluar')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">
                            <i class="fas fa-file-export me-2"></i>
                            Arsip Surat Keluar
                        </h3>
                        <a href="{{ route('admin.arsip-surat-keluar.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>
                            Tambah Surat Keluar
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Filter -->
                    <div class="row mb-3">
                        <div class="col-md-3">
                            <select class="form-control" name="tipe_surat" id="filter-tipe">
                                <option value="">Semua Tipe Surat</option>
                                <option value="Surat Keterangan">Surat Keterangan</option>
                                <option value="Surat Pengantar">Surat Pengantar</option>
                                <option value="Surat Izin">Surat Izin</option>
                                <option value="Surat Undangan">Surat Undangan</option>
                                <option value="Surat Edaran">Surat Edaran</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" name="tahun" id="filter-tahun">
                                <option value="">Semua Tahun</option>
                                @for($i = now()->year; $i >= 2020; $i--)
                                    <option value="{{ $i }}">{{ $i }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-4">
                            <input type="text" class="form-control" placeholder="Cari nomor surat, perihal, atau tujuan..." id="search">
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-outline-secondary" id="btn-filter">
                                <i class="fas fa-search"></i> Filter
                            </button>
                        </div>
                    </div>

                    <!-- Tabel -->
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>No</th>
                                    <th>Nomor Surat</th>
                                    <th>Tipe Surat</th>
                                    <th>Perihal</th>
                                    <th>Tujuan</th>
                                    <th>Tanggal</th>
                                    <th>File</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($suratKeluar as $index => $surat)
                                <tr>
                                    <td>{{ $suratKeluar->firstItem() + $index }}</td>
                                    <td>
                                        <strong>{{ $surat->nomor_surat }}</strong>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ $surat->tipe_surat }}</span>
                                    </td>
                                    <td>{{ Str::limit($surat->perihal, 50) }}</td>
                                    <td>{{ Str::limit($surat->tujuan, 30) }}</td>
                                    <td>{{ $surat->tanggal_surat->format('d/m/Y') }}</td>
                                    <td>
                                        @if($surat->file_surat)
                                            <a href="{{ route('admin.arsip-surat-keluar.download', $surat) }}" 
                                               class="btn btn-sm btn-outline-primary" target="_blank">
                                                <i class="fas fa-download"></i>
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.arsip-surat-keluar.show', $surat) }}" 
                                               class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.arsip-surat-keluar.edit', $surat) }}" 
                                               class="btn btn-sm btn-outline-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.arsip-surat-keluar.destroy', $surat) }}" 
                                                  method="POST" class="d-inline" 
                                                  onsubmit="return confirm('Yakin ingin menghapus surat ini?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <br>
                                        <span class="text-muted">Belum ada arsip surat keluar</span>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $suratKeluar->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show position-fixed" 
     style="top: 20px; right: 20px; z-index: 9999;" role="alert">
    <i class="fas fa-check-circle me-2"></i>
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
@endif

<script>
document.addEventListener('DOMContentLoaded', function() {
    const filterTipe = document.getElementById('filter-tipe');
    const filterTahun = document.getElementById('filter-tahun');
    const search = document.getElementById('search');
    const btnFilter = document.getElementById('btn-filter');

    function applyFilter() {
        const params = new URLSearchParams();
        
        if (filterTipe.value) params.append('tipe_surat', filterTipe.value);
        if (filterTahun.value) params.append('tahun', filterTahun.value);
        if (search.value) params.append('search', search.value);
        
        window.location.href = '{{ route("admin.arsip-surat-keluar.index") }}?' + params.toString();
    }

    btnFilter.addEventListener('click', applyFilter);
    search.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') applyFilter();
    });

    // Set filter values from URL
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('tipe_surat')) filterTipe.value = urlParams.get('tipe_surat');
    if (urlParams.get('tahun')) filterTahun.value = urlParams.get('tahun');
    if (urlParams.get('search')) search.value = urlParams.get('search');
});
</script>
@endsection 