@extends('layouts.app')

@section('title', 'Detail Arsip Surat Keluar')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">
                            <i class="fas fa-file-export me-2"></i>
                            Detail Arsip Surat Keluar
                        </h3>
                        <div>
                            <a href="{{ route('admin.arsip-surat-keluar.edit', $arsipSuratKeluar) }}" class="btn btn-warning">
                                <i class="fas fa-edit me-1"></i>
                                Edit
                            </a>
                            <a href="{{ route('admin.arsip-surat-keluar.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i>
                                Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="200" class="fw-bold">Nomor Surat</td>
                                    <td>: {{ $arsipSuratKeluar->nomor_surat }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tipe Surat</td>
                                    <td>: <span class="badge bg-info">{{ $arsipSuratKeluar->tipe_surat }}</span></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Perihal</td>
                                    <td>: {{ $arsipSuratKeluar->perihal }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tujuan</td>
                                    <td>: {{ $arsipSuratKeluar->tujuan }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tanggal Surat</td>
                                    <td>: {{ $arsipSuratKeluar->tanggal_surat->format('d F Y') }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Dibuat Oleh</td>
                                    <td>: {{ $arsipSuratKeluar->creator->name ?? 'System' }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tanggal Dibuat</td>
                                    <td>: {{ $arsipSuratKeluar->created_at->format('d F Y H:i') }}</td>
                                </tr>
                                @if($arsipSuratKeluar->keterangan)
                                <tr>
                                    <td class="fw-bold">Keterangan</td>
                                    <td>: {{ $arsipSuratKeluar->keterangan }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>

                        <div class="col-md-4">
                            <div class="card border">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">
                                        <i class="fas fa-file-alt me-2"></i>
                                        File Surat
                                    </h6>
                                </div>
                                <div class="card-body text-center">
                                    @if($arsipSuratKeluar->file_surat)
                                        <div class="mb-3">
                                            <i class="fas fa-file-pdf fa-4x text-danger"></i>
                                        </div>
                                        <div class="d-grid gap-2">
                                            <a href="{{ route('admin.arsip-surat-keluar.download', $arsipSuratKeluar) }}" 
                                               class="btn btn-primary" target="_blank">
                                                <i class="fas fa-download me-1"></i>
                                                Download File
                                            </a>
                                            <a href="{{ route('admin.arsip-surat-keluar.download', $arsipSuratKeluar) }}?view=1" 
                                               class="btn btn-outline-primary" target="_blank">
                                                <i class="fas fa-eye me-1"></i>
                                                Lihat File
                                            </a>
                                        </div>
                                    @else
                                        <div class="text-muted">
                                            <i class="fas fa-file-times fa-4x mb-3"></i>
                                            <p>File tidak tersedia</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-between">
                        <div>
                            <small class="text-muted">
                                Terakhir diubah: {{ $arsipSuratKeluar->updated_at->format('d F Y H:i') }}
                            </small>
                        </div>
                        <div>
                            <form action="{{ route('admin.arsip-surat-keluar.destroy', $arsipSuratKeluar) }}" 
                                  method="POST" 
                                  onsubmit="return confirm('Yakin ingin menghapus arsip surat ini?')"
                                  class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                    <i class="fas fa-trash me-1"></i>
                                    Hapus
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 