@extends('layouts.app')

@section('title', 'Edit Inventaris Desa')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.inventaris-desa.index') }}">Inventaris Desa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.inventaris-desa.show', $inventarisDesa) }}">Detail</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-edit me-2"></i>
                    Edit Inventaris Desa
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.inventaris-desa.update', $inventarisDesa) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <!-- Informasi Dasar -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-info-circle me-2"></i>
                                Informasi Dasar
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Kode Inventaris</label>
                                <input type="text" class="form-control" value="{{ $inventarisDesa->kode_inventaris }}" readonly>
                                <small class="text-muted">Kode inventaris tidak dapat diubah</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nama Barang <span class="text-danger">*</span></label>
                                <input type="text" name="nama_barang" class="form-control @error('nama_barang') is-invalid @enderror" 
                                       value="{{ old('nama_barang', $inventarisDesa->nama_barang) }}" required>
                                @error('nama_barang')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Kategori <span class="text-danger">*</span></label>
                                <select name="kategori" class="form-select @error('kategori') is-invalid @enderror" required>
                                    <option value="">Pilih Kategori</option>
                                    @foreach($kategori as $kat)
                                        <option value="{{ $kat }}" {{ old('kategori', $inventarisDesa->kategori) == $kat ? 'selected' : '' }}>{{ $kat }}</option>
                                    @endforeach
                                </select>
                                @error('kategori')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Merk/Tipe</label>
                                <input type="text" name="merk_tipe" class="form-control @error('merk_tipe') is-invalid @enderror" 
                                       value="{{ old('merk_tipe', $inventarisDesa->merk_tipe) }}">
                                @error('merk_tipe')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tahun Perolehan</label>
                                <input type="number" name="tahun_perolehan" class="form-control @error('tahun_perolehan') is-invalid @enderror" 
                                       value="{{ old('tahun_perolehan', $inventarisDesa->tahun_perolehan) }}" min="1900" max="{{ date('Y') }}">
                                @error('tahun_perolehan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Deskripsi</label>
                                <textarea name="deskripsi" class="form-control @error('deskripsi') is-invalid @enderror" rows="3">{{ old('deskripsi', $inventarisDesa->deskripsi) }}</textarea>
                                @error('deskripsi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Informasi Finansial -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-money-bill-wave me-2"></i>
                                Informasi Finansial
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Harga Perolehan <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" name="harga_perolehan" class="form-control @error('harga_perolehan') is-invalid @enderror" 
                                           value="{{ old('harga_perolehan', $inventarisDesa->harga_perolehan) }}" min="0" step="0.01" required>
                                </div>
                                @error('harga_perolehan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nilai Sekarang</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" name="nilai_sekarang" class="form-control @error('nilai_sekarang') is-invalid @enderror" 
                                           value="{{ old('nilai_sekarang', $inventarisDesa->nilai_sekarang) }}" min="0" step="0.01">
                                </div>
                                @error('nilai_sekarang')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Sumber Dana</label>
                                <select name="sumber_dana" class="form-select @error('sumber_dana') is-invalid @enderror">
                                    <option value="">Pilih Sumber Dana</option>
                                    <option value="APBDes" {{ old('sumber_dana', $inventarisDesa->sumber_dana) == 'APBDes' ? 'selected' : '' }}>APBDes</option>
                                    <option value="Bantuan Pemerintah" {{ old('sumber_dana', $inventarisDesa->sumber_dana) == 'Bantuan Pemerintah' ? 'selected' : '' }}>Bantuan Pemerintah</option>
                                    <option value="Swadaya" {{ old('sumber_dana', $inventarisDesa->sumber_dana) == 'Swadaya' ? 'selected' : '' }}>Swadaya</option>
                                    <option value="Hibah" {{ old('sumber_dana', $inventarisDesa->sumber_dana) == 'Hibah' ? 'selected' : '' }}>Hibah</option>
                                    <option value="Lainnya" {{ old('sumber_dana', $inventarisDesa->sumber_dana) == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                @error('sumber_dana')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Kondisi dan Status -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-clipboard-check me-2"></i>
                                Kondisi dan Status
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Kondisi <span class="text-danger">*</span></label>
                                <select name="kondisi" class="form-select @error('kondisi') is-invalid @enderror" required>
                                    <option value="">Pilih Kondisi</option>
                                    <option value="Baik" {{ old('kondisi', $inventarisDesa->kondisi) == 'Baik' ? 'selected' : '' }}>Baik</option>
                                    <option value="Rusak Ringan" {{ old('kondisi', $inventarisDesa->kondisi) == 'Rusak Ringan' ? 'selected' : '' }}>Rusak Ringan</option>
                                    <option value="Rusak Berat" {{ old('kondisi', $inventarisDesa->kondisi) == 'Rusak Berat' ? 'selected' : '' }}>Rusak Berat</option>
                                    <option value="Tidak Dapat Digunakan" {{ old('kondisi', $inventarisDesa->kondisi) == 'Tidak Dapat Digunakan' ? 'selected' : '' }}>Tidak Dapat Digunakan</option>
                                </select>
                                @error('kondisi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Status Pemakaian</label>
                                <select name="status_pemakaian" class="form-select @error('status_pemakaian') is-invalid @enderror">
                                    <option value="Digunakan" {{ old('status_pemakaian', $inventarisDesa->status_pemakaian) == 'Digunakan' ? 'selected' : '' }}>Digunakan</option>
                                    <option value="Tidak Digunakan" {{ old('status_pemakaian', $inventarisDesa->status_pemakaian) == 'Tidak Digunakan' ? 'selected' : '' }}>Tidak Digunakan</option>
                                    <option value="Dipinjamkan" {{ old('status_pemakaian', $inventarisDesa->status_pemakaian) == 'Dipinjamkan' ? 'selected' : '' }}>Dipinjamkan</option>
                                    <option value="Dalam Perbaikan" {{ old('status_pemakaian', $inventarisDesa->status_pemakaian) == 'Dalam Perbaikan' ? 'selected' : '' }}>Dalam Perbaikan</option>
                                    <option value="Hilang" {{ old('status_pemakaian', $inventarisDesa->status_pemakaian) == 'Hilang' ? 'selected' : '' }}>Hilang</option>
                                </select>
                                @error('status_pemakaian')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Lokasi dan Penanggung Jawab -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-map-marker-alt me-2"></i>
                                Lokasi dan Penanggung Jawab
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Lokasi Penyimpanan <span class="text-danger">*</span></label>
                                <input type="text" name="lokasi_penyimpanan" class="form-control @error('lokasi_penyimpanan') is-invalid @enderror" 
                                       value="{{ old('lokasi_penyimpanan', $inventarisDesa->lokasi_penyimpanan) }}" required>
                                @error('lokasi_penyimpanan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Penanggung Jawab <span class="text-danger">*</span></label>
                                <input type="text" name="penanggung_jawab" class="form-control @error('penanggung_jawab') is-invalid @enderror" 
                                       value="{{ old('penanggung_jawab', $inventarisDesa->penanggung_jawab) }}" required>
                                @error('penanggung_jawab')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jabatan Penanggung Jawab</label>
                                <input type="text" name="jabatan_pj" class="form-control @error('jabatan_pj') is-invalid @enderror" 
                                       value="{{ old('jabatan_pj', $inventarisDesa->jabatan_pj) }}">
                                @error('jabatan_pj')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Alamat Detail</label>
                                <textarea name="alamat_detail" class="form-control @error('alamat_detail') is-invalid @enderror" rows="2">{{ old('alamat_detail', $inventarisDesa->alamat_detail) }}</textarea>
                                @error('alamat_detail')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Maintenance -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-tools me-2"></i>
                                Informasi Maintenance
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Terakhir Maintenance</label>
                                <input type="date" name="terakhir_maintenance" class="form-control @error('terakhir_maintenance') is-invalid @enderror" 
                                       value="{{ old('terakhir_maintenance', $inventarisDesa->terakhir_maintenance?->format('Y-m-d')) }}">
                                @error('terakhir_maintenance')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jadwal Maintenance Berikutnya</label>
                                <input type="date" name="jadwal_maintenance_berikutnya" class="form-control @error('jadwal_maintenance_berikutnya') is-invalid @enderror" 
                                       value="{{ old('jadwal_maintenance_berikutnya', $inventarisDesa->jadwal_maintenance_berikutnya?->format('Y-m-d')) }}">
                                @error('jadwal_maintenance_berikutnya')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Biaya Maintenance per Tahun</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" name="biaya_maintenance_per_tahun" class="form-control @error('biaya_maintenance_per_tahun') is-invalid @enderror" 
                                           value="{{ old('biaya_maintenance_per_tahun', $inventarisDesa->biaya_maintenance_per_tahun) }}" min="0" step="0.01">
                                </div>
                                @error('biaya_maintenance_per_tahun')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Dokumentasi -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-images me-2"></i>
                                Dokumentasi
                            </h6>
                        </div>
                        @if($inventarisDesa->foto_barang)
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Foto Barang Saat Ini</label>
                                    <div>
                                        <img src="{{ asset('storage/' . $inventarisDesa->foto_barang) }}" 
                                             alt="Foto {{ $inventarisDesa->nama_barang }}" 
                                             class="img-fluid rounded mb-2" 
                                             style="max-height: 150px;">
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ $inventarisDesa->foto_barang ? 'Ganti Foto Barang' : 'Foto Barang' }}</label>
                                <input type="file" name="foto_barang" class="form-control @error('foto_barang') is-invalid @enderror" 
                                       accept="image/*">
                                @error('foto_barang')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        @if($inventarisDesa->dokumen_pendukung)
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Dokumen Pendukung Saat Ini</label>
                                    <div>
                                        <a href="{{ asset('storage/' . $inventarisDesa->dokumen_pendukung) }}" 
                                           target="_blank" class="btn btn-outline-primary btn-sm">
                                            <i class="fas fa-download me-2"></i>
                                            Lihat Dokumen
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">{{ $inventarisDesa->dokumen_pendukung ? 'Ganti Dokumen Pendukung' : 'Dokumen Pendukung' }}</label>
                                <input type="file" name="dokumen_pendukung" class="form-control @error('dokumen_pendukung') is-invalid @enderror" 
                                       accept=".pdf,.doc,.docx">
                                @error('dokumen_pendukung')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Keterangan</label>
                                <textarea name="keterangan" class="form-control @error('keterangan') is-invalid @enderror" rows="3">{{ old('keterangan', $inventarisDesa->keterangan) }}</textarea>
                                @error('keterangan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('admin.inventaris-desa.show', $inventarisDesa) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>
                            Kembali
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            Update Inventaris
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informasi
                </h6>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <h6 class="alert-heading">Tips:</h6>
                    <ul class="mb-0">
                        <li>Kode inventaris tidak dapat diubah setelah dibuat</li>
                        <li>Jika tidak mengubah foto/dokumen, file lama akan tetap digunakan</li>
                        <li>Pastikan informasi penanggung jawab selalu up to date</li>
                        <li>Update nilai sekarang secara berkala untuk akurasi laporan</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
