@extends('layouts.app')

@section('title', 'Inventaris Desa')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Inventaris Desa</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-boxes me-2 text-primary"></i>
            Inventaris Desa
        </h2>
        <p class="text-muted mb-0">Kelola aset dan inventaris desa secara lengkap dan terorganisir</p>
    </div>
    <div>
        <button type="button" class="btn btn-outline-success me-2" onclick="exportInventaris()">
            <i class="fas fa-download me-2"></i>
            Export Excel
        </button>
        <a href="{{ route('admin.inventaris-desa.create') }}" class="btn btn-gradient-primary">
            <i class="fas fa-plus me-2"></i>
            Tambah Inventaris
        </a>
    </div>
</div>

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Filter Section -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.inventaris-desa.index') }}" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Kategori</label>
                <select name="kategori" class="form-select">
                    <option value="">Semua Kategori</option>
                    <option value="Tanah" {{ request('kategori') == 'Tanah' ? 'selected' : '' }}>Tanah</option>
                    <option value="Bangunan" {{ request('kategori') == 'Bangunan' ? 'selected' : '' }}>Bangunan</option>
                    <option value="Kendaraan" {{ request('kategori') == 'Kendaraan' ? 'selected' : '' }}>Kendaraan</option>
                    <option value="Elektronik" {{ request('kategori') == 'Elektronik' ? 'selected' : '' }}>Elektronik</option>
                    <option value="Furniture" {{ request('kategori') == 'Furniture' ? 'selected' : '' }}>Furniture</option>
                    <option value="Alat Tulis Kantor" {{ request('kategori') == 'Alat Tulis Kantor' ? 'selected' : '' }}>Alat Tulis Kantor</option>
                    <option value="Alat Kesehatan" {{ request('kategori') == 'Alat Kesehatan' ? 'selected' : '' }}>Alat Kesehatan</option>
                    <option value="Alat Pertanian" {{ request('kategori') == 'Alat Pertanian' ? 'selected' : '' }}>Alat Pertanian</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Kondisi</label>
                <select name="kondisi" class="form-select">
                    <option value="">Semua Kondisi</option>
                    <option value="Baik" {{ request('kondisi') == 'Baik' ? 'selected' : '' }}>Baik</option>
                    <option value="Rusak Ringan" {{ request('kondisi') == 'Rusak Ringan' ? 'selected' : '' }}>Rusak Ringan</option>
                    <option value="Rusak Berat" {{ request('kondisi') == 'Rusak Berat' ? 'selected' : '' }}>Rusak Berat</option>
                    <option value="Tidak Dapat Digunakan" {{ request('kondisi') == 'Tidak Dapat Digunakan' ? 'selected' : '' }}>Tidak Dapat Digunakan</option>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Pencarian</label>
                <input type="text" name="search" class="form-control" placeholder="Cari nama barang atau kode inventaris..." value="{{ request('search') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search me-2"></i>Filter
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="mb-0">{{ $inventaris->total() }}</h4>
                        <p class="mb-0">Total Inventaris</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-boxes fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="mb-0">{{ $inventaris->where('kondisi', 'Baik')->count() }}</h4>
                        <p class="mb-0">Kondisi Baik</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-check-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="mb-0">{{ $inventaris->whereIn('kondisi', ['Rusak Ringan', 'Rusak Berat'])->count() }}</h4>
                        <p class="mb-0">Perlu Perbaikan</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-tools fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="mb-0">Rp {{ number_format($inventaris->sum('nilai_sekarang'), 0, ',', '.') }}</h4>
                        <p class="mb-0">Total Nilai</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-money-bill-wave fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Inventaris Table -->
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">
            <i class="fas fa-list me-2"></i>
            Daftar Inventaris Desa
        </h5>
    </div>
    <div class="card-body">
        @if($inventaris->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Kode</th>
                            <th>Nama Barang</th>
                            <th>Kategori</th>
                            <th>Kondisi</th>
                            <th>Lokasi</th>
                            <th>Nilai Sekarang</th>
                            <th>Penanggung Jawab</th>
                            <th width="120">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($inventaris as $item)
                            <tr>
                                <td>
                                    <span class="badge bg-secondary">{{ $item->kode_inventaris }}</span>
                                </td>
                                <td>
                                    <div>
                                        <strong>{{ $item->nama_barang }}</strong>
                                        @if($item->merk_tipe)
                                            <br><small class="text-muted">{{ $item->merk_tipe }}</small>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ $item->kategori }}</span>
                                </td>
                                <td>
                                    @php
                                        $kondisiClass = match($item->kondisi) {
                                            'Baik' => 'success',
                                            'Rusak Ringan' => 'warning',
                                            'Rusak Berat' => 'danger',
                                            'Tidak Dapat Digunakan' => 'dark',
                                            default => 'secondary'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $kondisiClass }}">{{ $item->kondisi }}</span>
                                </td>
                                <td>{{ $item->lokasi_penyimpanan }}</td>
                                <td>Rp {{ number_format($item->nilai_sekarang, 0, ',', '.') }}</td>
                                <td>{{ $item->penanggung_jawab }}</td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('admin.inventaris-desa.show', $item) }}" class="btn btn-sm btn-outline-primary" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.inventaris-desa.edit', $item) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="deleteInventaris({{ $item->id }})" title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-3">
                <div class="text-muted">
                    Menampilkan {{ $inventaris->firstItem() }} sampai {{ $inventaris->lastItem() }} dari {{ $inventaris->total() }} data
                </div>
                <div>
                    {{ $inventaris->appends(request()->query())->links() }}
                </div>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-boxes fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Belum ada data inventaris</h5>
                <p class="text-muted">Mulai dengan menambahkan inventaris desa pertama Anda</p>
                <a href="{{ route('admin.inventaris-desa.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>
                    Tambah Inventaris
                </a>
            </div>
        @endif
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus inventaris ini?</p>
                <p class="text-danger"><strong>Perhatian:</strong> Tindakan ini tidak dapat dibatalkan.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteInventaris(id) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = `/admin/inventaris-desa/${id}`;
    
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}

function exportInventaris() {
    // Implement export functionality
    window.location.href = '{{ route("admin.inventaris-desa.export", "excel") }}';
}
</script>
@endpush
