@extends('layouts.app')

@section('title', 'Pengaturan Marketplace')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Pengaturan Marketplace</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.marketplace.settings.update') }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="commission_rate">Komisi (%)</label>
                                    <input type="number" class="form-control" id="commission_rate" name="commission_rate" 
                                           value="{{ old('commission_rate', $settings['commission_rate']) }}" 
                                           min="0" max="100" step="0.1">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="min_order_amount">Minimal Pemesanan (Rp)</label>
                                    <input type="number" class="form-control" id="min_order_amount" name="min_order_amount" 
                                           value="{{ old('min_order_amount', $settings['min_order_amount']) }}" min="0">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_order_amount">Maksimal Pemesanan (Rp)</label>
                                    <input type="number" class="form-control" id="max_order_amount" name="max_order_amount" 
                                           value="{{ old('max_order_amount', $settings['max_order_amount']) }}" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contact_email">Email Kontak</label>
                                    <input type="email" class="form-control" id="contact_email" name="contact_email" 
                                           value="{{ old('contact_email', $settings['contact_email']) }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contact_phone">Telepon Kontak</label>
                                    <input type="text" class="form-control" id="contact_phone" name="contact_phone" 
                                           value="{{ old('contact_phone', $settings['contact_phone']) }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <h5>Pengaturan Fitur</h5>
                                <hr>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="auto_approve_umkm" name="auto_approve_umkm" 
                                           value="1" {{ $settings['auto_approve_umkm'] ? 'checked' : '' }}>
                                    <label class="form-check-label" for="auto_approve_umkm">
                                        Auto Approve UMKM
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="auto_approve_produk" name="auto_approve_produk" 
                                           value="1" {{ $settings['auto_approve_produk'] ? 'checked' : '' }}>
                                    <label class="form-check-label" for="auto_approve_produk">
                                        Auto Approve Produk
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="enable_reviews" name="enable_reviews" 
                                           value="1" {{ $settings['enable_reviews'] ? 'checked' : '' }}>
                                    <label class="form-check-label" for="enable_reviews">
                                        Enable Reviews
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="enable_wishlist" name="enable_wishlist" 
                                           value="1" {{ $settings['enable_wishlist'] ? 'checked' : '' }}>
                                    <label class="form-check-label" for="enable_wishlist">
                                        Enable Wishlist
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="enable_notifications" name="enable_notifications" 
                                           value="1" {{ $settings['enable_notifications'] ? 'checked' : '' }}>
                                    <label class="form-check-label" for="enable_notifications">
                                        Enable Notifications
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <h5>Media Sosial</h5>
                                <hr>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="facebook">Facebook</label>
                                    <input type="url" class="form-control" id="facebook" name="facebook" 
                                           value="{{ old('facebook', $settings['social_media']['facebook'] ?? '') }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="instagram">Instagram</label>
                                    <input type="url" class="form-control" id="instagram" name="instagram" 
                                           value="{{ old('instagram', $settings['social_media']['instagram'] ?? '') }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="whatsapp">WhatsApp</label>
                                    <input type="text" class="form-control" id="whatsapp" name="whatsapp" 
                                           value="{{ old('whatsapp', $settings['social_media']['whatsapp'] ?? '') }}">
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Simpan Pengaturan</button>
                                <a href="{{ route('admin.marketplace.index') }}" class="btn btn-secondary">Kembali</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 