@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.mutasi-penduduk.index') }}">Mutasi Penduduk</a></li>
                        <li class="breadcrumb-item active">Edit Mutasi</li>
                    </ol>
                </div>
                <h4 class="page-title">Edit Mutasi Penduduk</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.mutasi-penduduk.update', $mutasiPenduduk->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nik" class="form-label">NIK <span class="text-danger">*</span></label>
                                    <select class="form-select @error('nik') is-invalid @enderror" name="nik" id="nik" required>
                                        <option value="">Pilih NIK Penduduk</option>
                                        @foreach($penduduk as $item)
                                            <option value="{{ $item->nik }}" 
                                                {{ (old('nik') ?? $mutasiPenduduk->nik) == $item->nik ? 'selected' : '' }}>
                                                {{ $item->nik }} - {{ $item->nama }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('nik')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="jenis_mutasi" class="form-label">Jenis Mutasi <span class="text-danger">*</span></label>
                                    <select class="form-select @error('jenis_mutasi') is-invalid @enderror" name="jenis_mutasi" id="jenis_mutasi" required>
                                        <option value="">Pilih Jenis Mutasi</option>
                                        <option value="Lahir" {{ (old('jenis_mutasi') ?? $mutasiPenduduk->jenis_mutasi) == 'Lahir' ? 'selected' : '' }}>Lahir</option>
                                        <option value="Meninggal" {{ (old('jenis_mutasi') ?? $mutasiPenduduk->jenis_mutasi) == 'Meninggal' ? 'selected' : '' }}>Meninggal</option>
                                        <option value="Pindah Masuk" {{ (old('jenis_mutasi') ?? $mutasiPenduduk->jenis_mutasi) == 'Pindah Masuk' ? 'selected' : '' }}>Pindah Masuk</option>
                                        <option value="Pindah Keluar" {{ (old('jenis_mutasi') ?? $mutasiPenduduk->jenis_mutasi) == 'Pindah Keluar' ? 'selected' : '' }}>Pindah Keluar</option>
                                        <option value="Status Update" {{ (old('jenis_mutasi') ?? $mutasiPenduduk->jenis_mutasi) == 'Status Update' ? 'selected' : '' }}>Status Update</option>
                                    </select>
                                    @error('jenis_mutasi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_mutasi" class="form-label">Tanggal Mutasi <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('tanggal_mutasi') is-invalid @enderror" 
                                           name="tanggal_mutasi" id="tanggal_mutasi" 
                                           value="{{ old('tanggal_mutasi') ?? $mutasiPenduduk->tanggal_mutasi }}" required>
                                    @error('tanggal_mutasi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="no_surat_keterangan" class="form-label">No. Surat Keterangan</label>
                                    <input type="text" class="form-control @error('no_surat_keterangan') is-invalid @enderror" 
                                           name="no_surat_keterangan" id="no_surat_keterangan" 
                                           value="{{ old('no_surat_keterangan') ?? $mutasiPenduduk->no_surat_keterangan }}"
                                           placeholder="Masukkan nomor surat keterangan">
                                    @error('no_surat_keterangan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Fields untuk Pindah -->
                        <div class="row" id="pindah-fields" style="display: none;">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="asal_daerah" class="form-label">Asal Daerah</label>
                                    <input type="text" class="form-control @error('asal_daerah') is-invalid @enderror" 
                                           name="asal_daerah" id="asal_daerah" 
                                           value="{{ old('asal_daerah') ?? $mutasiPenduduk->asal_daerah }}"
                                           placeholder="Masukkan asal daerah">
                                    @error('asal_daerah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tujuan_daerah" class="form-label">Tujuan Daerah</label>
                                    <input type="text" class="form-control @error('tujuan_daerah') is-invalid @enderror" 
                                           name="tujuan_daerah" id="tujuan_daerah" 
                                           value="{{ old('tujuan_daerah') ?? $mutasiPenduduk->tujuan_daerah }}"
                                           placeholder="Masukkan tujuan daerah">
                                    @error('tujuan_daerah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Fields untuk Meninggal -->
                        <div class="row" id="meninggal-fields" style="display: none;">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="sebab_meninggal" class="form-label">Sebab Meninggal</label>
                                    <input type="text" class="form-control @error('sebab_meninggal') is-invalid @enderror" 
                                           name="sebab_meninggal" id="sebab_meninggal" 
                                           value="{{ old('sebab_meninggal') ?? $mutasiPenduduk->sebab_meninggal }}"
                                           placeholder="Masukkan sebab meninggal">
                                    @error('sebab_meninggal')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tempat_meninggal" class="form-label">Tempat Meninggal</label>
                                    <input type="text" class="form-control @error('tempat_meninggal') is-invalid @enderror" 
                                           name="tempat_meninggal" id="tempat_meninggal" 
                                           value="{{ old('tempat_meninggal') ?? $mutasiPenduduk->tempat_meninggal }}"
                                           placeholder="Masukkan tempat meninggal">
                                    @error('tempat_meninggal')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="keterangan" class="form-label">Keterangan</label>
                                    <textarea class="form-control @error('keterangan') is-invalid @enderror" 
                                              name="keterangan" id="keterangan" rows="3" 
                                              placeholder="Masukkan keterangan tambahan">{{ old('keterangan') ?? $mutasiPenduduk->keterangan }}</textarea>
                                    @error('keterangan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="catatan_admin" class="form-label">Catatan Admin</label>
                                    <textarea class="form-control @error('catatan_admin') is-invalid @enderror" 
                                              name="catatan_admin" id="catatan_admin" rows="3" 
                                              placeholder="Catatan untuk admin">{{ old('catatan_admin') ?? $mutasiPenduduk->catatan_admin }}</textarea>
                                    @error('catatan_admin')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="text-end">
                            <a href="{{ route('admin.mutasi-penduduk.show', $mutasiPenduduk->id) }}" class="btn btn-light me-2">Batal</a>
                            <button type="submit" class="btn btn-primary">
                                <i class="mdi mdi-content-save"></i> Update
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const jenisMutasiSelect = document.getElementById('jenis_mutasi');
    const pindahFields = document.getElementById('pindah-fields');
    const meninggalFields = document.getElementById('meninggal-fields');

    // Initialize Select2 for better UX
    if (typeof $ !== 'undefined' && $.fn.select2) {
        $('#nik').select2({
            placeholder: 'Pilih NIK Penduduk',
            allowClear: true,
            width: '100%'
        });
    }

    function toggleFields() {
        const value = jenisMutasiSelect.value;
        
        // Hide all conditional fields
        pindahFields.style.display = 'none';
        meninggalFields.style.display = 'none';

        // Show relevant fields based on selection
        if (value === 'Pindah Masuk' || value === 'Pindah Keluar') {
            pindahFields.style.display = 'block';
        } else if (value === 'Meninggal') {
            meninggalFields.style.display = 'block';
        }
    }

    jenisMutasiSelect.addEventListener('change', toggleFields);

    // Trigger change event on page load to handle current values
    toggleFields();
});
</script>
@endpush
@endsection 