@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.mutasi-penduduk.index') }}">Mutasi Penduduk</a></li>
                        <li class="breadcrumb-item active">Statistik</li>
                    </ol>
                </div>
                <h4 class="page-title">Statistik Mutasi Penduduk</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <h4 class="header-title">Statistik Tahun {{ $tahun }}</h4>
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end">
                                <form method="GET" action="{{ route('admin.mutasi-penduduk.statistik') }}" class="d-inline">
                                    <select name="tahun" class="form-select d-inline w-auto" onchange="this.form.submit()">
                                        @for($i = date('Y'); $i >= date('Y') - 10; $i--)
                                            <option value="{{ $i }}" {{ $tahun == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </form>
                                <a href="{{ route('admin.mutasi-penduduk.index') }}" class="btn btn-secondary ms-2">
                                    <i class="mdi mdi-arrow-left me-1"></i> Kembali
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row">
                        @foreach($jenisStatistik as $item)
                        <div class="col-md-3">
                            <div class="card widget-flat">
                                <div class="card-body">
                                    <div class="float-end">
                                        @php
                                            $iconClass = [
                                                'Lahir' => 'mdi-baby-face bg-success-lighten text-success',
                                                'Meninggal' => 'mdi-heart-broken bg-danger-lighten text-danger',
                                                'Pindah Masuk' => 'mdi-login bg-primary-lighten text-primary',
                                                'Pindah Keluar' => 'mdi-logout bg-warning-lighten text-warning',
                                                'Status Update' => 'mdi-update bg-info-lighten text-info'
                                            ];
                                        @endphp
                                        <i class="mdi {{ $iconClass[$item->jenis_mutasi] ?? 'mdi-account bg-secondary-lighten text-secondary' }} widget-icon"></i>
                                    </div>
                                    <h5 class="text-muted font-weight-normal mt-0">{{ $item->jenis_mutasi }}</h5>
                                    <h3 class="mt-3 mb-3">{{ number_format($item->total) }}</h3>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-8">
            <!-- Chart Bulanan -->
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">Grafik Mutasi Bulanan {{ $tahun }}</h4>
                    <div id="chartBulanan" style="height: 380px;"></div>
                </div>
            </div>
        </div>

        <div class="col-xl-4">
            <!-- Chart Jenis Mutasi -->
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">Distribusi Jenis Mutasi</h4>
                    <div id="chartJenisMutasi" style="height: 280px;"></div>
                </div>
            </div>

            <!-- Statistik Tahunan -->
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">Perbandingan 5 Tahun Terakhir</h4>
                    <div class="table-responsive">
                        <table class="table table-sm table-centered mb-0">
                            <thead>
                                <tr>
                                    <th>Tahun</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($statistikTahunan as $item)
                                <tr class="{{ $item->tahun == $tahun ? 'table-primary' : '' }}">
                                    <td>{{ $item->tahun }}</td>
                                    <td><strong>{{ number_format($item->total) }}</strong></td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabel Detail Bulanan -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">Detail Mutasi per Bulan {{ $tahun }}</h4>
                    <div class="table-responsive">
                        <table class="table table-striped table-centered">
                            <thead>
                                <tr>
                                    <th>Bulan</th>
                                    <th>Lahir</th>
                                    <th>Meninggal</th>
                                    <th>Pindah Masuk</th>
                                    <th>Pindah Keluar</th>
                                    <th>Status Update</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $months = [
                                        1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
                                        5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
                                        9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
                                    ];
                                    $totalYearly = [
                                        'Lahir' => 0, 'Meninggal' => 0, 'Pindah Masuk' => 0, 
                                        'Pindah Keluar' => 0, 'Status Update' => 0, 'total' => 0
                                    ];
                                @endphp
                                
                                @foreach($months as $monthNum => $monthName)
                                    @php
                                        $monthData = $statistikBulanan->where('bulan', $monthNum)->first();
                                        $counts = [
                                            'Lahir' => 0, 'Meninggal' => 0, 'Pindah Masuk' => 0, 
                                            'Pindah Keluar' => 0, 'Status Update' => 0
                                        ];
                                        
                                        if ($monthData && isset($monthData->by_jenis)) {
                                            $counts = array_merge($counts, $monthData->by_jenis);
                                        }
                                        
                                        $monthTotal = array_sum($counts);
                                        
                                        // Add to yearly total
                                        foreach ($counts as $jenis => $count) {
                                            $totalYearly[$jenis] += $count;
                                        }
                                        $totalYearly['total'] += $monthTotal;
                                    @endphp
                                    
                                    <tr>
                                        <td><strong>{{ $monthName }}</strong></td>
                                        <td><span class="badge bg-success">{{ number_format($counts['Lahir']) }}</span></td>
                                        <td><span class="badge bg-danger">{{ number_format($counts['Meninggal']) }}</span></td>
                                        <td><span class="badge bg-primary">{{ number_format($counts['Pindah Masuk']) }}</span></td>
                                        <td><span class="badge bg-warning">{{ number_format($counts['Pindah Keluar']) }}</span></td>
                                        <td><span class="badge bg-info">{{ number_format($counts['Status Update']) }}</span></td>
                                        <td><strong>{{ number_format($monthTotal) }}</strong></td>
                                    </tr>
                                @endforeach
                                
                                <!-- Total Row -->
                                <tr class="table-dark">
                                    <td><strong>TOTAL</strong></td>
                                    <td><strong>{{ number_format($totalYearly['Lahir']) }}</strong></td>
                                    <td><strong>{{ number_format($totalYearly['Meninggal']) }}</strong></td>
                                    <td><strong>{{ number_format($totalYearly['Pindah Masuk']) }}</strong></td>
                                    <td><strong>{{ number_format($totalYearly['Pindah Keluar']) }}</strong></td>
                                    <td><strong>{{ number_format($totalYearly['Status Update']) }}</strong></td>
                                    <td><strong>{{ number_format($totalYearly['total']) }}</strong></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Data untuk chart bulanan
    const statistikBulanan = @json($statistikBulanan);
    const jenisStatistik = @json($jenisStatistik);
    
    // Prepare data for monthly chart
    const monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    const jenisMutasi = ['Lahir', 'Meninggal', 'Pindah Masuk', 'Pindah Keluar', 'Status Update'];
    const colors = ['#28a745', '#dc3545', '#007bff', '#ffc107', '#17a2b8'];
    
    let series = [];
    
    jenisMutasi.forEach((jenis, index) => {
        let data = [];
        for (let month = 1; month <= 12; month++) {
            const monthData = statistikBulanan.find(item => item.bulan === month);
            const count = monthData && monthData.by_jenis && monthData.by_jenis[jenis] ? monthData.by_jenis[jenis] : 0;
            data.push(count);
        }
        
        series.push({
            name: jenis,
            data: data,
            color: colors[index]
        });
    });

    // Monthly Chart
    const optionsBulanan = {
        series: series,
        chart: {
            type: 'bar',
            height: 380,
            stacked: true,
            toolbar: {
                show: true
            }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                dataLabels: {
                    total: {
                        enabled: true,
                        style: {
                            fontSize: '13px',
                            fontWeight: 900
                        }
                    }
                }
            }
        },
        xaxis: {
            categories: monthNames
        },
        legend: {
            position: 'bottom'
        },
        fill: {
            opacity: 1
        },
        title: {
            text: 'Mutasi Penduduk per Bulan {{ $tahun }}',
            align: 'center'
        }
    };

    const chartBulanan = new ApexCharts(document.querySelector("#chartBulanan"), optionsBulanan);
    chartBulanan.render();

    // Pie Chart for Jenis Mutasi
    const pieData = jenisStatistik.map(item => item.total);
    const pieLabels = jenisStatistik.map(item => item.jenis_mutasi);

    const optionsJenis = {
        series: pieData,
        chart: {
            type: 'donut',
            height: 280
        },
        labels: pieLabels,
        colors: colors,
        legend: {
            position: 'bottom'
        },
        title: {
            text: 'Distribusi Jenis Mutasi {{ $tahun }}',
            align: 'center'
        }
    };

    const chartJenis = new ApexCharts(document.querySelector("#chartJenisMutasi"), optionsJenis);
    chartJenis.render();
});
</script>
@endpush
@endsection 