@extends('layouts.app')

@section('title', 'Detail Pengaduan')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-exclamation-triangle me-2 text-primary"></i>Detail Pengaduan
            </h2>
            <p class="text-muted mb-0">Informasi lengkap pengaduan #{{ $pengaduan->id ?? '1' }}</p>
        </div>
        <div>
            <a href="{{ route('admin.pengaduan.index') }}" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
            <a href="{{ route('admin.pengaduan.edit', $pengaduan->id ?? 1) }}" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-exclamation-triangle me-2"></i>Informasi Pengaduan</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Kategori</label>
                                <div class="fw-bold">Infrastruktur</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Status</label>
                                <div>
                                    <span class="badge bg-warning">Pending</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Judul Pengaduan</label>
                        <div class="fw-bold">Jalan Rusak di Depan Pasar</div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Deskripsi</label>
                        <div class="fw-medium">Jalan di depan pasar mengalami kerusakan parah dengan banyak lubang yang membahayakan pengendara.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Lokasi Kejadian</label>
                        <div class="fw-medium">Jl. Pasar Raya, Dusun 1</div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Tanggal Lapor</label>
                                <div class="fw-medium">15 November 2024</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Tanggal Target Selesai</label>
                                <div class="fw-medium">30 November 2024</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tanggapan -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-reply me-2"></i>Tanggapan</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <p class="mb-0">Pengaduan sedang dalam proses penanganan oleh tim terkait.</p>
                        <small class="text-muted">Direspons pada: 16 November 2024</small>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Info Pelapor -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-user me-2"></i>Info Pelapor</h6>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <div class="bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                             style="width: 60px; height: 60px;">
                            <i class="fas fa-user fa-lg"></i>
                        </div>
                        <h6 class="mb-2">Ahmad Sulaiman</h6>
                        <div class="small text-muted">
                            <div class="mb-1"><strong>NIK:</strong> 1234567890123456</div>
                            <div class="mb-1"><strong>Telepon:</strong> 08123456789</div>
                            <div><strong>Alamat:</strong> Jl. Mawar No. 15</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Actions -->
            <div class="card mt-4">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.pengaduan.edit', $pengaduan->id ?? 1) }}" class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i>Edit Pengaduan
                        </a>
                        <button type="button" class="btn btn-outline-primary" onclick="printPengaduan()">
                            <i class="fas fa-print me-2"></i>Cetak
                        </button>
                        <button type="button" class="btn btn-outline-success" onclick="kirimWhatsapp()">
                            <i class="fab fa-whatsapp me-2"></i>Kirim WhatsApp
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function printPengaduan() {
    window.print();
}

function kirimWhatsapp() {
    const message = "Update pengaduan Anda: Jalan Rusak di Depan Pasar sedang dalam proses penanganan.";
    const whatsappUrl = `https://wa.me/08123456789?text=${encodeURIComponent(message)}`;
    window.open(whatsappUrl, '_blank');
}
</script>
@endpush 
