@extends('layouts.app')

@section('title', 'Peta Rumah')

@section('breadcrumb')
    <li class="breadcrumb-item active">Peta Rumah</li>
@endsection

@section('content')
<div class="row">
    <!-- Statistics Cards -->
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-primary h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-map-marker-alt"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['penduduk'] ?? 0 }}</div>
                    <div class="small">Lokasi Penduduk</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-success h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-home"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['keluarga'] ?? 0 }}</div>
                    <div class="small">Rumah Keluarga</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-warning h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['pengaduan'] ?? 0 }}</div>
                    <div class="small">Lokasi Pengaduan</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-info h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-hand-holding-heart"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['bantuan'] ?? 0 }}</div>
                    <div class="small">Lokasi Bantuan</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Map Container -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-map me-2 text-primary"></i>
                    Peta Rumah Penduduk
                </h5>
            </div>
            <div class="card-body p-0">
                <div id="petaRumah" style="height: 500px; width: 100%;"></div>
            </div>
        </div>
    </div>
</div>

<!-- Info Card -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body text-center">
                <h5>🗺️ Fitur Peta Rumah dengan Foto</h5>
                <p class="text-muted">
                    Halaman ini menampilkan lokasi rumah penduduk yang telah memiliki koordinat GPS beserta foto rumahnya. 
                    Klik pada marker untuk melihat informasi detail penduduk dan foto rumah. Klik foto untuk memperbesar.
                </p>
                <div class="row text-center">
                    <div class="col-md-3">
                        <i class="fas fa-map-marker-alt fa-2x text-primary mb-2"></i>
                        <h6>Lokasi Penduduk</h6>
                        <small class="text-muted">Menampilkan titik rumah penduduk</small>
                    </div>
                    <div class="col-md-3">
                        <i class="fas fa-camera fa-2x text-success mb-2"></i>
                        <h6>Foto Rumah</h6>
                        <small class="text-muted">Foto setiap rumah penduduk</small>
                    </div>
                    <div class="col-md-3">
                        <i class="fas fa-search fa-2x text-info mb-2"></i>
                        <h6>Pencarian Lokasi</h6>
                        <small class="text-muted">Cari berdasarkan nama atau alamat</small>
                    </div>
                    <div class="col-md-3">
                        <i class="fas fa-layer-group fa-2x text-warning mb-2"></i>
                        <h6>Multi Layer</h6>
                        <small class="text-muted">Tampilkan berbagai jenis data</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.stats-icon {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

.card-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.card-gradient-success {
    background: linear-gradient(135deg, #56ab2f 0%, #a8e6cf 100%);
    color: white;
}

.card-gradient-warning {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
}

.card-gradient-info {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: white;
}

/* Custom Map Popup Styles */
.leaflet-popup-content {
    margin: 0 !important;
    padding: 0 !important;
}

.leaflet-popup-content-wrapper {
    border-radius: 10px !important;
    box-shadow: 0 4px 15px rgba(0,0,0,0.2) !important;
}

.map-popup-img {
    transition: transform 0.3s ease;
    cursor: pointer;
}

.map-popup-img:hover {
    transform: scale(1.05);
}

/* Map marker styling */
.leaflet-marker-icon {
    filter: drop-shadow(2px 2px 4px rgba(0,0,0,0.3));
}
</style>
@endpush

@push('scripts')
<script>
let map;

// Initialize map when document is ready
document.addEventListener('DOMContentLoaded', function() {
    initMap();
});

function initMap() {
    // Default coordinates (Indonesia center)
    const defaultLat = -2.5489;
    const defaultLng = 118.0149;
    
    // Initialize map
    map = L.map('petaRumah').setView([defaultLat, defaultLng], 5);
    
    // Add tile layer
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    // Add sample markers if we have data
    const pendudukData = @json($pendudukWithCoordinates ?? []);
    
    if (pendudukData.length > 0) {
        pendudukData.forEach(function(penduduk) {
            if (penduduk.latitude && penduduk.longitude) {
                // Prepare house photo HTML
                let fotoRumahHtml = '';
                if (penduduk.foto_rumah) {
                    fotoRumahHtml = `
                        <div class="text-center mb-2">
                            <img src="/storage/penduduk/${penduduk.foto_rumah}" 
                                 alt="Foto Rumah ${penduduk.nama}" 
                                 class="img-fluid rounded map-popup-img" 
                                 style="max-width: 200px; max-height: 150px; object-fit: cover;"
                                 onclick="showFullImage('/storage/penduduk/${penduduk.foto_rumah}', '${penduduk.nama}')"
                                 onerror="this.style.display='none'"
                                 title="Klik untuk memperbesar foto">
                        </div>
                    `;
                }
                
                L.marker([penduduk.latitude, penduduk.longitude])
                    .bindPopup(`
                        <div class="p-2" style="min-width: 220px;">
                            ${fotoRumahHtml}
                            <h6 class="mb-2"><i class="fas fa-user"></i> ${penduduk.nama}</h6>
                            <div class="small mb-1">
                                <i class="fas fa-id-card text-primary"></i> 
                                <strong>NIK:</strong> ${penduduk.nik}
                            </div>
                            <div class="small mb-1">
                                <i class="fas fa-map-marker-alt text-danger"></i> 
                                <strong>Alamat:</strong> ${penduduk.alamat}
                            </div>
                            <div class="small mb-1">
                                <i class="fas fa-home text-success"></i> 
                                <strong>RT/RW:</strong> ${penduduk.rt}/${penduduk.rw}
                            </div>
                            <div class="small">
                                <i class="fas fa-users text-info"></i> 
                                <strong>No. KK:</strong> ${penduduk.no_kk}
                            </div>
                            ${penduduk.foto_rumah ? '' : '<div class="text-muted text-center mt-2 small"><i class="fas fa-camera"></i> Foto rumah belum tersedia</div>'}
                        </div>
                    `)
                    .addTo(map);
            }
        });
        
        // Auto-fit to markers
        if (pendudukData.length > 0) {
            const group = new L.featureGroup();
            pendudukData.forEach(function(penduduk) {
                if (penduduk.latitude && penduduk.longitude) {
                    group.addLayer(L.marker([penduduk.latitude, penduduk.longitude]));
                }
            });
            
            if (group.getLayers().length > 0) {
                map.fitBounds(group.getBounds().pad(0.1));
            }
        }
    }
}

// Function to show full image in modal
function showFullImage(imageSrc, nama) {
    // Create modal HTML
    const modalHtml = `
        <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="imageModalLabel">
                            <i class="fas fa-home"></i> Foto Rumah - ${nama}
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center p-0">
                        <img src="${imageSrc}" class="img-fluid" alt="Foto Rumah ${nama}" style="max-width: 100%; height: auto;">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times"></i> Tutup
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    // Remove existing modal if any
    const existingModal = document.getElementById('imageModal');
    if (existingModal) {
        existingModal.remove();
    }
    
    // Add modal to body
    document.body.insertAdjacentHTML('beforeend', modalHtml);
    
    // Show modal
    const modal = new bootstrap.Modal(document.getElementById('imageModal'));
    modal.show();
    
    // Clean up modal after hiding
    document.getElementById('imageModal').addEventListener('hidden.bs.modal', function() {
        this.remove();
    });
}
</script>
@endpush 
