@extends('layouts.app')

@section('title', 'Struktur Organisasi')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item active">Struktur Organisasi</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total Pengurus</h6>
                            <h4>{{ $stats['total_pengurus'] ?? 0 }}</h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-users fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Perangkat Desa</h6>
                            <h4>{{ $stats['perangkat_desa'] ?? 0 }}</h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-user-tie fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">BPD</h6>
                            <h4>{{ $stats['bpd'] ?? 0 }}</h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-balance-scale fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Lembaga Lain</h6>
                            <h4>{{ ($stats['lpm'] ?? 0) + ($stats['karang_taruna'] ?? 0) + ($stats['pkk'] ?? 0) }}</h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-sitemap fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-sitemap text-primary me-2"></i>
                        Struktur Organisasi Desa
                    </h4>
                    <div class="btn-group">
                        <a href="{{ route('admin.struktur-organisasi.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>
                            Tambah Pengurus
                        </a>
                        <button class="btn btn-success" onclick="showOrgChart()">
                            <i class="fas fa-sitemap me-1"></i>
                            Lihat Bagan
                        </button>
                        <button class="btn btn-info" onclick="exportData()">
                            <i class="fas fa-download me-1"></i>
                            Export
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="strukturTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Foto</th>
                                    <th>Nama</th>
                                    <th>Jabatan</th>
                                    <th>Lembaga</th>
                                    <th>Periode</th>
                                    <th>Kontak</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($struktur ?? [] as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        @if($item->foto)
                                            <img src="{{ asset('storage/organisasi/' . $item->foto) }}" class="rounded-circle" width="40" height="40" style="object-fit: cover;">
                                        @else
                                            <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                <i class="fas fa-user text-white"></i>
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <div>
                                            <strong>{{ $item->nama_pengurus }}</strong><br>
                                            @if($item->nik)
                                                <small class="text-muted">NIK: {{ $item->nik }}</small>
                                            @endif
                                        </div>
                                    </td>
                                    <td>{{ $item->jabatan }}</td>
                                    <td>
                                        <span class="badge bg-info">
                                            {{ ucwords(str_replace('_', ' ', $item->kategori_lembaga)) }}
                                        </span>
                                        <br><small class="text-muted">{{ $item->nama_lembaga }}</small>
                                    </td>
                                    <td>
                                        <small>
                                            {{ $item->tanggal_mulai_jabatan->format('d/m/Y') }} - 
                                            {{ $item->tanggal_selesai_jabatan ? $item->tanggal_selesai_jabatan->format('d/m/Y') : 'Sekarang' }}
                                        </small>
                                    </td>
                                    <td>
                                        @if($item->nomor_hp)
                                            <small><i class="fas fa-phone"></i> {{ $item->nomor_hp }}</small><br>
                                        @endif
                                        @if($item->email)
                                            <small><i class="fas fa-envelope"></i> {{ $item->email }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $item->status_aktif == 'aktif' ? 'success' : 'secondary' }}">
                                            {{ ucfirst(str_replace('_', ' ', $item->status_aktif)) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-info" onclick="showDetail({{ $item->id }})">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button class="btn btn-sm btn-warning" onclick="editStruktur({{ $item->id }})">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deleteStruktur({{ $item->id }})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Belum ada data struktur organisasi</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Pengurus Organisasi</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addForm" action="{{ route('admin.struktur-organisasi.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="nama_pengurus" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">NIK</label>
                                <input type="text" class="form-control" name="nik" maxlength="16">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jabatan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="jabatan" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Kategori Lembaga <span class="text-danger">*</span></label>
                                <select class="form-select" name="kategori_lembaga" required>
                                    <option value="">Pilih Kategori</option>
                                    <option value="perangkat_desa">Perangkat Desa</option>
                                    <option value="bpd">Badan Permusyawaratan Desa (BPD)</option>
                                    <option value="lpm">Lembaga Pemberdayaan Masyarakat (LPM)</option>
                                    <option value="karang_taruna">Karang Taruna</option>
                                    <option value="pkk">Pemberdayaan Kesejahteraan Keluarga (PKK)</option>
                                    <option value="rt_rw">RT/RW</option>
                                    <option value="tokoh_agama">Tokoh Agama</option>
                                    <option value="tokoh_masyarakat">Tokoh Masyarakat</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nama Lembaga <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="nama_lembaga" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Mulai Jabatan <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="tanggal_mulai_jabatan" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Selesai Jabatan</label>
                                <input type="date" class="form-control" name="tanggal_selesai_jabatan">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nomor HP</label>
                                <input type="text" class="form-control" name="nomor_hp">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control" name="email">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status_aktif" required>
                                    <option value="aktif">Aktif</option>
                                    <option value="tidak_aktif">Tidak Aktif</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Urutan Tampil</label>
                                <input type="number" class="form-control" name="urutan_tampil" value="1">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jenis Kelamin</label>
                                <select class="form-select" name="jenis_kelamin">
                                    <option value="">Pilih Jenis Kelamin</option>
                                    <option value="L">Laki-laki</option>
                                    <option value="P">Perempuan</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Alamat</label>
                        <textarea class="form-control" name="alamat" rows="2"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Foto</label>
                        <input type="file" class="form-control" name="foto" accept=".jpg,.jpeg,.png">
                        <small class="text-muted">Format: JPG, PNG (Max: 2MB)</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <textarea class="form-control" name="keterangan" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function showOrgChart() {
    alert('Fitur bagan organisasi akan segera diimplementasikan');
}

function editStruktur(id) {
    alert('Fitur edit akan segera diimplementasikan');
}

function deleteStruktur(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        fetch(`{{ route('admin.struktur-organisasi.index') }}/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        });
    }
}

function showDetail(id) {
    fetch(`{{ route('admin.struktur-organisasi.index') }}/${id}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const item = data.data;
                alert(`Detail: ${item.nama_pengurus} - ${item.jabatan}`);
            }
        });
}

function exportData() {
    window.open('{{ route("admin.struktur-organisasi.index") }}?export=excel', '_blank');
}

// Handle form submission
document.getElementById('addForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Data berhasil disimpan!');
            location.reload();
        } else {
            let errorMsg = 'Terjadi kesalahan';
            if (data.errors) {
                errorMsg = Object.values(data.errors).flat().join('\n');
            }
            alert('Error: ' + errorMsg);
        }
    })
    .catch(error => {
        alert('Terjadi kesalahan saat menyimpan data');
    });
});
</script>
@endpush 