@extends('layouts.app')

@section('title', 'Tambah Template Surat')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.template-surat.index') }}">Template Surat</a></li>
    <li class="breadcrumb-item active">Tambah Template</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-plus me-2 text-primary"></i>
            Tambah Template Surat
        </h2>
        <p class="text-muted mb-0">Buat template surat baru untuk mempercepat pembuatan dokumen</p>
    </div>
    <div>
        <a href="{{ route('admin.template-surat.index') }}" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali
        </a>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-file-contract me-2"></i>
                    Form Template Surat
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.template-surat.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="row g-4">
                        <!-- Basic Information -->
                        <div class="col-md-6">
                            <label class="form-label">Nama Template <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('nama_template') is-invalid @enderror" 
                                   name="nama_template" value="{{ old('nama_template') }}" 
                                   placeholder="Contoh: Surat Keterangan Domisili" required>
                            @error('nama_template')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Jenis Surat <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('jenis_surat') is-invalid @enderror" 
                                   name="jenis_surat" value="{{ old('jenis_surat') }}" 
                                   placeholder="Contoh: Surat Keterangan" required>
                            @error('jenis_surat')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-select @error('kategori') is-invalid @enderror" name="kategori" required>
                                <option value="">Pilih Kategori</option>
                                <option value="Umum" {{ old('kategori') == 'Umum' ? 'selected' : '' }}>Umum</option>
                                <option value="Khusus" {{ old('kategori') == 'Khusus' ? 'selected' : '' }}>Khusus</option>
                                <option value="Resmi" {{ old('kategori') == 'Resmi' ? 'selected' : '' }}>Resmi</option>
                            </select>
                            @error('kategori')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select @error('status') is-invalid @enderror" name="status" required>
                                <option value="Aktif" {{ old('status') == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="Tidak Aktif" {{ old('status') == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-12">
                            <label class="form-label">Deskripsi</label>
                            <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                      name="deskripsi" rows="3" 
                                      placeholder="Deskripsi singkat tentang template ini...">{{ old('deskripsi') }}</textarea>
                            @error('deskripsi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <!-- Header/Footer -->
                        <div class="col-md-6">
                            <label class="form-label">Kop Surat</label>
                            <textarea class="form-control @error('kop_surat') is-invalid @enderror" 
                                      name="kop_surat" rows="4" 
                                      placeholder="Header/kop surat...">{{ old('kop_surat') }}</textarea>
                            @error('kop_surat')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Footer Surat</label>
                            <textarea class="form-control @error('footer_surat') is-invalid @enderror" 
                                      name="footer_surat" rows="4" 
                                      placeholder="Footer surat...">{{ old('footer_surat') }}</textarea>
                            @error('footer_surat')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <!-- Template Content -->
                        <div class="col-12">
                            <label class="form-label">Konten Template <span class="text-danger">*</span></label>
                            <div class="mb-3">
                                <small class="text-muted">
                                    Gunakan variabel berikut dalam template: 
                                    <code>@{{nama_pemohon}}</code>, <code>@{{nik}}</code>, <code>@{{alamat}}</code>, 
                                    <code>@{{tempat_lahir}}</code>, <code>@{{tanggal_lahir}}</code>, <code>@{{jenis_kelamin}}</code>, 
                                    <code>@{{agama}}</code>, <code>@{{pekerjaan}}</code>, <code>@{{keperluan}}</code>, 
                                    <code>@{{tanggal_surat}}</code>, <code>@{{nomor_surat}}</code>
                                </small>
                            </div>
                            <textarea class="form-control @error('konten_template') is-invalid @enderror" 
                                      name="konten_template" rows="15" required 
                                      placeholder="Masukkan konten template surat di sini...">{{ old('konten_template') }}</textarea>
                            @error('konten_template')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <!-- File Upload -->
                        <div class="col-12">
                            <label class="form-label">File Template (Opsional)</label>
                            <input type="file" class="form-control @error('file_template') is-invalid @enderror" 
                                   name="file_template" accept=".docx,.doc">
                            <div class="form-text">
                                Upload file template dalam format .docx atau .doc (maksimal 2MB)
                            </div>
                            @error('file_template')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="mt-4 d-flex justify-content-between">
                        <a href="{{ route('admin.template-surat.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>
                            Batal
                        </a>
                        <div>
                            <button type="submit" name="action" value="save_and_continue" class="btn btn-outline-primary me-2">
                                <i class="fas fa-save me-2"></i>
                                Simpan & Lanjutkan Edit
                            </button>
                            <button type="submit" name="action" value="save" class="btn btn-primary">
                                <i class="fas fa-check me-2"></i>
                                Simpan Template
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Variables Helper Modal -->
<div class="modal fade" id="variablesModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-code me-2"></i>
                    Variabel Template
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Data Pemohon</h6>
                        <ul class="list-unstyled">
                            <li><code>@{{nama_pemohon}}</code> - Nama lengkap pemohon</li>
                            <li><code>@{{nik}}</code> - NIK pemohon</li>
                            <li><code>@{{alamat}}</code> - Alamat lengkap</li>
                            <li><code>@{{tempat_lahir}}</code> - Tempat lahir</li>
                            <li><code>@{{tanggal_lahir}}</code> - Tanggal lahir</li>
                            <li><code>@{{jenis_kelamin}}</code> - Jenis kelamin</li>
                            <li><code>@{{agama}}</code> - Agama</li>
                            <li><code>@{{pekerjaan}}</code> - Pekerjaan</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h6>Data Surat</h6>
                        <ul class="list-unstyled">
                            <li><code>@{{keperluan}}</code> - Keperluan surat</li>
                            <li><code>@{{tanggal_surat}}</code> - Tanggal surat</li>
                            <li><code>@{{nomor_surat}}</code> - Nomor surat</li>
                            <li><code>@{{nama_desa}}</code> - Nama desa</li>
                            <li><code>@{{nama_kecamatan}}</code> - Nama kecamatan</li>
                            <li><code>@{{nama_kabupaten}}</code> - Nama kabupaten</li>
                            <li><code>@{{nama_kepala_desa}}</code> - Nama kepala desa</li>
                        </ul>
                    </div>
                </div>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    Salin dan tempel variabel di atas ke dalam konten template sesuai kebutuhan.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add variables helper button
    const contentLabel = document.querySelector('label[for="konten_template"]') || 
                        document.querySelector('textarea[name="konten_template"]').previousElementSibling;
    
    if (contentLabel) {
        const helpButton = document.createElement('button');
        helpButton.type = 'button';
        helpButton.className = 'btn btn-sm btn-outline-info ms-2';
        helpButton.innerHTML = '<i class="fas fa-question-circle me-1"></i> Lihat Variabel';
        helpButton.onclick = function() {
            const modal = new bootstrap.Modal(document.getElementById('variablesModal'));
            modal.show();
        };
        contentLabel.appendChild(helpButton);
    }
    
    // Auto-resize textarea
    const textarea = document.querySelector('textarea[name="konten_template"]');
    if (textarea) {
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
    }
});
</script>
@endpush
@endsection 