@extends('layouts.app')

@section('title', 'Kelola Transaksi')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Kelola Transaksi</h1>
        <div class="d-flex">
            <button class="btn btn-info btn-sm mr-2" onclick="exportTransactions()">
                <i class="fas fa-download"></i> Export
            </button>
            <button class="btn btn-warning btn-sm" onclick="syncPayments()">
                <i class="fas fa-sync"></i> Sync Pembayaran
            </button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Transaksi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-credit-card fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Berhasil</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['success'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-check-circle fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['pending'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-clock fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Total Nilai</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rp {{ number_format($stats['total_amount'] ?? 0) }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-dollar-sign fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Search -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Transaksi</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.transaksi.index') }}">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Pencarian</label>
                            <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Kode transaksi, nama...">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Status</label>
                            <select class="form-control" name="status">
                                <option value="">Semua Status</option>
                                <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="paid" {{ request('status') === 'paid' ? 'selected' : '' }}>Paid</option>
                                <option value="settled" {{ request('status') === 'settled' ? 'selected' : '' }}>Settled</option>
                                <option value="expired" {{ request('status') === 'expired' ? 'selected' : '' }}>Expired</option>
                                <option value="failed" {{ request('status') === 'failed' ? 'selected' : '' }}>Failed</option>
                                <option value="refunded" {{ request('status') === 'refunded' ? 'selected' : '' }}>Refunded</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Jenis</label>
                            <select class="form-control" name="jenis_transaksi">
                                <option value="">Semua Jenis</option>
                                <option value="tiket_wisata" {{ request('jenis_transaksi') === 'tiket_wisata' ? 'selected' : '' }}>Tiket Wisata</option>
                                <option value="produk_umkm" {{ request('jenis_transaksi') === 'produk_umkm' ? 'selected' : '' }}>Produk UMKM</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Metode Pembayaran</label>
                            <select class="form-control" name="metode_pembayaran">
                                <option value="">Semua Metode</option>
                                <option value="bank_transfer" {{ request('metode_pembayaran') === 'bank_transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                <option value="e_wallet" {{ request('metode_pembayaran') === 'e_wallet' ? 'selected' : '' }}>E-Wallet</option>
                                <option value="virtual_account" {{ request('metode_pembayaran') === 'virtual_account' ? 'selected' : '' }}>Virtual Account</option>
                                <option value="qris" {{ request('metode_pembayaran') === 'qris' ? 'selected' : '' }}>QRIS</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Tanggal</label>
                            <input type="date" class="form-control" name="tanggal" value="{{ request('tanggal') }}">
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex flex-column">
                                <button type="submit" class="btn btn-primary btn-sm mb-1"><i class="fas fa-search"></i></button>
                                <a href="{{ route('admin.transaksi.index') }}" class="btn btn-secondary btn-sm"><i class="fas fa-undo"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Transaksi</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kode Transaksi</th>
                            <th>Pelanggan</th>
                            <th>Jenis</th>
                            <th>Item</th>
                            <th>Metode Bayar</th>
                            <th>Jumlah</th>
                            <th>Status</th>
                            <th>Tanggal</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transaksi as $index => $trans)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                <span class="font-weight-bold">{{ $trans->kode_transaksi }}</span>
                                @if($trans->reference)
                                    <br><small class="text-muted">Ref: {{ $trans->reference }}</small>
                                @endif
                            </td>
                            <td>
                                <div class="font-weight-bold">{{ $trans->nama_pelanggan }}</div>
                                <small>{{ $trans->email_pelanggan }}</small>
                            </td>
                            <td>
                                <span class="badge badge-{{ $trans->jenis_transaksi === 'tiket_wisata' ? 'info' : 'success' }}">
                                    {{ $trans->jenis_transaksi === 'tiket_wisata' ? 'Tiket Wisata' : 'Produk UMKM' }}
                                </span>
                            </td>
                            <td>
                                <div class="font-weight-bold">{{ $trans->nama_item }}</div>
                                <small>Qty: {{ $trans->quantity }}</small>
                            </td>
                            <td>{{ $trans->metode_pembayaran_display }}</td>
                            <td class="font-weight-bold">Rp {{ number_format($trans->total_amount) }}</td>
                            <td>
                                @if($trans->status === 'paid' || $trans->status === 'settled')
                                    <span class="badge badge-success">{{ ucfirst($trans->status) }}</span>
                                @elseif($trans->status === 'pending')
                                    <span class="badge badge-warning">Pending</span>
                                @elseif($trans->status === 'expired')
                                    <span class="badge badge-secondary">Expired</span>
                                @elseif($trans->status === 'failed')
                                    <span class="badge badge-danger">Failed</span>
                                @elseif($trans->status === 'refunded')
                                    <span class="badge badge-dark">Refunded</span>
                                @else
                                    <span class="badge badge-light">{{ ucfirst($trans->status) }}</span>
                                @endif
                            </td>
                            <td>{{ $trans->created_at->format('d/m/Y H:i') }}</td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.transaksi.show', $trans->id) }}" class="btn btn-info btn-sm" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    @if($trans->status === 'pending')
                                        <button class="btn btn-warning btn-sm" onclick="checkPaymentStatus({{ $trans->id }})" title="Cek Status">
                                            <i class="fas fa-sync"></i>
                                        </button>
                                    @endif
                                    @if(in_array($trans->status, ['paid', 'settled']))
                                        <button class="btn btn-danger btn-sm" onclick="initiateRefund({{ $trans->id }})" title="Refund">
                                            <i class="fas fa-undo"></i>
                                        </button>
                                    @endif
                                    <a href="{{ route('admin.transaksi.invoice', $trans->id) }}" class="btn btn-secondary btn-sm" title="Invoice">
                                        <i class="fas fa-file-invoice"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10" class="text-center py-4">
                                <i class="fas fa-credit-card fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Tidak ada data transaksi</h5>
                                <p class="text-muted">Transaksi akan muncul ketika ada pembelian atau booking</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($transaksi->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Menampilkan {{ $transaksi->firstItem() }} - {{ $transaksi->lastItem() }} 
                        dari {{ $transaksi->total() }} data
                    </div>
                    {{ $transaksi->appends(request()->query())->links() }}
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Refund Modal -->
<div class="modal fade" id="refundModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Proses Refund</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <form id="refundForm" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label>Jumlah Refund</label>
                        <input type="number" class="form-control" name="refund_amount" id="refundAmount" required>
                        <small class="text-muted">Kosongkan untuk refund penuh</small>
                    </div>
                    <div class="form-group">
                        <label>Alasan Refund</label>
                        <textarea class="form-control" name="refund_reason" rows="3" required placeholder="Masukkan alasan refund..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Proses Refund</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function checkPaymentStatus(id) {
    if (confirm('Cek status pembayaran terbaru?')) {
        window.location.href = `/admin/transaksi/${id}/check-status`;
    }
}

function initiateRefund(id) {
    $('#refundForm').attr('action', `/admin/transaksi/${id}/refund`);
    $('#refundModal').modal('show');
}

function exportTransactions() {
    const params = new URLSearchParams(window.location.search);
    window.location.href = '{{ route("admin.transaksi.export") }}?' + params.toString();
}

function syncPayments() {
    if (confirm('Sinkronisasi semua pembayaran pending dengan gateway?')) {
        window.location.href = '{{ route("admin.transaksi.sync") }}';
    }
}

// Auto-hide alerts
setTimeout(function() {
    $('.alert').fadeOut('slow');
}, 5000);
</script>
@endpush
