@extends('layouts.app')

@section('title', 'Tambah UMKM')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.umkm.index') }}">UMKM</a></li>
<li class="breadcrumb-item active">Tambah UMKM</li>
@endsection

@section('content')
<div class="container-fluid">
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-plus text-primary me-2"></i>
                Tambah UMKM Baru
            </h1>
            <p class="text-muted mb-0">Tambah data Usaha Mikro Kecil Menengah (UMKM) baru</p>
        </div>
        <a href="{{ route('admin.umkm.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Kembali
        </a>
    </div>

    <!-- Form Section -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Form Tambah UMKM</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.umkm.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <!-- Basic Information -->
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Informasi Dasar</h6>
                        
                        <div class="mb-3">
                            <label for="nama_umkm" class="form-label">Nama UMKM <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('nama_umkm') is-invalid @enderror" 
                                   id="nama_umkm" name="nama_umkm" value="{{ old('nama_umkm') }}" required>
                            @error('nama_umkm')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-control @error('kategori') is-invalid @enderror" id="kategori" name="kategori" required>
                                <option value="">Pilih Kategori</option>
                                @if(isset($kategoris))
                                    @foreach($kategoris as $key => $label)
                                        <option value="{{ $key }}" {{ old('kategori') == $key ? 'selected' : '' }}>{{ $label }}</option>
                                    @endforeach
                                @else
                                    <option value="makanan_minuman">Makanan & Minuman</option>
                                    <option value="kerajinan_tangan">Kerajinan Tangan</option>
                                    <option value="fashion_tekstil">Fashion & Tekstil</option>
                                    <option value="jasa_layanan">Jasa & Layanan</option>
                                    <option value="pertanian_perkebunan">Pertanian & Perkebunan</option>
                                    <option value="peternakan_perikanan">Peternakan & Perikanan</option>
                                    <option value="teknologi_digital">Teknologi Digital</option>
                                    <option value="perdagangan_retail">Perdagangan & Retail</option>
                                    <option value="pariwisata_budaya">Pariwisata & Budaya</option>
                                    <option value="lainnya">Lainnya</option>
                                @endif
                            </select>
                            @error('kategori')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="pemilik_id" class="form-label">Pemilik <span class="text-danger">*</span></label>
                            <select class="form-control @error('pemilik_id') is-invalid @enderror" id="pemilik_id" name="pemilik_id" required>
                                <option value="">Pilih Pemilik</option>
                                @if(isset($penduduk))
                                    @foreach($penduduk as $p)
                                        <option value="{{ $p->id }}" {{ old('pemilik_id') == $p->id ? 'selected' : '' }}>{{ $p->nama }} ({{ $p->nik }})</option>
                                    @endforeach
                                @else
                                    <option value="1">Test Pemilik (1234567890123456)</option>
                                @endif
                            </select>
                            @error('pemilik_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="skala_usaha" class="form-label">Skala Usaha <span class="text-danger">*</span></label>
                            <select class="form-control @error('skala_usaha') is-invalid @enderror" id="skala_usaha" name="skala_usaha" required>
                                <option value="">Pilih Skala</option>
                                <option value="mikro" {{ old('skala_usaha') == 'mikro' ? 'selected' : '' }}>Mikro</option>
                                <option value="kecil" {{ old('skala_usaha') == 'kecil' ? 'selected' : '' }}>Kecil</option>
                                <option value="menengah" {{ old('skala_usaha') == 'menengah' ? 'selected' : '' }}>Menengah</option>
                            </select>
                            @error('skala_usaha')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="deskripsi" class="form-label">Deskripsi <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                      id="deskripsi" name="deskripsi" rows="4" required>{{ old('deskripsi') }}</textarea>
                            @error('deskripsi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <!-- Contact & Location -->
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Kontak & Lokasi</h6>
                        
                        <div class="mb-3">
                            <label for="alamat" class="form-label">Alamat <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                      id="alamat" name="alamat" rows="3" required>{{ old('alamat') }}</textarea>
                            @error('alamat')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nomor_telepon" class="form-label">Nomor Telepon</label>
                                    <input type="text" class="form-control @error('nomor_telepon') is-invalid @enderror" 
                                           id="nomor_telepon" name="nomor_telepon" value="{{ old('nomor_telepon') }}">
                                    @error('nomor_telepon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="whatsapp" class="form-label">WhatsApp</label>
                                    <input type="text" class="form-control @error('whatsapp') is-invalid @enderror" 
                                           id="whatsapp" name="whatsapp" value="{{ old('whatsapp') }}">
                                    @error('whatsapp')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                   id="email" name="email" value="{{ old('email') }}">
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="website" class="form-label">Website</label>
                            <input type="url" class="form-control @error('website') is-invalid @enderror" 
                                   id="website" name="website" value="{{ old('website') }}">
                            @error('website')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="latitude" class="form-label">Latitude</label>
                                    <input type="number" step="any" class="form-control @error('latitude') is-invalid @enderror" 
                                           id="latitude" name="latitude" value="{{ old('latitude') }}">
                                    @error('latitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="longitude" class="form-label">Longitude</label>
                                    <input type="number" step="any" class="form-control @error('longitude') is-invalid @enderror" 
                                           id="longitude" name="longitude" value="{{ old('longitude') }}">
                                    @error('longitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Media Upload -->
                <div class="row mt-4">
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Media</h6>
                        
                        <div class="mb-3">
                            <label for="logo" class="form-label">Logo UMKM</label>
                            <input type="file" class="form-control @error('logo') is-invalid @enderror" 
                                   id="logo" name="logo" accept="image/*">
                            <small class="text-muted">Format: JPG, PNG. Maksimal 2MB</small>
                            @error('logo')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="galeri_foto" class="form-label">Galeri Foto</label>
                            <input type="file" class="form-control @error('galeri_foto.*') is-invalid @enderror" 
                                   id="galeri_foto" name="galeri_foto[]" accept="image/*" multiple>
                            <small class="text-muted">Bisa pilih beberapa foto sekaligus</small>
                            @error('galeri_foto.*')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Pengaturan</h6>
                        
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="aktif_marketplace" 
                                       name="aktif_marketplace" value="1" {{ old('aktif_marketplace') ? 'checked' : '' }}>
                                <label class="form-check-label" for="aktif_marketplace">
                                    Aktifkan di Marketplace
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="bisa_cod" 
                                       name="bisa_cod" value="1" {{ old('bisa_cod', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="bisa_cod">
                                    Terima COD (Cash on Delivery)
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="bisa_transfer" 
                                       name="bisa_transfer" value="1" {{ old('bisa_transfer', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="bisa_transfer">
                                    Terima Transfer
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="tags" class="form-label">Tags</label>
                            <input type="text" class="form-control @error('tags') is-invalid @enderror" 
                                   id="tags" name="tags" 
                                   placeholder="organik, halal, handmade (pisahkan dengan koma)" 
                                   value="{{ old('tags') }}">
                            @error('tags')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('admin.umkm.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>Batal
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Simpan UMKM
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Form validation
    $('form').on('submit', function(e) {
        const submitBtn = $(this).find('button[type="submit"]');
        const originalText = submitBtn.html();
        
        // Disable submit button and show loading
        submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i>Menyimpan...');
        
        // Re-enable after 5 seconds as fallback
        setTimeout(function() {
            submitBtn.prop('disabled', false).html(originalText);
        }, 5000);
    });
});
</script>
@endpush