@extends('layouts.app')

@section('title', 'Profile')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Profile</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-user me-2"></i>
                        Profile Pengguna
                    </h3>
                </div>
                
                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('profile.update') }}" class="needs-validation" novalidate>
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- Profile Information -->
                            <div class="col-md-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-user-edit me-2"></i>
                                            Informasi Profile
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="name" class="form-label">
                                                        <i class="fas fa-user me-1"></i>
                                                        Nama Lengkap
                                                    </label>
                                                    <input type="text" 
                                                           class="form-control @error('name') is-invalid @enderror" 
                                                           id="name" 
                                                           name="name" 
                                                           value="{{ old('name', Auth::user()->name) }}" 
                                                           required 
                                                           autocomplete="name"
                                                           placeholder="Masukkan nama lengkap">
                                                    @error('name')
                                                        <div class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="email" class="form-label">
                                                        <i class="fas fa-envelope me-1"></i>
                                                        Email
                                                    </label>
                                                    <input type="email" 
                                                           class="form-control @error('email') is-invalid @enderror" 
                                                           id="email" 
                                                           name="email" 
                                                           value="{{ old('email', Auth::user()->email) }}" 
                                                           required 
                                                           autocomplete="email"
                                                           placeholder="Masukkan email">
                                                    @error('email')
                                                        <div class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="phone" class="form-label">
                                                        <i class="fas fa-phone me-1"></i>
                                                        Nomor Telepon
                                                    </label>
                                                    <input type="text" 
                                                           class="form-control @error('phone') is-invalid @enderror" 
                                                           id="phone" 
                                                           name="phone" 
                                                           value="{{ old('phone', Auth::user()->phone) }}" 
                                                           autocomplete="tel"
                                                           placeholder="Masukkan nomor telepon">
                                                    @error('phone')
                                                        <div class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="role" class="form-label">
                                                        <i class="fas fa-user-shield me-1"></i>
                                                        Role
                                                    </label>
                                                    <input type="text" 
                                                           class="form-control" 
                                                           value="{{ Auth::user()->role ?? 'Admin' }}" 
                                                           readonly
                                                           style="background-color: #f8f9fa;">
                                                    <small class="form-text text-muted">
                                                        Role tidak dapat diubah dari halaman ini
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Profile Avatar & Actions -->
                            <div class="col-md-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-image me-2"></i>
                                            Avatar
                                        </h5>
                                    </div>
                                    <div class="card-body text-center">
                                        <div class="mb-3">
                                            <div class="user-avatar mx-auto" style="width: 120px; height: 120px; font-size: 48px;">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                        
                                        <p class="text-muted mb-3">
                                            Avatar akan ditampilkan di seluruh sistem
                                        </p>
                                        
                                        <button type="button" class="btn btn-outline-primary btn-sm" disabled>
                                            <i class="fas fa-upload me-1"></i>
                                            Upload Avatar
                                        </button>
                                        <small class="d-block text-muted mt-2">
                                            Fitur upload avatar akan segera hadir
                                        </small>
                                    </div>
                                </div>

                                <!-- Account Information -->
                                <div class="card mt-3">
                                    <div class="card-header">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-info-circle me-2"></i>
                                            Informasi Akun
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-2">
                                            <small class="text-muted">Terdaftar sejak:</small>
                                            <div class="fw-semibold">
                                                {{ Auth::user()->created_at->format('d F Y') }}
                                            </div>
                                        </div>
                                        
                                        <div class="mb-2">
                                            <small class="text-muted">Terakhir diupdate:</small>
                                            <div class="fw-semibold">
                                                {{ Auth::user()->updated_at->format('d F Y H:i') }}
                                            </div>
                                        </div>
                                        
                                        <div class="mb-0">
                                            <small class="text-muted">Status:</small>
                                            <div>
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check-circle me-1"></i>
                                                    Aktif
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Password Change Section -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-lock me-2"></i>
                                            Ubah Password
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle me-2"></i>
                                            <strong>Catatan:</strong> Kosongkan field password jika tidak ingin mengubah password.
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="current_password" class="form-label">
                                                        <i class="fas fa-key me-1"></i>
                                                        Password Saat Ini
                                                    </label>
                                                    <div class="input-group">
                                                        <input type="password" 
                                                               class="form-control @error('current_password') is-invalid @enderror" 
                                                               id="current_password" 
                                                               name="current_password" 
                                                               autocomplete="current-password"
                                                               placeholder="Masukkan password saat ini">
                                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('current_password')">
                                                            <i class="fas fa-eye" id="current_password_icon"></i>
                                                        </button>
                                                    </div>
                                                    @error('current_password')
                                                        <div class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="password" class="form-label">
                                                        <i class="fas fa-lock me-1"></i>
                                                        Password Baru
                                                    </label>
                                                    <div class="input-group">
                                                        <input type="password" 
                                                               class="form-control @error('password') is-invalid @enderror" 
                                                               id="password" 
                                                               name="password" 
                                                               autocomplete="new-password"
                                                               placeholder="Masukkan password baru">
                                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('password')">
                                                            <i class="fas fa-eye" id="password_icon"></i>
                                                        </button>
                                                    </div>
                                                    @error('password')
                                                        <div class="invalid-feedback">
                                                            {{ $message }}
                                                        </div>
                                                    @enderror
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="password_confirmation" class="form-label">
                                                        <i class="fas fa-lock me-1"></i>
                                                        Konfirmasi Password
                                                    </label>
                                                    <div class="input-group">
                                                        <input type="password" 
                                                               class="form-control" 
                                                               id="password_confirmation" 
                                                               name="password_confirmation" 
                                                               autocomplete="new-password"
                                                               placeholder="Konfirmasi password baru">
                                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('password_confirmation')">
                                                            <i class="fas fa-eye" id="password_confirmation_icon"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left me-2"></i>
                                        Kembali ke Dashboard
                                    </a>
                                    
                                    <div>
                                        <button type="button" class="btn btn-outline-danger me-2" onclick="resetForm()">
                                            <i class="fas fa-undo me-2"></i>
                                            Reset
                                        </button>
                                        <button type="submit" class="btn btn-gradient-primary">
                                            <i class="fas fa-save me-2"></i>
                                            Simpan Perubahan
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Toggle password visibility
    function togglePassword(fieldId) {
        const passwordInput = document.getElementById(fieldId);
        const toggleIcon = document.getElementById(fieldId + '_icon');
        
        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            toggleIcon.className = 'fas fa-eye-slash';
        } else {
            passwordInput.type = 'password';
            toggleIcon.className = 'fas fa-eye';
        }
    }

    // Reset form
    function resetForm() {
        if (confirm('Apakah Anda yakin ingin mereset form? Semua perubahan yang belum disimpan akan hilang.')) {
            document.querySelector('form').reset();
            
            // Reset password fields to hidden
            ['current_password', 'password', 'password_confirmation'].forEach(fieldId => {
                const field = document.getElementById(fieldId);
                const icon = document.getElementById(fieldId + '_icon');
                if (field && icon) {
                    field.type = 'password';
                    icon.className = 'fas fa-eye';
                }
            });
            
            // Remove validation classes
            document.querySelectorAll('.is-invalid').forEach(element => {
                element.classList.remove('is-invalid');
            });
            
            showToast('Form telah direset', 'info');
        }
    }

    // Form validation
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('.needs-validation');
        
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            
            form.classList.add('was-validated');
        });

        // Real-time validation for password fields
        const passwordField = document.getElementById('password');
        const confirmPasswordField = document.getElementById('password_confirmation');
        
        if (passwordField && confirmPasswordField) {
            confirmPasswordField.addEventListener('input', function() {
                if (this.value !== passwordField.value) {
                    this.setCustomValidity('Password tidak cocok');
                } else {
                    this.setCustomValidity('');
                }
            });
        }

        // Auto-save draft functionality
        const inputs = form.querySelectorAll('input[type="text"], input[type="email"]');
        inputs.forEach(input => {
            input.addEventListener('input', function() {
                // Save to localStorage as draft
                const formData = new FormData(form);
                const data = {};
                for (let [key, value] of formData.entries()) {
                    if (key !== 'password' && key !== 'password_confirmation' && key !== 'current_password') {
                        data[key] = value;
                    }
                }
                localStorage.setItem('profile_draft', JSON.stringify(data));
            });
        });

        // Load draft on page load
        const draft = localStorage.getItem('profile_draft');
        if (draft) {
            try {
                const data = JSON.parse(draft);
                Object.keys(data).forEach(key => {
                    const field = document.querySelector(`[name="${key}"]`);
                    if (field && !field.value) {
                        field.value = data[key];
                    }
                });
            } catch (e) {
                console.warn('Could not load profile draft:', e);
            }
        }
    });

    // Clear draft on successful save
    document.querySelector('form').addEventListener('submit', function() {
        localStorage.removeItem('profile_draft');
    });

    // Enhanced toast notifications
    function showToast(message, type = 'success') {
        const iconMap = {
            success: 'check-circle',
            error: 'exclamation-triangle',
            warning: 'exclamation-circle',
            info: 'info-circle'
        };

        const colorMap = {
            success: '#10b981',
            error: '#ef4444',
            warning: '#f59e0b',
            info: '#3b82f6'
        };

        if (typeof Swal !== 'undefined') {
            Swal.fire({
                icon: type,
                title: type.charAt(0).toUpperCase() + type.slice(1),
                text: message,
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 4000,
                timerProgressBar: true,
                iconColor: colorMap[type]
            });
        } else {
            // Fallback to alert if SweetAlert is not available
            alert(message);
        }
    }
</script>
@endpush
