<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cek Layanan - Sistem Informasi Desa</title>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#10B981">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#ecfdf5',
                            500: '#10b981',
                            600: '#059669',
                            700: '#047857'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            padding: 1.5rem;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            border: 1px solid #f3f4f6;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        }
        
        .form-input {
            padding: 0.75rem;
            border: 2px solid #e5e7eb;
            border-radius: 0.5rem;
            transition: all 0.3s;
            font-size: 1rem;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #10b981;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }
        
        .form-input.error {
            border-color: #ef4444;
        }
        
        .status-badge {
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-diajukan {
            background-color: #fbbf24;
            color: #92400e;
        }
        
        .status-diproses {
            background-color: #60a5fa;
            color: #1e40af;
        }
        
        .status-selesai {
            background-color: #34d399;
            color: #047857;
        }
        
        .status-baru {
            background-color: #f87171;
            color: #991b1b;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header -->
        <div class="gradient-bg text-white px-6 py-6 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 left-0 w-40 h-40 bg-white rounded-full -translate-x-20 -translate-y-20"></div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-white rounded-full translate-x-16 translate-y-16"></div>
            </div>
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-4">
                    <button onclick="goBack()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z"/>
                        </svg>
                    </button>
                    
                    <div class="text-center">
                        <h1 class="text-lg font-bold">Cek Layanan</h1>
                        <p class="text-white/80 text-sm">Status surat & pengaduan</p>
                    </div>
                    
                    <div class="w-10 h-10"></div> <!-- Spacer -->
                </div>
            </div>
        </div>

        <!-- Content -->
        <div class="px-6 py-6">
            <!-- Search Form -->
            <div class="mobile-card mb-6">
                <h3 class="font-semibold text-gray-800 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-green-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"/>
                    </svg>
                    Cek Status Layanan
                </h3>
                
                <form id="form-cek" class="space-y-4">
                    <!-- Tipe Layanan -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-800 mb-2">
                            Tipe Layanan <span class="text-red-500">*</span>
                        </label>
                        <select id="tipe" name="tipe" class="form-input w-full" required>
                            <option value="">Pilih Tipe Layanan</option>
                            <option value="surat">Pengajuan Surat</option>
                            <option value="pengaduan">Pengaduan</option>
                        </select>
                        <div id="tipe-error" class="text-red-500 text-xs mt-1 hidden">Tipe layanan wajib dipilih</div>
                    </div>

                    <!-- Nomor Tiket/Antrian -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-800 mb-2">
                            Nomor Tiket/Antrian <span class="text-red-500">*</span>
                        </label>
                        <input type="text" 
                               id="nomor_antrian" 
                               name="nomor_antrian" 
                               class="form-input w-full" 
                               placeholder="Contoh: ANT-20241115-001 atau TKT-20241115-001"
                               required>
                        <div id="nomor-error" class="text-red-500 text-xs mt-1 hidden">Nomor tiket/antrian wajib diisi</div>
                        <p class="text-xs text-gray-500 mt-1">Masukkan nomor yang diberikan saat pengajuan</p>
                    </div>

                    <!-- Submit Button -->
                    <div class="pt-2">
                        <button type="submit" 
                                id="submit-btn"
                                class="w-full bg-green-600 text-white py-3 px-4 rounded-lg font-semibold hover:bg-green-700 transition-colors disabled:bg-gray-400 disabled:cursor-not-allowed">
                            <span id="submit-text">Cek Status</span>
                            <span id="loading-text" class="hidden">Mencari...</span>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Result Container -->
            <div id="result-container" class="hidden">
                <!-- Status Found -->
                <div id="status-found" class="mobile-card hidden">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="font-semibold text-gray-800">Status Layanan</h3>
                        <span id="status-badge" class="status-badge">Status</span>
                    </div>
                    
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Nomor:</span>
                            <span id="result-nomor" class="font-semibold">-</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Nama:</span>
                            <span id="result-nama" class="font-semibold">-</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Jenis:</span>
                            <span id="result-jenis" class="font-semibold">-</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Tanggal:</span>
                            <span id="result-tanggal" class="font-semibold">-</span>
                        </div>
                        <div id="result-keterangan-container" class="hidden">
                            <span class="text-gray-600">Keterangan:</span>
                            <p id="result-keterangan" class="mt-1 text-sm">-</p>
                        </div>
                    </div>

                    <!-- Progress Timeline -->
                    <div class="mt-6">
                        <h4 class="font-semibold text-gray-800 mb-3">Progress</h4>
                        <div class="space-y-3">
                            <div id="step-1" class="flex items-center">
                                <div class="w-4 h-4 rounded-full bg-green-500"></div>
                                <div class="ml-3">
                                    <div class="text-sm font-medium text-gray-900">Diajukan</div>
                                    <div class="text-xs text-gray-500">Permohonan telah diterima</div>
                                </div>
                            </div>
                            <div id="step-2" class="flex items-center">
                                <div class="w-4 h-4 rounded-full bg-gray-300"></div>
                                <div class="ml-3">
                                    <div class="text-sm font-medium text-gray-500">Diproses</div>
                                    <div class="text-xs text-gray-500">Sedang dalam proses verifikasi</div>
                                </div>
                            </div>
                            <div id="step-3" class="flex items-center">
                                <div class="w-4 h-4 rounded-full bg-gray-300"></div>
                                <div class="ml-3">
                                    <div class="text-sm font-medium text-gray-500">Selesai</div>
                                    <div class="text-xs text-gray-500">Siap untuk diambil/ditindaklanjuti</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Status Not Found -->
                <div id="status-not-found" class="mobile-card bg-red-50 border-red-200 hidden">
                    <div class="flex items-center space-x-3">
                        <svg class="w-6 h-6 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"/>
                        </svg>
                        <div>
                            <p class="font-semibold text-red-800">Data Tidak Ditemukan</p>
                            <p class="text-sm text-red-600">Nomor tiket/antrian tidak ditemukan. Pastikan nomor yang dimasukkan benar.</p>
                        </div>
                    </div>
                </div>

                <!-- Error -->
                <div id="status-error" class="mobile-card bg-red-50 border-red-200 hidden">
                    <div class="flex items-center space-x-3">
                        <svg class="w-6 h-6 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"/>
                        </svg>
                        <div>
                            <p class="font-semibold text-red-800">Terjadi Kesalahan</p>
                            <p class="text-sm text-red-600" id="error-message">Silakan coba lagi nanti.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Info -->
            <div class="mobile-card bg-blue-50 border-blue-200">
                <h3 class="font-semibold text-gray-800 mb-3 flex items-center">
                    <svg class="w-5 h-5 text-blue-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"/>
                    </svg>
                    Informasi
                </h3>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li>• Surat dapat diambil jika status sudah "Selesai"</li>
                    <li>• Pengaduan akan ditindaklanjuti maksimal 3x24 jam</li>
                    <li>• Jam operasional: 08:00 - 15:00 WIB</li>
                    <li>• Bawa identitas diri saat pengambilan surat</li>
                </ul>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-200 px-6 py-4 z-50 shadow-lg">
            <div class="flex justify-around">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"/>
                    </svg>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M2 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 002 2H4a2 2 0 01-2-2V5zm3 1h6v4H5V6zm6 6H5v2h6v-2z"/>
                        <path d="M15 7h1a2 2 0 012 2v5.5a1.5 1.5 0 01-3 0V7z"/>
                    </svg>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"/>
                    </svg>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"/>
                    </svg>
                    <span class="text-xs">Umkm</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 011 1v12a1 1 0 11-2 0V4a1 1 0 011-1zm7.707 3.293a1 1 0 010 1.414L9.414 9H17a1 1 0 110 2H9.414l1.293 1.293a1 1 0 01-1.414 1.414l-3-3a1 1 0 010-1.414l3-3a1 1 0 011.414 0z"/>
                    </svg>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <!-- JavaScript -->
    <script>
        function goBack() {
            window.history.back();
        }

        // Form submission
        document.getElementById('form-cek').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Clear previous errors and results
            document.querySelectorAll('.text-red-500').forEach(el => el.classList.add('hidden'));
            document.querySelectorAll('.form-input').forEach(el => el.classList.remove('error'));
            document.getElementById('result-container').classList.add('hidden');
            document.getElementById('status-found').classList.add('hidden');
            document.getElementById('status-not-found').classList.add('hidden');
            document.getElementById('status-error').classList.add('hidden');
            
            let isValid = true;
            
            // Validate required fields
            const requiredFields = ['tipe', 'nomor_antrian'];
            requiredFields.forEach(field => {
                const element = document.getElementById(field);
                if (!element.value.trim()) {
                    document.getElementById(field.replace('_', '-') + '-error').classList.remove('hidden');
                    element.classList.add('error');
                    isValid = false;
                }
            });
            
            if (isValid) {
                // Show loading
                const submitBtn = document.getElementById('submit-btn');
                const submitText = document.getElementById('submit-text');
                const loadingText = document.getElementById('loading-text');
                
                submitBtn.disabled = true;
                submitText.classList.add('hidden');
                loadingText.classList.remove('hidden');
                
                // Prepare form data
                const formData = new FormData();
                formData.append('tipe', document.getElementById('tipe').value);
                formData.append('nomor_antrian', document.getElementById('nomor_antrian').value);
                
                // Submit to backend
                fetch('/cek-layanan', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '',
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    document.getElementById('result-container').classList.remove('hidden');
                    
                    if (data.success && data.data) {
                        showStatus(data.data);
                    } else {
                        document.getElementById('status-not-found').classList.remove('hidden');
                    }
                })
                .catch(error => {
                    document.getElementById('result-container').classList.remove('hidden');
                    document.getElementById('status-error').classList.remove('hidden');
                    document.getElementById('error-message').textContent = error.message || 'Terjadi kesalahan sistem';
                })
                .finally(() => {
                    // Hide loading
                    submitBtn.disabled = false;
                    submitText.classList.remove('hidden');
                    loadingText.classList.add('hidden');
                });
            }
        });

        function showStatus(data) {
            document.getElementById('status-found').classList.remove('hidden');
            
            // Fill in the data
            document.getElementById('result-nomor').textContent = data.nomor_antrian || data.nomor_tiket || '-';
            document.getElementById('result-nama').textContent = data.nama || '-';
            document.getElementById('result-jenis').textContent = data.jenis_surat || data.judul || '-';
            
            // Format date
            const date = new Date(data.created_at || data.tanggal_pengajuan || data.tanggal_pengaduan);
            document.getElementById('result-tanggal').textContent = date.toLocaleDateString('id-ID');
            
            // Set status badge
            const statusBadge = document.getElementById('status-badge');
            const status = data.status || 'Unknown';
            statusBadge.textContent = status;
            
            // Remove all status classes and add appropriate one
            statusBadge.className = 'status-badge';
            if (status.toLowerCase().includes('diajukan') || status.toLowerCase().includes('menunggu')) {
                statusBadge.classList.add('status-diajukan');
            } else if (status.toLowerCase().includes('proses')) {
                statusBadge.classList.add('status-diproses');
            } else if (status.toLowerCase().includes('selesai') || status.toLowerCase().includes('ditanggapi')) {
                statusBadge.classList.add('status-selesai');
            } else {
                statusBadge.classList.add('status-baru');
            }
            
            // Update progress timeline
            updateProgressTimeline(status);
            
            // Show keterangan if available
            if (data.keterangan || data.tanggapan) {
                document.getElementById('result-keterangan').textContent = data.keterangan || data.tanggapan;
                document.getElementById('result-keterangan-container').classList.remove('hidden');
            }
        }

        function updateProgressTimeline(status) {
            // Reset all steps
            ['step-1', 'step-2', 'step-3'].forEach(stepId => {
                const step = document.getElementById(stepId);
                const circle = step.querySelector('.w-4');
                const text = step.querySelectorAll('.text-sm, .text-xs');
                
                circle.className = 'w-4 h-4 rounded-full bg-gray-300';
                text.forEach(t => t.className = t.className.replace('text-gray-900', 'text-gray-500'));
            });
            
            // Activate steps based on status
            const step1 = document.getElementById('step-1');
            step1.querySelector('.w-4').className = 'w-4 h-4 rounded-full bg-green-500';
            step1.querySelectorAll('.text-sm')[0].className = 'text-sm font-medium text-gray-900';
            
            if (status.toLowerCase().includes('proses')) {
                const step2 = document.getElementById('step-2');
                step2.querySelector('.w-4').className = 'w-4 h-4 rounded-full bg-blue-500';
                step2.querySelectorAll('.text-sm')[0].className = 'text-sm font-medium text-gray-900';
            }
            
            if (status.toLowerCase().includes('selesai') || status.toLowerCase().includes('ditanggapi')) {
                const step2 = document.getElementById('step-2');
                const step3 = document.getElementById('step-3');
                
                step2.querySelector('.w-4').className = 'w-4 h-4 rounded-full bg-green-500';
                step2.querySelectorAll('.text-sm')[0].className = 'text-sm font-medium text-gray-900';
                
                step3.querySelector('.w-4').className = 'w-4 h-4 rounded-full bg-green-500';
                step3.querySelectorAll('.text-sm')[0].className = 'text-sm font-medium text-gray-900';
            }
        }
        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }
    </script>
</body>
</html> 
