<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - Aplikasi Desa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-50 font-inter">
    <!-- Header -->
    <div class="bg-gradient-to-r from-blue-600 to-purple-600 text-white p-4">
        <div class="flex items-center space-x-3">
            <button onclick="window.history.back()" class="w-8 h-8 bg-white/20 rounded-full flex items-center justify-center">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </button>
            <h1 class="text-lg font-semibold">Checkout</h1>
        </div>
    </div>

    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <form action="/checkout/process" method="POST">
        <input type="hidden" name="_token" value="<?php echo csrf_token(); ?>">
        
            <!-- Order Summary -->
            <div class="px-6 py-4">
            <div class="bg-white rounded-xl shadow-lg p-4 mb-4">
                <h3 class="font-semibold text-gray-800 mb-3">Ringkasan Pesanan</h3>
                
                <!-- Sample cart items - in real app this would be dynamic -->
                <div class="space-y-3 mb-4">
                    <div class="flex items-center space-x-3">
                        <img src="https://via.placeholder.com/50x50/f1f5f9/64748b?text=P" alt="Produk" class="w-12 h-12 object-cover rounded-lg">
                        <div class="flex-1">
                            <h4 class="text-sm font-medium text-gray-800">Keripik Singkong</h4>
                            <p class="text-xs text-gray-500">2x Rp 25.000</p>
                        </div>
                        <span class="text-sm font-medium text-gray-800">Rp 50.000</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <img src="https://via.placeholder.com/50x50/f1f5f9/64748b?text=P" alt="Produk" class="w-12 h-12 object-cover rounded-lg">
                        <div class="flex-1">
                            <h4 class="text-sm font-medium text-gray-800">Madu Murni</h4>
                            <p class="text-xs text-gray-500">1x Rp 75.000</p>
                        </div>
                        <span class="text-sm font-medium text-gray-800">Rp 75.000</span>
                    </div>
                </div>
                
                <!-- Order totals -->
                <div class="border-t pt-3 space-y-2">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Subtotal</span>
                        <span class="text-gray-800">Rp 125.000</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Ongkir</span>
                        <span class="text-gray-800">Rp 10.000</span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Biaya Admin</span>
                        <span class="text-gray-800" id="admin-fee">Rp 0</span>
                    </div>
                    <div class="flex justify-between text-base font-semibold border-t pt-2">
                        <span class="text-gray-800">Total</span>
                        <span class="text-green-600" id="total-amount">Rp 135.000</span>
                    </div>
                </div>
            </div>
        </div>

            <!-- Customer Information -->
            <div class="px-6 mb-4">
            <div class="bg-white rounded-xl shadow-lg p-4">
                <h3 class="font-semibold text-gray-800 mb-4">Informasi Pembeli</h3>
                
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Nama Lengkap</label>
                        <input type="text" name="customer_name" required 
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                               placeholder="Masukkan nama lengkap">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                        <input type="email" name="customer_email" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                               placeholder="contoh@email.com">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">No. WhatsApp</label>
                        <input type="tel" name="customer_phone" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                               placeholder="08xxxxxxxxxx">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Alamat Lengkap</label>
                        <textarea name="customer_address" rows="3" required
                                  class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                  placeholder="Masukkan alamat lengkap untuk pengiriman"></textarea>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Catatan (Opsional)</label>
                        <textarea name="notes" rows="2"
                                  class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                  placeholder="Catatan khusus untuk pesanan"></textarea>
                    </div>
                </div>
            </div>
        </div>

            <!-- Payment Method -->
            <div class="px-6 mb-4">
            <div class="bg-white rounded-xl shadow-lg p-4">
                <h3 class="font-semibold text-gray-800 mb-4">Metode Pembayaran</h3>
                
                <!-- Virtual Account -->
                <div class="mb-4">
                    <h4 class="text-sm font-medium text-gray-700 mb-3">Virtual Account</h4>
                    <div class="space-y-2">
                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="payment_method" value="BRIVA" class="payment-option" data-fee="4000">
                            <img src="https://tripay.co.id/upload/payment-icon/YgCdBxY21649654936.png" alt="BRI" class="w-8 h-8 ml-3">
                            <div class="ml-3 flex-1">
                                <span class="text-sm font-medium text-gray-800">BRI Virtual Account</span>
                                <p class="text-xs text-gray-500">Biaya admin: Rp 4.000</p>
                            </div>
                        </label>
                        
                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="payment_method" value="BCAVA" class="payment-option" data-fee="4000">
                            <img src="https://tripay.co.id/upload/payment-icon/1ILuatq21649654936.png" alt="BCA" class="w-8 h-8 ml-3">
                            <div class="ml-3 flex-1">
                                <span class="text-sm font-medium text-gray-800">BCA Virtual Account</span>
                                <p class="text-xs text-gray-500">Biaya admin: Rp 4.000</p>
                            </div>
                        </label>
                        
                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="payment_method" value="BNIVA" class="payment-option" data-fee="4000">
                            <img src="https://tripay.co.id/upload/payment-icon/X6MgCnl51649654936.png" alt="BNI" class="w-8 h-8 ml-3">
                            <div class="ml-3 flex-1">
                                <span class="text-sm font-medium text-gray-800">BNI Virtual Account</span>
                                <p class="text-xs text-gray-500">Biaya admin: Rp 4.000</p>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- E-Wallet -->
                <div class="mb-4">
                    <h4 class="text-sm font-medium text-gray-700 mb-3">E-Wallet</h4>
                    <div class="space-y-2">
                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="payment_method" value="OVO" class="payment-option" data-fee="2500">
                            <img src="https://tripay.co.id/upload/payment-icon/qsE9n2l21649654936.png" alt="OVO" class="w-8 h-8 ml-3">
                            <div class="ml-3 flex-1">
                                <span class="text-sm font-medium text-gray-800">OVO</span>
                                <p class="text-xs text-gray-500">Biaya admin: Rp 2.500</p>
                            </div>
                        </label>
                        
                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="payment_method" value="DANA" class="payment-option" data-fee="2500">
                            <img src="https://tripay.co.id/upload/payment-icon/jRyO7gl21649654936.png" alt="DANA" class="w-8 h-8 ml-3">
                            <div class="ml-3 flex-1">
                                <span class="text-sm font-medium text-gray-800">DANA</span>
                                <p class="text-xs text-gray-500">Biaya admin: Rp 2.500</p>
                            </div>
                        </label>
                        
                        <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="payment_method" value="SHOPEEPAY" class="payment-option" data-fee="2500">
                            <img src="https://tripay.co.id/upload/payment-icon/2jCBWkJ21649654936.png" alt="ShopeePay" class="w-8 h-8 ml-3">
                            <div class="ml-3 flex-1">
                                <span class="text-sm font-medium text-gray-800">ShopeePay</span>
                                <p class="text-xs text-gray-500">Biaya admin: Rp 2.500</p>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- QRIS -->
                <div class="mb-4">
                    <h4 class="text-sm font-medium text-gray-700 mb-3">QRIS</h4>
                    <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                        <input type="radio" name="payment_method" value="QRIS" class="payment-option" data-fee="1500">
                        <img src="https://tripay.co.id/upload/payment-icon/qris-icon.png" alt="QRIS" class="w-8 h-8 ml-3">
                        <div class="ml-3 flex-1">
                            <span class="text-sm font-medium text-gray-800">QRIS</span>
                            <p class="text-xs text-gray-500">Biaya admin: Rp 1.500</p>
                        </div>
                    </label>
                </div>
            </div>
        </div>

            <!-- Payment Button -->
            <div class="px-6 py-4">
                <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-xl font-semibold text-lg hover:bg-green-700 transition-colors">
                    Bayar Sekarang
                </button>
            </div>
        </form>

        <!-- Bottom spacing -->
        <div class="h-8"></div>
    </div>

    <script>
        // Calculate total with admin fee
        const paymentOptions = document.querySelectorAll('.payment-option');
        const adminFeeElement = document.getElementById('admin-fee');
        const totalAmountElement = document.getElementById('total-amount');
        
        const baseTotal = 135000; // Base total without admin fee
        
        paymentOptions.forEach(option => {
            option.addEventListener('change', function() {
                if (this.checked) {
                    const fee = parseInt(this.dataset.fee);
                    const newTotal = baseTotal + fee;
                    
                    adminFeeElement.textContent = 'Rp ' + fee.toLocaleString('id-ID');
                    totalAmountElement.textContent = 'Rp ' + newTotal.toLocaleString('id-ID');
                }
            });
        });

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const paymentMethod = document.querySelector('input[name="payment_method"]:checked');
            
            if (!paymentMethod) {
                e.preventDefault();
                alert('Silakan pilih metode pembayaran');
                return false;
            }
        });
    </script>
</body>
</html> 