<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Info Bantuan - Sistem Informasi Desa</title>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#F59E0B">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#fffbeb',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            padding: 1.5rem;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            border: 1px solid #f3f4f6;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }
        
        .stat-card {
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
            border-radius: 1rem;
            padding: 1rem;
            color: white;
            text-align: center;
        }
        
        .program-card {
            border-left: 4px solid #f59e0b;
            transition: all 0.3s;
        }
        
        .program-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header -->
        <div class="gradient-bg text-white px-6 py-6 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 left-0 w-40 h-40 bg-white rounded-full -translate-x-20 -translate-y-20"></div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-white rounded-full translate-x-16 translate-y-16"></div>
            </div>
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-4">
                    <button onclick="goBack()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z"/>
                        </svg>
                    </button>
                    
                    <div class="text-center">
                        <h1 class="text-lg font-bold">Info Bantuan</h1>
                        <p class="text-white/80 text-sm">Program bantuan sosial</p>
                    </div>
                    
                    <div class="w-10 h-10"></div> <!-- Spacer -->
                </div>
            </div>
        </div>

        <!-- Content -->
        <div class="px-6 py-6">
            <!-- Statistics Cards -->
            <div class="grid grid-cols-2 gap-4 mb-6">
                <div class="stat-card">
                    <div class="text-2xl font-bold">{{total_penerima}}</div>
                    <div class="text-sm opacity-90">Total Penerima</div>
                </div>
                
                <div class="stat-card">
                    <div class="text-2xl font-bold">{{total_program}}</div>
                    <div class="text-sm opacity-90">Program Aktif</div>
                </div>
                
                <div class="stat-card">
                    <div class="text-2xl font-bold">{{bantuan_aktif}}</div>
                    <div class="text-sm opacity-90">Bantuan Aktif</div>
                </div>
                
                <div class="stat-card">
                    <div class="text-2xl font-bold">{{nilai_total}}</div>
                    <div class="text-sm opacity-90">Total Nilai</div>
                </div>
            </div>

            <!-- Info Card -->
            <div class="mobile-card mb-6 bg-yellow-50 border-yellow-200">
                <h3 class="font-semibold text-gray-800 mb-3 flex items-center">
                    <svg class="w-5 h-5 text-yellow-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"/>
                    </svg>
                    Informasi Bantuan
                </h3>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li>• Informasi bantuan diperbarui setiap bulan</li>
                    <li>• Penerima bantuan dipilih berdasarkan kriteria</li>
                    <li>• Untuk pengajuan bantuan hubungi kantor desa</li>
                    <li>• Bantuan disalurkan sesuai jadwal yang ditentukan</li>
                </ul>
            </div>

            <!-- Program Bantuan -->
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-yellow-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M3 4a1 1 0 011-1h12a1 1 0 011 1v2a1 1 0 01-1 1H4a1 1 0 01-1-1V4zM3 10a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H4a1 1 0 01-1-1v-6zM14 9a1 1 0 00-1 1v6a1 1 0 001 1h2a1 1 0 001-1v-6a1 1 0 00-1-1h-2z"/>
                    </svg>
                    Program Bantuan
                </h3>

                <div class="space-y-4">
                    <!-- Bantuan Sembako -->
                    <div class="mobile-card program-card">
                        <div class="flex justify-between items-start mb-2">
                            <h4 class="font-semibold text-gray-800">Bantuan Sembako</h4>
                            <span class="bg-green-100 text-green-800 text-xs px-2 py-1 rounded-full">Aktif</span>
                        </div>
                        <p class="text-sm text-gray-600 mb-3">Bantuan bahan pokok untuk keluarga kurang mampu</p>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500">Periode: Bulanan</span>
                            <span class="font-semibold text-yellow-600">Rp 300.000</span>
                        </div>
                    </div>

                    <!-- BLT Dana Desa -->
                    <div class="mobile-card program-card">
                        <div class="flex justify-between items-start mb-2">
                            <h4 class="font-semibold text-gray-800">BLT Dana Desa</h4>
                            <span class="bg-green-100 text-green-800 text-xs px-2 py-1 rounded-full">Aktif</span>
                        </div>
                        <p class="text-sm text-gray-600 mb-3">Bantuan Langsung Tunai untuk masyarakat terdampak</p>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500">Periode: 3 Bulan</span>
                            <span class="font-semibold text-yellow-600">Rp 600.000</span>
                        </div>
                    </div>

                    <!-- Bantuan Pendidikan -->
                    <div class="mobile-card program-card">
                        <div class="flex justify-between items-start mb-2">
                            <h4 class="font-semibold text-gray-800">Bantuan Pendidikan</h4>
                            <span class="bg-blue-100 text-blue-800 text-xs px-2 py-1 rounded-full">Seasonal</span>
                        </div>
                        <p class="text-sm text-gray-600 mb-3">Bantuan untuk biaya sekolah anak kurang mampu</p>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500">Periode: Per Semester</span>
                            <span class="font-semibold text-yellow-600">Rp 500.000</span>
                        </div>
                    </div>

                    <!-- Program Lansia -->
                    <div class="mobile-card program-card">
                        <div class="flex justify-between items-start mb-2">
                            <h4 class="font-semibold text-gray-800">Bantuan Lansia</h4>
                            <span class="bg-green-100 text-green-800 text-xs px-2 py-1 rounded-full">Aktif</span>
                        </div>
                        <p class="text-sm text-gray-600 mb-3">Bantuan untuk warga lanjut usia</p>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500">Periode: Bulanan</span>
                            <span class="font-semibold text-yellow-600">Rp 200.000</span>
                        </div>
                    </div>

                    <!-- Bantuan Kesehatan -->
                    <div class="mobile-card program-card">
                        <div class="flex justify-between items-start mb-2">
                            <h4 class="font-semibold text-gray-800">Bantuan Kesehatan</h4>
                            <span class="bg-green-100 text-green-800 text-xs px-2 py-1 rounded-full">Aktif</span>
                        </div>
                        <p class="text-sm text-gray-600 mb-3">Bantuan biaya pengobatan untuk keluarga kurang mampu</p>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-500">Periode: Sesuai kebutuhan</span>
                            <span class="font-semibold text-yellow-600">Rp 1.000.000</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Info -->
            <div class="mobile-card bg-gray-50">
                <h3 class="font-semibold text-gray-800 mb-3 flex items-center">
                    <svg class="w-5 h-5 text-gray-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                    </svg>
                    Informasi Kontak
                </h3>
                <div class="space-y-2 text-sm text-gray-600">
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z"/>
                        </svg>
                        Kantor Desa - Jl. Desa No. 1
                    </div>
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                        </svg>
                        (021) 123-4567
                    </div>
                    <div class="flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                            <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
                        </svg>
                        bantuan@desa.go.id
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-200 px-6 py-4 z-50 shadow-lg">
            <div class="flex justify-around">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"/>
                    </svg>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M2 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 002 2H4a2 2 0 01-2-2V5zm3 1h6v4H5V6zm6 6H5v2h6v-2z"/>
                        <path d="M15 7h1a2 2 0 012 2v5.5a1.5 1.5 0 01-3 0V7z"/>
                    </svg>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"/>
                    </svg>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"/>
                    </svg>
                    <span class="text-xs">Umkm</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 011 1v12a1 1 0 11-2 0V4a1 1 0 011-1zm7.707 3.293a1 1 0 010 1.414L9.414 9H17a1 1 0 110 2H9.414l1.293 1.293a1 1 0 01-1.414 1.414l-3-3a1 1 0 010-1.414l3-3a1 1 0 011.414 0z"/>
                    </svg>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <!-- JavaScript -->
    <script>
        function goBack() {
            window.history.back();
        }

        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }
    </script>
</body>
</html> 
