<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PPOB - Pembayaran Online</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .mobile-card {
            background: white;
            border-radius: 12px;
            padding: 12px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
            border: 1px solid #f1f5f9;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .product-card {
            transition: all 0.3s ease;
        }
        
        .product-card:hover {
            transform: translateY(-1px);
            box-shadow: 0 3px 8px rgba(0,0,0,0.12);
        }
        
        .animate-pulse-slow {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        
        /* FontAwesome fallback with !important for navigation */
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        
        /* PPOB specific icons */
        .fas.fa-wallet:before, .fa.fa-wallet:before { content: "💰" !important; font-family: system-ui !important; }
        .fas.fa-mobile-alt:before, .fa.fa-mobile-alt:before { content: "📱" !important; font-family: system-ui !important; }
        .fas.fa-wifi:before, .fa.fa-wifi:before { content: "📶" !important; font-family: system-ui !important; }
        .fas.fa-bolt:before, .fa.fa-bolt:before { content: "⚡" !important; font-family: system-ui !important; }
        .fas.fa-heartbeat:before, .fa.fa-heartbeat:before { content: "❤️" !important; font-family: system-ui !important; }
        .fas.fa-tv:before, .fa.fa-tv:before { content: "📺" !important; font-family: system-ui !important; }
        .fas.fa-globe:before, .fa.fa-globe:before { content: "🌐" !important; font-family: system-ui !important; }
        .fas.fa-credit-card:before, .fa.fa-credit-card:before { content: "💳" !important; font-family: system-ui !important; }
        .fas.fa-history:before, .fa.fa-history:before { content: "🕒" !important; font-family: system-ui !important; }
        .fas.fa-info-circle:before, .fa.fa-info-circle:before { content: "ℹ️" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Mobile Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen">
        
        <!-- Header -->
        <div class="gradient-bg text-white p-4 pb-6">
            <div class="relative z-10">
                <!-- Back Button -->
                <div class="flex items-center mb-4">
                    <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center mr-4">
                        <span class="text-white text-lg">⬅️</span>
                    </button>
                    <div>
                        <h1 class="text-lg font-bold text-white">PPOB</h1>
                        <p class="text-white/80 text-xs">Pembayaran Online Terpadu</p>
                    </div>
                </div>

                <!-- Status Online -->
                <div class="flex items-center justify-center space-x-2 mb-3">
                    <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse-slow"></div>
                    <span class="text-white/90 text-xs font-medium">Layanan Online 24/7</span>
                </div>
            </div>
        </div>

        <!-- Balance Card -->
        <div class="px-4 -mt-4 relative z-20 mb-4">
            <div class="mobile-card bg-gradient-to-r from-blue-500 to-purple-600 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-white/80 text-xs">Saldo PPOB</p>
                        <p class="text-xl font-bold">Rp 0</p>
                        <p class="text-white/80 text-xs">*Saldo akan terisi otomatis saat transaksi</p>
                    </div>
                    <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
                        <i class="fas fa-wallet text-white text-lg"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Products Grid -->
        <div class="px-4 mb-4">
            <h3 class="text-base font-semibold text-gray-800 mb-3">Pilih Layanan</h3>
            
            <div class="grid grid-cols-2 gap-3">
                
                <!-- Pulsa -->
                <button onclick="navigateToProduct('pulsa')" class="product-card mobile-card text-center p-3 hover:bg-blue-50 border border-blue-200">
                    <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-mobile-alt text-blue-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">Pulsa</h4>
                    <p class="text-gray-500 text-xs mt-1">Isi pulsa semua operator</p>
                </button>

                <!-- Paket Data -->
                <button onclick="navigateToProduct('paket_data')" class="product-card mobile-card text-center p-3 hover:bg-green-50 border border-green-200">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-wifi text-green-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">Paket Data</h4>
                    <p class="text-gray-500 text-xs mt-1">Kuota internet murah</p>
                </button>

                <!-- PLN -->
                <button onclick="navigateToProduct('pln')" class="product-card mobile-card text-center p-3 hover:bg-yellow-50 border border-yellow-200">
                    <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-bolt text-yellow-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">PLN</h4>
                    <p class="text-gray-500 text-xs mt-1">Token & tagihan listrik</p>
                </button>

                <!-- PBB -->
                <button onclick="navigateToProduct('pbb')" class="product-card mobile-card text-center p-3 hover:bg-cyan-50 border border-cyan-200">
                    <div class="w-10 h-10 bg-cyan-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-home text-cyan-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">PBB</h4>
                    <p class="text-gray-500 text-xs mt-1">Pajak Bumi dan Bangunan</p>
                </button>

                <!-- BPJS -->
                <button onclick="navigateToProduct('bpjs')" class="product-card mobile-card text-center p-3 hover:bg-red-50 border border-red-200">
                    <div class="w-10 h-10 bg-red-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-heartbeat text-red-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">BPJS</h4>
                    <p class="text-gray-500 text-xs mt-1">Kesehatan & ketenagakerjaan</p>
                </button>

                <!-- TV Kabel -->
                <button onclick="navigateToProduct('tv_kabel')" class="product-card mobile-card text-center p-3 hover:bg-purple-50 border border-purple-200">
                    <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-tv text-purple-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">TV Kabel</h4>
                    <p class="text-gray-500 text-xs mt-1">IndiHome, Biznet, dll</p>
                </button>

                <!-- Internet -->
                <button onclick="navigateToProduct('internet')" class="product-card mobile-card text-center p-3 hover:bg-indigo-50 border border-indigo-200">
                    <div class="w-10 h-10 bg-indigo-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-globe text-indigo-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">Internet</h4>
                    <p class="text-gray-500 text-xs mt-1">WiFi & internet rumah</p>
                </button>

                <!-- Multifinance -->
                <button onclick="navigateToProduct('finance')" class="product-card mobile-card text-center p-3 hover:bg-orange-50 border border-orange-200">
                    <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                        <i class="fas fa-credit-card text-orange-600 text-lg"></i>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-xs">Multifinance</h4>
                    <p class="text-gray-500 text-xs mt-1">Cicilan motor & mobil</p>
                </button>

            </div>
        </div>

        <!-- Recent Transactions -->
        <div class="px-4 mb-4">
            <div class="flex items-center justify-between mb-2">
                <h3 class="text-base font-semibold text-gray-800">Transaksi Terakhir</h3>
                <button onclick="navigateToHistory()" class="text-blue-600 text-xs font-medium">Lihat Semua</button>
            </div>
            
            <div id="recentTransactions" class="space-y-2">
                <!-- Transactions will be loaded here -->
                <div class="mobile-card text-center py-4">
                    <i class="fas fa-history text-gray-400 text-lg mb-2"></i>
                    <p class="text-gray-500 text-xs">Belum ada transaksi</p>
                    <p class="text-gray-400 text-xs">Mulai transaksi pertama Anda</p>
                </div>
            </div>
        </div>

        <!-- Info Banner -->
        <div class="px-4 mb-4">
            <div class="mobile-card bg-gradient-to-r from-green-50 to-blue-50 border border-green-200">
                <div class="flex items-start space-x-2">
                    <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-info-circle text-green-600 text-sm"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-semibold text-gray-800 text-xs mb-1">Keunggulan PPOB Kami</h4>
                        <div class="space-y-0.5 text-xs text-gray-600">
                            <p>• <strong>Aman:</strong> Transaksi dijamin aman dengan enkripsi SSL</p>
                            <p>• <strong>Cepat:</strong> Proses otomatis dalam hitungan detik</p>
                            <p>• <strong>Murah:</strong> Biaya admin kompetitif</p>
                            <p>• <strong>24/7:</strong> Layanan tersedia kapan saja</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-3 py-2 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-1.5 rounded-lg hover:bg-blue-50">
                        <i class="fas fa-home text-base"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-1.5 rounded-lg hover:bg-blue-50">
                        <i class="fas fa-newspaper text-base"></i>
                    </div>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-1.5 rounded-lg hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-base"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-1.5 rounded-lg hover:bg-blue-50">
                        <i class="fas fa-store text-base"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-1.5 rounded-lg hover:bg-blue-50">
                        <i class="fas fa-user-shield text-base"></i>
                    </div>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>
        
        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <!-- JavaScript -->
    <script>
        function navigateToProduct(type) {
            window.location.href = `/ppob/product/${type}`;
        }

        function navigateToHistory() {
            window.location.href = '/ppob/history';
        }

        function navigateToService(service) {
            if (service === '/') {
                window.location.href = '/';
            } else {
                window.location.href = `/${service}`;
            }
        }

        // Load recent transactions
        function loadRecentTransactions() {
            // This would be loaded from the backend
            // For now, we'll show empty state
            console.log('Loading recent transactions...');
        }

        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            loadRecentTransactions();
        });
    </script>
</body>
</html>
