<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// Register enhanced village system commands
Artisan::command('village:setup-enhanced', function () {
    $this->call('App\Console\Commands\SetupEnhancedVillageSystem');
})->purpose('Setup enhanced village management system');

Artisan::command('make:superadmin {email?} {password?} {name?}', function () {
    $this->call('App\Console\Commands\CreateSuperAdmin');
})->purpose('Create a superadmin user account');
