

<?php $__env->startSection('title', 'Wilayah Administratif'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item active">Wilayah Administratif</li>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Prevent modal backdrop issues */
.modal-backdrop {
    display: none !important;
}
body.modal-open {
    overflow: auto !important;
    padding-right: 0 !important;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total Dusun</h6>
                            <h4><?php echo e($stats['total_dusun'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-map-marked-alt fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total RW</h6>
                            <h4><?php echo e($stats['total_rw'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-home fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total RT</h6>
                            <h4><?php echo e($stats['total_rt'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-building fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total KK</h6>
                            <h4><?php echo e($stats['total_kk'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-users fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-map-marked-alt text-primary me-2"></i>
                        Wilayah Administratif Desa
                    </h4>
                    <div class="btn-group">
                        <a href="<?php echo e(route('admin.wilayah-administratif.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>
                            Tambah Wilayah
                        </a>
                        <button class="btn btn-success" onclick="syncPopulation()">
                            <i class="fas fa-sync me-1"></i>
                            Sinkron Data
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="wilayahTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode</th>
                                    <th>Nama Wilayah</th>
                                    <th>Tipe</th>
                                    <th>Induk Wilayah</th>
                                    <th>Ketua</th>
                                    <th>Jumlah KK</th>
                                    <th>Jumlah Jiwa</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $wilayah ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><code><?php echo e($item->kode_wilayah); ?></code></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?php if($item->jenis_wilayah == 'rt'): ?>
                                                <span class="me-2">└─</span>
                                            <?php elseif($item->jenis_wilayah == 'rw'): ?>
                                                <span class="me-2">├─</span>
                                            <?php endif; ?>
                                            <strong><?php echo e($item->nama_wilayah); ?></strong>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($item->jenis_wilayah == 'dusun' ? 'primary' : ($item->jenis_wilayah == 'rw' ? 'success' : 'warning')); ?>">
                                            <?php echo e(strtoupper($item->jenis_wilayah)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($item->parent->nama_wilayah ?? '-'); ?></td>
                                    <td><?php echo e($item->kepala_wilayah ?? '-'); ?></td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($item->jumlah_kk ?? 0); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo e($item->jumlah_penduduk ?? 0); ?></span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-info" onclick="showDetail(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button class="btn btn-sm btn-warning" onclick="editWilayah(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-success" onclick="updateStats(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-calculator"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deleteWilayah(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Belum ada data wilayah administratif</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Clean up any lingering modal states on page load
document.addEventListener('DOMContentLoaded', function() {
    // Remove any modal backdrops
    const backdrops = document.querySelectorAll('.modal-backdrop');
    backdrops.forEach(backdrop => backdrop.remove());
    
    // Remove modal-open class from body
    document.body.classList.remove('modal-open');
    
    // Reset body styles
    document.body.style.overflow = '';
    document.body.style.paddingRight = '';
});

// Sync population data
function syncPopulation() {
    if (confirm('Apakah Anda yakin ingin menyinkronkan data penduduk dengan wilayah administratif?')) {
        fetch('<?php echo e(route("admin.wilayah-administratif.sync")); ?>', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Berhasil!', data.message, 'success');
                location.reload();
            } else {
                Swal.fire('Error!', data.message, 'error');
            }
        })
        .catch(error => {
            Swal.fire('Error!', 'Terjadi kesalahan saat sinkronisasi', 'error');
        });
    }
}

// Update statistics for specific wilayah
function updateStats(id) {
    if (confirm('Update statistik penduduk untuk wilayah ini?')) {
        fetch(`/admin/wilayah-administratif/${id}/update-statistik`, {
            method: 'PUT',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Berhasil!', data.message, 'success');
                location.reload();
            } else {
                Swal.fire('Error!', data.message, 'error');
            }
        })
        .catch(error => {
            Swal.fire('Error!', 'Terjadi kesalahan saat update statistik', 'error');
        });
    }
}

// Edit wilayah
function editWilayah(id) {
    window.location.href = `/admin/wilayah-administratif/${id}/edit`;
}

// Delete wilayah
function deleteWilayah(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data wilayah akan dihapus permanen!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/admin/wilayah-administratif/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('Terhapus!', data.message, 'success');
                    location.reload();
                } else {
                    Swal.fire('Error!', data.message, 'error');
                }
            })
            .catch(error => {
                Swal.fire('Error!', 'Terjadi kesalahan saat menghapus data', 'error');
            });
        }
    });
}

// Show detail
function showDetail(id) {
    fetch(`/admin/wilayah-administratif/${id}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const wilayah = data.data;
                Swal.fire({
                    title: `Detail ${wilayah.jenis_wilayah.toUpperCase()} ${wilayah.nama_wilayah}`,
                    html: `
                        <div class="text-start">
                            <table class="table table-sm">
                                <tr><td><strong>Kode:</strong></td><td>${wilayah.kode_wilayah}</td></tr>
                                <tr><td><strong>Jenis:</strong></td><td>${wilayah.jenis_wilayah.toUpperCase()}</td></tr>
                                <tr><td><strong>Kepala:</strong></td><td>${wilayah.kepala_wilayah || '-'}</td></tr>
                                <tr><td><strong>No. HP:</strong></td><td>${wilayah.nomor_hp_kepala || '-'}</td></tr>
                                <tr><td><strong>Jumlah KK:</strong></td><td>${wilayah.jumlah_kk || 0}</td></tr>
                                <tr><td><strong>Jumlah Penduduk:</strong></td><td>${wilayah.jumlah_penduduk || 0}</td></tr>
                                <tr><td><strong>Luas:</strong></td><td>${wilayah.luas_wilayah || 0} Ha</td></tr>
                                <tr><td><strong>Status:</strong></td><td><span class="badge bg-${wilayah.status == 'aktif' ? 'success' : 'secondary'}">${wilayah.status}</span></td></tr>
                            </table>
                        </div>
                    `,
                    width: 600,
                    showCloseButton: true
                });
            }
        })
        .catch(error => {
            Swal.fire('Error!', 'Tidak dapat memuat detail wilayah', 'error');
        });
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/wilayah-administratif/index.blade.php ENDPATH**/ ?>