

<?php $__env->startSection('title', 'Edit Berita'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.berita.index')); ?>">Berita</a></li>
    <li class="breadcrumb-item active">Edit Berita</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-edit me-2 text-primary"></i>
            Edit Berita
        </h2>
        <p class="text-muted mb-0">Perbarui konten berita yang sudah ada</p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.berita.index')); ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali
        </a>
        <?php if($berita->status === 'Terbit'): ?>
        <a href="<?php echo e(route('public.berita.show', $berita->slug)); ?>" target="_blank" class="btn btn-outline-info me-2">
            <i class="fas fa-external-link-alt me-2"></i>
            Lihat Live
        </a>
        <?php endif; ?>
        <button type="button" class="btn btn-outline-warning" onclick="previewBerita()">
            <i class="fas fa-eye me-2"></i>
            Preview
        </button>
    </div>
</div>

<!-- Status Alert -->
<?php if($berita->status === 'Terbit'): ?>
<div class="alert alert-success d-flex align-items-center mb-4">
    <i class="fas fa-check-circle me-2"></i>
    <div>
        <strong>Berita Terpublikasi</strong><br>
        Berita ini sudah dipublikasikan pada <?php echo e($berita->created_at->format('d F Y, H:i')); ?> WIB
    </div>
</div>
<?php elseif($berita->status === 'Draft'): ?>
<div class="alert alert-warning d-flex align-items-center mb-4">
    <i class="fas fa-edit me-2"></i>
    <div>
        <strong>Draft</strong><br>
        Berita ini masih dalam status draft dan belum dipublikasikan
    </div>
</div>
<?php endif; ?>

<form id="editBeritaForm" action="<?php echo e(route('admin.berita.update', $berita->id)); ?>" method="POST" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-edit me-2"></i>
                        Konten Berita
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Judul -->
                    <div class="mb-4">
                        <label class="form-label required">Judul Berita</label>
                        <input type="text" class="form-control form-control-lg" name="judul" 
                               value="<?php echo e($berita->judul); ?>"
                               placeholder="Masukkan judul berita yang menarik..." required
                               onkeyup="updateSlug(this.value)">
                        <div class="form-text">
                            <span id="judulCount"><?php echo e(strlen($berita->judul)); ?></span>/100 karakter
                        </div>
                    </div>
                    
                    <!-- Slug -->
                    <div class="mb-4">
                        <label class="form-label">URL Slug</label>
                        <div class="input-group">
                            <span class="input-group-text"><?php echo e(url('/berita/')); ?>/</span>
                            <input type="text" class="form-control" name="slug" id="slugInput" 
                                   value="<?php echo e($berita->slug); ?>"
                                   placeholder="url-berita-otomatis">
                        </div>
                        <div class="form-text">URL akan dibuat otomatis dari judul</div>
                    </div>
                    
                    <!-- Ringkasan -->
                    <div class="mb-4">
                        <label class="form-label required">Ringkasan</label>
                        <textarea class="form-control" name="ringkasan" rows="3" required
                                  placeholder="Tulis ringkasan singkat berita (maks. 200 karakter)..."
                                  maxlength="200" onkeyup="updateRingkasanCount(this.value)"><?php echo e($berita->ringkasan); ?></textarea>
                        <div class="form-text">
                            <span id="ringkasanCount"><?php echo e(strlen($berita->ringkasan ?? '')); ?></span>/200 karakter
                        </div>
                    </div>
                    
                    <!-- Konten -->
                    <div class="mb-4">
                        <label class="form-label required">Konten Berita</label>
                        <div id="editor"><?php echo $berita->konten; ?></div>
                        <textarea name="konten" id="kontenHidden" style="display: none;" required><?php echo e($berita->konten); ?></textarea>
                    </div>
                    
                    <!-- Tags -->
                    <div class="mb-4">
                        <label class="form-label">Tags</label>
                        <input type="text" class="form-control" name="tags" 
                               value="<?php echo e($berita->tags); ?>"
                               placeholder="Contoh: kesehatan, lingkungan, pembangunan"
                               data-bs-toggle="tooltip" 
                               title="Pisahkan dengan koma untuk multiple tags">
                        <div class="form-text">Tags membantu dalam pencarian dan kategorisasi</div>
                    </div>
                </div>
            </div>
            
            <!-- SEO Settings -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-search me-2"></i>
                        Pengaturan SEO
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Meta Description</label>
                        <textarea class="form-control" name="meta_description" rows="2" 
                                  maxlength="160" placeholder="Deskripsi untuk search engine..."
                                  onkeyup="updateMetaCount(this.value)"><?php echo e($berita->meta_description); ?></textarea>
                        <div class="form-text">
                            <span id="metaCount"><?php echo e(strlen($berita->meta_description ?? '')); ?></span>/160 karakter (optimal: 150-160)
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Keywords</label>
                        <input type="text" class="form-control" name="keywords" 
                               value="<?php echo e($berita->keywords); ?>"
                               placeholder="kata kunci, berita desa, informasi">
                        <div class="form-text">Kata kunci untuk SEO (opsional)</div>
                    </div>
                </div>
            </div>
            
            <!-- Revision History -->
            <?php if(isset($berita->revisions) && $berita->revisions->count() > 0): ?>
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-history me-2"></i>
                        Riwayat Perubahan
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <?php $__currentLoopData = $berita->revisions->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revision): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="timeline-item">
                            <div class="timeline-marker bg-info"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Revisi <?php echo e($loop->iteration); ?></h6>
                                <p class="mb-1 text-muted"><?php echo e($revision->created_at->format('d F Y, H:i')); ?> WIB</p>
                                <small class="text-muted"><?php echo e($revision->user->name ?? 'System'); ?></small>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Publish Settings -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-cog me-2"></i>
                        Pengaturan Publikasi
                    </h6>
                </div>
                <div class="card-body">
                    <!-- Status -->
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status">
                            <option value="Draft" <?php echo e($berita->status === 'Draft' ? 'selected' : ''); ?>>Draft</option>
                            <option value="Terbit" <?php echo e($berita->status === 'Terbit' ? 'selected' : ''); ?>>Terbitkan</option>
                            <option value="scheduled" <?php echo e($berita->status === 'scheduled' ? 'selected' : ''); ?>>Jadwalkan</option>
                            <option value="archived" <?php echo e($berita->status === 'archived' ? 'selected' : ''); ?>>Arsipkan</option>
                        </select>
                    </div>
                    
                    <!-- Tanggal Publish -->
                    <div class="mb-3" id="publishDateSection" style="<?php echo e($berita->status === 'scheduled' ? '' : 'display: none;'); ?>">
                        <label class="form-label">Tanggal Terbit</label>
                        <input type="datetime-local" class="form-control" name="tanggal_publish" 
                               value="<?php echo e($berita->tanggal_publish ? $berita->tanggal_publish->format('Y-m-d\TH:i') : ''); ?>">
                    </div>
                    
                    <!-- Kategori -->
                    <div class="mb-3">
                        <label class="form-label required">Kategori</label>
                        <select class="form-select" name="kategori" required>
                            <option value="">Pilih Kategori</option>
                            <option value="Pengumuman" <?php echo e($berita->kategori === 'Pengumuman' ? 'selected' : ''); ?>>Pengumuman</option>
                            <option value="Kegiatan" <?php echo e($berita->kategori === 'Kegiatan' ? 'selected' : ''); ?>>Kegiatan Desa</option>
                            <option value="Pembangunan" <?php echo e($berita->kategori === 'Pembangunan' ? 'selected' : ''); ?>>Pembangunan</option>
                            <option value="Kesehatan" <?php echo e($berita->kategori === 'Kesehatan' ? 'selected' : ''); ?>>Kesehatan</option>
                            <option value="Pendidikan" <?php echo e($berita->kategori === 'Pendidikan' ? 'selected' : ''); ?>>Pendidikan</option>
                            <option value="UMKM" <?php echo e($berita->kategori === 'UMKM' ? 'selected' : ''); ?>>UMKM</option>
                            <option value="Sosial" <?php echo e($berita->kategori === 'Sosial' ? 'selected' : ''); ?>>Sosial</option>
                            <option value="Keamanan" <?php echo e($berita->kategori === 'Keamanan' ? 'selected' : ''); ?>>Keamanan</option>
                            <option value="Lainnya" <?php echo e($berita->kategori === 'Lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                        </select>
                    </div>
                    
                    <!-- Prioritas -->
                    <div class="mb-3">
                        <label class="form-label">Prioritas</label>
                        <select class="form-select" name="prioritas">
                            <option value="normal" <?php echo e($berita->prioritas === 'normal' ? 'selected' : ''); ?>>Normal</option>
                            <option value="penting" <?php echo e($berita->prioritas === 'penting' ? 'selected' : ''); ?>>Penting</option>
                            <option value="mendesak" <?php echo e($berita->prioritas === 'mendesak' ? 'selected' : ''); ?>>Mendesak</option>
                        </select>
                    </div>
                    
                    <!-- Penulis -->
                    <div class="mb-3">
                        <label class="form-label">Penulis</label>
                        <input type="text" class="form-control" name="penulis" 
                               value="<?php echo e($berita->user->name ?? 'Admin Desa'); ?>" readonly>
                        <div class="form-text">Penulis tidak dapat diubah</div>
                    </div>
                    
                    <!-- Statistics -->
                    <?php if($berita->status === 'Terbit'): ?>
                    <div class="mb-3">
                        <label class="form-label">Statistik</label>
                        <div class="stats-summary p-3 bg-light rounded">
                            <div class="row text-center">
                                <div class="col-4">
                                    <div class="fw-bold"><?php echo e($berita->views ?? 0); ?></div>
                                    <small class="text-muted">Views</small>
                                </div>
                                <div class="col-4">
                                    <div class="fw-bold"><?php echo e($berita->likes ?? 0); ?></div>
                                    <small class="text-muted">Likes</small>
                                </div>
                                <div class="col-4">
                                    <div class="fw-bold"><?php echo e($berita->shares ?? 0); ?></div>
                                    <small class="text-muted">Shares</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Additional Settings -->
                    <div class="mb-3">
                        <label class="form-label">Pengaturan Tambahan</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="allow_comments" value="1" 
                                   <?php echo e($berita->allow_comments ? 'checked' : ''); ?>>
                            <label class="form-check-label">
                                Izinkan komentar
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_featured" value="1"
                                   <?php echo e($berita->is_featured ? 'checked' : ''); ?>>
                            <label class="form-check-label">
                                Berita unggulan
                            </label>
                        </div>
                    </div>

                    <!-- WhatsApp Broadcast -->
                    <div class="card mt-3 border-warning">
                        <div class="card-body">
                            <h6 class="text-warning">
                                <i class="fab fa-whatsapp me-2"></i>
                                WhatsApp Broadcast
                            </h6>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="broadcast_wa" value="1">
                                <label class="form-check-label">
                                    Kirim ulang notifikasi ke WhatsApp
                                </label>
                            </div>
                            <div class="form-text">
                                Hanya centang jika ingin mengirim notifikasi ulang
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Featured Image -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-image me-2"></i>
                        Gambar Utama
                    </h6>
                </div>
                <div class="card-body">
                    <div class="image-upload-area <?php echo e($berita->gambar ? 'has-image' : ''); ?>" onclick="document.getElementById('imageInput').click()">
                        <input type="file" id="imageInput" name="gambar" accept="image/*" 
                               style="display: none;" onchange="previewImage(this)">
                        <div id="imagePreview" class="text-center py-4">
                            <?php if($berita->gambar): ?>
                                <img src="<?php echo e(asset('storage/' . $berita->gambar)); ?>" class="image-preview" alt="Current Image">
                            <?php else: ?>
                                <i class="fas fa-cloud-upload-alt fa-2x text-muted mb-2"></i>
                                <p class="text-muted mb-0">Klik untuk upload gambar</p>
                                <small class="text-muted">JPG, PNG, maksimal 2MB</small>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mt-3" id="imageActions" style="<?php echo e($berita->gambar ? '' : 'display: none;'); ?>">
                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeImage()">
                            <i class="fas fa-trash me-1"></i>Hapus
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-info" onclick="document.getElementById('imageInput').click()">
                            <i class="fas fa-edit me-1"></i>Ganti
                        </button>
                    </div>
                    
                    <div class="mt-3">
                        <label class="form-label">Alt Text</label>
                        <input type="text" class="form-control form-control-sm" name="alt_text" 
                               value="<?php echo e($berita->alt_text); ?>"
                               placeholder="Deskripsi gambar untuk accessibility">
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div class="card mt-4">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success" name="action" value="update_publish">
                            <i class="fas fa-paper-plane me-2"></i>
                            Update & Terbitkan
                        </button>
                        <button type="submit" class="btn btn-primary" name="action" value="update_draft">
                            <i class="fas fa-save me-2"></i>
                            Simpan Perubahan
                        </button>
                        <?php if($berita->status === 'Terbit'): ?>
                        <button type="button" class="btn btn-outline-warning" onclick="duplicateBerita()">
                            <i class="fas fa-copy me-2"></i>
                            Duplikat Berita
                        </button>
                        <?php endif; ?>
                        <a href="<?php echo e(route('admin.berita.index')); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-2"></i>
                            Batal
                        </a>
                    </div>
                    
                    <?php if($berita->status === 'Draft'): ?>
                    <div class="form-check mt-3">
                        <input class="form-check-input" type="checkbox" id="autoSave" checked>
                        <label class="form-check-label" for="autoSave">
                            Auto-save draft setiap 30 detik
                        </label>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Delete Section -->
            <?php if($berita->status === 'Draft'): ?>
            <div class="card mt-4 border-danger">
                <div class="card-body">
                    <h6 class="text-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Zona Bahaya
                    </h6>
                    <p class="text-muted mb-3">Hapus berita ini secara permanen.</p>
                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteBerita()">
                        <i class="fas fa-trash me-2"></i>
                        Hapus Berita
                    </button>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</form>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-eye me-2"></i>
                    Preview Berita
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="previewContent">
                    <!-- Preview content will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-success" onclick="publishFromPreview()">
                    <i class="fas fa-paper-plane me-2"></i>Update & Terbitkan
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<!-- Quill Editor -->
<link href="https://cdn.quilljs.com/1.3.7/quill.snow.css" rel="stylesheet">

<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .image-upload-area {
        border: 2px dashed #dee2e6;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.3s ease;
        min-height: 150px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .image-upload-area:hover {
        border-color: #007bff;
        background-color: #f8f9fa;
    }
    
    .image-upload-area.has-image {
        border-style: solid;
        border-color: #28a745;
    }
    
    .image-preview {
        max-width: 100%;
        max-height: 200px;
        border-radius: 8px;
    }
    
    #editor {
        border: 1px solid #dee2e6;
        border-radius: 0.375rem;
        min-height: 300px;
    }
    
    .ck-editor__editable {
        min-height: 300px;
    }
    
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 10px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #dee2e6;
    }
    
    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }
    
    .timeline-marker {
        position: absolute;
        left: -25px;
        top: 0;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        border: 3px solid #fff;
    }
    
    .timeline-content {
        padding: 10px 15px;
        background: #f8f9fa;
        border-radius: 8px;
        margin-left: 10px;
    }
    
    .stats-summary {
        border: 1px solid #dee2e6;
    }
    
    .auto-save-indicator {
        position: fixed;
        top: 100px;
        right: 20px;
        z-index: 1050;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/ckeditor-image-styles.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- CKEditor 5 -->
<script src="https://cdn.ckeditor.com/ckeditor5/40.2.0/classic/ckeditor.js"></script>

<script>
let editor;
let autoSaveInterval;
const beritaId = <?php echo e($berita->id); ?>;

document.addEventListener('DOMContentLoaded', function() {
    // Initialize CKEditor
    initCKEditor();
    
    // Initialize tooltips if Bootstrap is available
    if (typeof bootstrap !== 'undefined') {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    }
    
    // Setup auto-save for drafts
    <?php if($berita->status === 'Draft'): ?>
    setupAutoSave();
    <?php endif; ?>
    
    // Monitor status changes
    const statusSelect = document.querySelector('select[name="status"]');
    if (statusSelect) {
        statusSelect.addEventListener('change', function() {
            const publishDateSection = document.getElementById('publishDateSection');
            const publishDateInput = document.querySelector('input[name="tanggal_publish"]');
            
            if (this.value === 'scheduled') {
                if (publishDateSection) publishDateSection.style.display = 'block';
                if (publishDateInput) publishDateInput.required = true;
            } else {
                if (publishDateSection) publishDateSection.style.display = 'none';
                if (publishDateInput) publishDateInput.required = false;
            }
        });
    }
});

// Custom Upload Adapter untuk CKEditor
class UploadAdapter {
    constructor(loader) {
        this.loader = loader;
    }

    upload() {
        return this.loader.file
            .then(file => new Promise((resolve, reject) => {
                this._showUploadStatus('Mengupload gambar...', 'info');
                this._initRequest();
                this._initListeners(resolve, reject, file);
                this._sendRequest(file);
            }));
    }

    abort() {
        if (this.xhr) {
            this.xhr.abort();
        }
    }

    _initRequest() {
        const xhr = this.xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php echo e(route("admin.upload.image")); ?>', true);
        xhr.setRequestHeader('X-CSRF-TOKEN', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
        xhr.setRequestHeader('Accept', 'application/json');
        xhr.responseType = 'json';
    }

    _initListeners(resolve, reject, file) {
        const xhr = this.xhr;
        const loader = this.loader;

        xhr.addEventListener('error', () => {
            console.log('Server upload failed, using Base64 fallback');
            this._showUploadStatus('Server upload gagal, menggunakan Base64...', 'warning');
            this._convertToBase64(file, resolve, reject);
        });

        xhr.addEventListener('abort', () => reject());

        xhr.addEventListener('load', () => {
            const response = xhr.response;

            if (!response || xhr.status !== 200) {
                console.error('Upload failed:', xhr.status, response);
                this._showUploadStatus(`Upload gagal (${xhr.status}). Menggunakan Base64...`, 'warning');
                this._convertToBase64(file, resolve, reject);
                return;
            }

            if (response.error || !response.uploaded) {
                console.error('Server returned error:', response.error);
                this._showUploadStatus('Server error. Menggunakan Base64...', 'warning');
                this._convertToBase64(file, resolve, reject);
                return;
            }

            if (response.url) {
                this._showUploadStatus('Gambar berhasil diupload ke server!', 'success');
                setTimeout(() => this._hideUploadStatus(), 2000);
                resolve({
                    default: response.url
                });
            } else {
                console.error('No URL in response:', response);
                this._showUploadStatus('Response tidak valid, menggunakan Base64...', 'warning');
                this._convertToBase64(file, resolve, reject);
            }
        });

        if (xhr.upload) {
            xhr.upload.addEventListener('progress', evt => {
                if (evt.lengthComputable) {
                    loader.uploadTotal = evt.total;
                    loader.uploaded = evt.loaded;
                }
            });
        }
    }

    _sendRequest(file) {
        const data = new FormData();
        data.append('upload', file);
        this.xhr.send(data);
    }

    _convertToBase64(file, resolve, reject) {
        const reader = new FileReader();
        reader.onload = () => {
            this._showUploadStatus('Gambar disimpan sebagai Base64!', 'success');
            setTimeout(() => this._hideUploadStatus(), 2000);
            resolve({
                default: reader.result
            });
        };
        reader.onerror = () => {
            this._showUploadStatus('Gagal membaca file!', 'danger');
            setTimeout(() => this._hideUploadStatus(), 3000);
            reject('Tidak dapat membaca file.');
        };
        reader.readAsDataURL(file);
    }

    _showUploadStatus(message, type) {
        // Create or update status element
        let statusDiv = document.getElementById('uploadStatusEdit');
        if (!statusDiv) {
            statusDiv = document.createElement('div');
            statusDiv.id = 'uploadStatusEdit';
            statusDiv.style.position = 'fixed';
            statusDiv.style.top = '20px';
            statusDiv.style.right = '20px';
            statusDiv.style.zIndex = '9999';
            statusDiv.style.minWidth = '300px';
            document.body.appendChild(statusDiv);
        }
        
        statusDiv.className = `alert alert-${type} small py-2 mb-2`;
        statusDiv.innerHTML = `<i class="fas fa-info-circle me-1"></i>${message}`;
        statusDiv.style.display = 'block';
    }

    _hideUploadStatus() {
        const statusDiv = document.getElementById('uploadStatusEdit');
        if (statusDiv) {
            statusDiv.style.display = 'none';
        }
    }
}

// Initialize CKEditor
function initCKEditor() {
    const editorElement = document.querySelector('#editor');
    if (!editorElement) {
        console.error('Editor element not found');
        return;
    }

    ClassicEditor
        .create(editorElement, {
            toolbar: {
                items: [
                    'undo', 'redo',
                    '|', 'heading',
                    '|', 'bold', 'italic', 'underline',
                    '|', 'link', 'uploadImage', 'insertImage', 'blockQuote',
                    '|', 'bulletedList', 'numberedList', 'outdent', 'indent',
                    '|', 'insertTable'
                ],
                shouldNotGroupWhenFull: true
            },
            image: {
                toolbar: [
                    'imageTextAlternative', 
                    'imageStyle:inline', 
                    'imageStyle:block', 
                    'imageStyle:side',
                    '|',
                    'resizeImage:25',
                    'resizeImage:50',
                    'resizeImage:75',
                    'resizeImage:original',
                    '|',
                    'resizeImage:300',
                    'resizeImage:500',
                    'resizeImage:800',
                    'resizeImage:1200'
                ],
                resizeOptions: [
                    {
                        name: 'resizeImage:original',
                        label: 'Ukuran Asli',
                        value: null
                    },
                    {
                        name: 'resizeImage:25',
                        label: '25% (Kecil)',
                        value: '25'
                    },
                    {
                        name: 'resizeImage:50',
                        label: '50% (Sedang)',
                        value: '50'
                    },
                    {
                        name: 'resizeImage:75',
                        label: '75% (Besar)',
                        value: '75'
                    },
                    {
                        name: 'resizeImage:300',
                        label: '300px (Thumbnail)',
                        value: '300'
                    },
                    {
                        name: 'resizeImage:500',
                        label: '500px (Medium)',
                        value: '500'
                    },
                    {
                        name: 'resizeImage:800',
                        label: '800px (Large)',
                        value: '800'
                    },
                    {
                        name: 'resizeImage:1200',
                        label: '1200px (Extra Large)',
                        value: '1200'
                    }
                ],
                resizeUnit: 'px',
                styles: [
                    'full',
                    'side',
                    'alignLeft',
                    'alignCenter',
                    'alignRight'
                ]
            },
            table: {
                contentToolbar: ['tableColumn', 'tableRow', 'mergeTableCells']
            },
            heading: {
                options: [
                    { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                    { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                    { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                    { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' }
                ]
            },
            placeholder: 'Edit konten berita di sini...'
        })
        .then(newEditor => {
            editor = newEditor;
            
            // Setup custom upload adapter
            editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {
                return new UploadAdapter(loader);
            };
            
            // Add image resize styles to editor
            const style = document.createElement('style');
            style.innerHTML = `
                .ck-content .image {
                    max-width: 100%;
                    height: auto;
                    position: relative;
                }
                .ck-content .image.image_resized {
                    max-width: none;
                }
                .ck-content .image img {
                    border-radius: 4px;
                    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
                }
                .ck-content .image-style-side {
                    float: right;
                    margin: 0 0 1em 1.5em;
                    max-width: 50%;
                }
                .ck-content .image-style-align-left {
                    float: left;
                    margin: 0 1.5em 1em 0;
                }
                .ck-content .image-style-align-center {
                    margin: 1em auto;
                    display: block;
                    text-align: center;
                }
                .ck-content .image-style-align-right {
                    float: right;
                    margin: 0 0 1em 1.5em;
                }
                .ck-content .image-style-full {
                    width: 100%;
                    margin: 1em 0;
                }
                
                /* Image size indicators */
                .ck-content .image::after {
                    content: attr(data-size);
                    position: absolute;
                    top: 5px;
                    right: 5px;
                    background: rgba(0,0,0,0.7);
                    color: white;
                    padding: 2px 6px;
                    border-radius: 3px;
                    font-size: 11px;
                    font-family: Arial, sans-serif;
                    opacity: 0;
                    transition: opacity 0.3s;
                    pointer-events: none;
                }
                .ck-content .image:hover::after {
                    opacity: 1;
                }
                
                /* Responsive images */
                @media (max-width: 768px) {
                    .ck-content .image-style-side,
                    .ck-content .image-style-align-left,
                    .ck-content .image-style-align-right {
                        float: none;
                        margin: 1em auto;
                        display: block;
                        max-width: 100%;
                    }
                }
            `;
            if (!document.getElementById('ckeditor-image-styles-edit')) {
                style.id = 'ckeditor-image-styles-edit';
                document.head.appendChild(style);
            }
            
            // Add image size tracking
            editor.model.document.on('change:data', () => {
                setTimeout(() => {
                    updateImageSizeIndicators();
                }, 100);
            });
            
            // Update hidden textarea when content changes
            editor.model.document.on('change:data', () => {
                const hiddenTextarea = document.getElementById('kontenHidden');
                if (hiddenTextarea) {
                    hiddenTextarea.value = editor.getData();
                }
            });
            
            console.log('CKEditor initialized successfully');
        })
        .catch(error => {
            console.error('Error initializing CKEditor:', error);
            // Fallback: show the textarea
            const textarea = document.getElementById('kontenHidden');
            if (textarea) {
                textarea.style.display = 'block';
                textarea.style.minHeight = '300px';
            }
        });
}

// Update slug from title
function updateSlug(title) {
    const slug = title.toLowerCase()
        .replace(/[^a-z0-9\s-]/g, '')
        .replace(/\s+/g, '-')
        .replace(/-+/g, '-')
        .trim('-');
    
    document.getElementById('slugInput').value = slug;
    
    // Update character count
    document.getElementById('judulCount').textContent = title.length;
}

// Update ringkasan count
function updateRingkasanCount(text) {
    document.getElementById('ringkasanCount').textContent = text.length;
}

// Update meta description count
function updateMetaCount(text) {
    document.getElementById('metaCount').textContent = text.length;
    
    const countEl = document.getElementById('metaCount');
    if (text.length > 160) {
        countEl.style.color = '#dc3545';
    } else if (text.length > 150) {
        countEl.style.color = '#fd7e14';
    } else {
        countEl.style.color = '#28a745';
    }
}

// Preview image
function previewImage(input) {
    if (input.files && input.files[0]) {
        const file = input.files[0];
        
        // Validate file size (2MB)
        if (file.size > 2 * 1024 * 1024) {
            alert('Ukuran file terlalu besar. Maksimal 2MB.');
            input.value = '';
            return;
        }
        
        const reader = new FileReader();
        reader.onload = function(e) {
            const previewArea = document.getElementById('imagePreview');
            if (previewArea) {
                previewArea.innerHTML = `
                    <img src="${e.target.result}" class="image-preview" alt="Preview">
                `;
            }
            
            const uploadArea = document.querySelector('.image-upload-area');
            if (uploadArea) uploadArea.classList.add('has-image');
            
            const imageActions = document.getElementById('imageActions');
            if (imageActions) imageActions.style.display = 'block';
        };
        reader.readAsDataURL(file);
    }
}

// Remove image
function removeImage() {
    document.getElementById('imageInput').value = '';
    document.getElementById('imagePreview').innerHTML = `
        <i class="fas fa-cloud-upload-alt fa-2x text-muted mb-2"></i>
        <p class="text-muted mb-0">Klik untuk upload gambar</p>
        <small class="text-muted">JPG, PNG, maksimal 2MB</small>
    `;
    
    document.querySelector('.image-upload-area').classList.remove('has-image');
    document.getElementById('imageActions').style.display = 'none';
    
    // Mark image for deletion
    const hiddenInput = document.createElement('input');
    hiddenInput.type = 'hidden';
    hiddenInput.name = 'remove_image';
    hiddenInput.value = '1';
    document.getElementById('editBeritaForm').appendChild(hiddenInput);
}

// Preview berita
function previewBerita() {
    const judulInput = document.querySelector('input[name="judul"]');
    const ringkasanInput = document.querySelector('textarea[name="ringkasan"]');
    const kategoriSelect = document.querySelector('select[name="kategori"]');
    
    const judul = judulInput ? judulInput.value : '';
    const ringkasan = ringkasanInput ? ringkasanInput.value : '';
    const kategori = kategoriSelect ? kategoriSelect.value : '';
    const konten = editor ? editor.getData() : '';
    const penulis = '<?php echo e($berita->user->name ?? "Admin Desa"); ?>';
    
    if (!judul || !ringkasan || !konten.trim()) {
        alert('Harap isi judul, ringkasan, dan konten sebelum preview');
        return;
    }
    
    const previewHtml = `
        <article class="preview-article">
            <div class="mb-4">
                <div class="d-flex align-items-center mb-2">
                    <span class="badge bg-primary me-2">${kategori || 'Umum'}</span>
                    <small class="text-muted">Oleh ${penulis} • <?php echo e($berita->created_at->format('d F Y')); ?></small>
                </div>
                <h1 class="mb-3">${judul}</h1>
                <p class="lead text-muted">${ringkasan}</p>
            </div>
            <div class="content">
                ${konten}
            </div>
        </article>
    `;
    
    const previewContent = document.getElementById('previewContent');
    if (previewContent) {
        previewContent.innerHTML = previewHtml;
    }
    
    // Show modal if Bootstrap is available
    const previewModal = document.getElementById('previewModal');
    if (previewModal && typeof bootstrap !== 'undefined') {
        const modal = new bootstrap.Modal(previewModal);
        modal.show();
    }
}

// Publish from preview
function publishFromPreview() {
    const statusSelect = document.querySelector('select[name="status"]');
    if (statusSelect) statusSelect.value = 'Terbit';
    
    const previewModal = document.getElementById('previewModal');
    if (previewModal && typeof bootstrap !== 'undefined') {
        const modal = bootstrap.Modal.getInstance(previewModal);
        if (modal) modal.hide();
    }
    
    setTimeout(() => {
        const form = document.getElementById('editBeritaForm');
        if (form) form.submit();
    }, 300);
}

// Duplicate berita
function duplicateBerita() {
    if (confirm('Duplikat berita ini sebagai draft baru?')) {
        alert('Fitur duplikat akan segera tersedia');
    }
}

// Delete berita
function deleteBerita() {
    if (confirm('Apakah Anda yakin ingin menghapus berita ini? Tindakan ini tidak dapat dibatalkan.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/berita/${beritaId}`;
        
        const methodInput = document.createElement('input');
        methodInput.type = 'hidden';
        methodInput.name = '_method';
        methodInput.value = 'DELETE';
        
        const tokenInput = document.createElement('input');
        tokenInput.type = 'hidden';
        tokenInput.name = '_token';
        tokenInput.value = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        
        form.appendChild(methodInput);
        form.appendChild(tokenInput);
        document.body.appendChild(form);
        form.submit();
    }
}

// Setup auto-save
function setupAutoSave() {
    const autoSaveCheckbox = document.getElementById('autoSave');
    
    function startAutoSave() {
        if (autoSaveInterval) clearInterval(autoSaveInterval);
        
        autoSaveInterval = setInterval(() => {
            if (autoSaveCheckbox && autoSaveCheckbox.checked) {
                saveDraft();
            }
        }, 30000); // 30 seconds
    }
    
    if (autoSaveCheckbox) {
        autoSaveCheckbox.addEventListener('change', function() {
            if (this.checked) {
                startAutoSave();
            } else {
                if (autoSaveInterval) {
                    clearInterval(autoSaveInterval);
                    autoSaveInterval = null;
                }
            }
        });
        
        // Start auto-save by default
        if (autoSaveCheckbox.checked) {
            startAutoSave();
        }
    }
}

// Save draft (simplified)
function saveDraft() {
    console.log('Auto-save triggered');
    // Auto-save functionality disabled for stability
}

// Handle form submission
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('editBeritaForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            // Update hidden content field before submission
            if (editor) {
                const hiddenTextarea = document.getElementById('kontenHidden');
                if (hiddenTextarea) {
                    hiddenTextarea.value = editor.getData();
                }
            }
            
            // Validate required fields
            const judulInput = document.querySelector('input[name="judul"]');
            const ringkasanInput = document.querySelector('textarea[name="ringkasan"]');
            const kategoriSelect = document.querySelector('select[name="kategori"]');
            
            const judul = judulInput ? judulInput.value : '';
            const ringkasan = ringkasanInput ? ringkasanInput.value : '';
            const kategori = kategoriSelect ? kategoriSelect.value : '';
            const konten = editor ? editor.getData() : '';
            
            if (!judul || !ringkasan || !konten.trim() || !kategori) {
                alert('Harap lengkapi semua field yang wajib diisi');
                e.preventDefault();
                return false;
            }
            
            // Let the form submit normally
            return true;
        });
    }
});

// Update image size indicators
function updateImageSizeIndicators() {
    if (!editor) return;
    
    const editorElement = document.querySelector('.ck-editor__editable');
    if (!editorElement) return;
    
    const images = editorElement.querySelectorAll('img');
    images.forEach(img => {
        const imageContainer = img.closest('.image');
        if (imageContainer) {
            const naturalWidth = img.naturalWidth;
            const naturalHeight = img.naturalHeight;
            const displayWidth = img.offsetWidth;
            const displayHeight = img.offsetHeight;
            
            let sizeText = '';
            if (naturalWidth && naturalHeight && displayWidth && displayHeight) {
                const scale = Math.round((displayWidth / naturalWidth) * 100);
                sizeText = `${displayWidth}×${displayHeight}px (${scale}%)`;
                
                // Add size info to image container
                imageContainer.setAttribute('data-size', sizeText);
                imageContainer.setAttribute('title', `Ukuran: ${sizeText} | Asli: ${naturalWidth}×${naturalHeight}px`);
            }
        }
    });
}

// Image load event listener for edit page
document.addEventListener('DOMContentLoaded', function() {
    // Listen for image loads in CKEditor
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'childList') {
                mutation.addedNodes.forEach(function(node) {
                    if (node.nodeType === Node.ELEMENT_NODE) {
                        const images = node.querySelectorAll ? node.querySelectorAll('img') : [];
                        images.forEach(function(img) {
                            img.addEventListener('load', updateImageSizeIndicators);
                        });
                        
                        if (node.tagName === 'IMG') {
                            node.addEventListener('load', updateImageSizeIndicators);
                        }
                    }
                });
            }
        });
    });
    
    // Start observing
    setTimeout(() => {
        const editorElement = document.querySelector('.ck-editor__editable');
        if (editorElement) {
            observer.observe(editorElement, {
                childList: true,
                subtree: true
            });
        }
    }, 1000);
});

// Cleanup on page unload
window.addEventListener('beforeunload', function() {
    if (autoSaveInterval) {
        clearInterval(autoSaveInterval);
    }
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/admin/berita/edit.blade.php ENDPATH**/ ?>