<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title><?php echo $__env->yieldContent('title', 'Dashboard'); ?> - <?php echo e(config('app.name', 'Aplikasi Desa')); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Leaflet Maps -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
    
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- SweetAlert2 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    
    <!-- Modal Backdrop Fix CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/modal-fix.css')); ?>">
    
    <!-- Custom Styles -->
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --success-gradient: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
            --warning-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --danger-gradient: linear-gradient(135deg, #ff416c 0%, #ff4b2b 100%);
            --info-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --dark-gradient: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            --whatsapp-gradient: linear-gradient(135deg, #25d366 0%, #128c7e 100%);
            --sidebar-width: 280px;
            --sidebar-collapsed-width: 80px;
            --topbar-height: 70px;
            --border-radius: 12px;
            --box-shadow: 0 4px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', system-ui, -apple-system, sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            background-attachment: fixed;
            min-height: 100vh;
            font-size: 14px;
            line-height: 1.6;
            color: #2d3748;
        }

        /* Sidebar Styles */
        .sidebar {
            background: var(--primary-gradient);
            width: var(--sidebar-width);
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            transition: var(--transition);
            box-shadow: var(--box-shadow);
            overflow-x: hidden;
            overflow-y: auto;
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
        }

        .sidebar-collapsed {
            width: var(--sidebar-collapsed-width);
        }

        .sidebar-collapsed .sidebar-text {
            display: none;
        }

        .sidebar-collapsed .navbar-brand span {
            display: none;
        }

        /* Sidebar Header */
        .sidebar-header {
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .navbar-brand {
            color: white !important;
            font-weight: 700;
            font-size: 1.5rem;
            text-decoration: none;
            display: flex;
            align-items: center;
            transition: var(--transition);
        }

        .navbar-brand:hover {
            color: white !important;
            transform: scale(1.05);
        }

        .navbar-brand i {
            font-size: 1.8rem;
            margin-right: 12px;
        }

        /* Navigation */
        .sidebar-nav {
            padding: 20px 0;
        }

        .nav-section {
            margin-bottom: 30px;
        }

        .nav-section-title {
            color: rgba(255, 255, 255, 0.6);
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            padding: 0 20px 10px;
            margin-bottom: 10px;
        }

        .nav-link {
            color: rgba(255, 255, 255, 0.8) !important;
            padding: 14px 20px;
            margin: 4px 12px;
            border-radius: var(--border-radius);
            transition: var(--transition);
            display: flex;
            align-items: center;
            text-decoration: none;
            position: relative;
            overflow: hidden;
        }

        .nav-link:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transition: var(--transition);
        }

        .nav-link:hover {
            background: rgba(255, 255, 255, 0.15);
            color: white !important;
            transform: translateX(8px);
        }

        .nav-link:hover:before {
            left: 100%;
        }

        .nav-link.active {
            background: rgba(255, 255, 255, 0.2);
            color: white !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .nav-link i {
            width: 20px;
            margin-right: 12px;
            font-size: 16px;
            text-align: center;
        }

        /* Submenu Styles */
        .nav-item.has-submenu .nav-link {
            position: relative;
        }

        .nav-item.has-submenu .dropdown-toggle::after {
            content: "\f107";
            font-family: "Font Awesome 5 Free";
            font-weight: 900;
            margin-left: auto;
            transition: transform 0.3s ease;
        }

        .nav-item.has-submenu .dropdown-toggle[aria-expanded="true"]::after {
            transform: rotate(180deg);
        }

        .submenu {
            padding-left: 20px;
            margin-top: 8px;
        }

        .submenu-link {
            padding: 10px 20px !important;
            margin: 2px 0 !important;
            font-size: 13px;
            color: rgba(255, 255, 255, 0.7) !important;
        }

        .submenu-link:hover {
            color: rgba(255, 255, 255, 0.9) !important;
            background: rgba(255, 255, 255, 0.1) !important;
        }

        .submenu-link.active {
            color: white !important;
            background: rgba(255, 255, 255, 0.15) !important;
        }

        .submenu-link i {
            width: 16px;
            font-size: 12px;
        }

        /* Badge Styles */
        .badge {
            padding: 2px 6px;
            border-radius: 10px;
            font-size: 10px;
            font-weight: 600;
            margin-left: auto;
        }

        .badge-new {
            background: linear-gradient(45deg, #ff6b6b, #ee5a52);
            color: white;
            animation: pulse 2s infinite;
        }

        .badge-alert {
            background: linear-gradient(45deg, #ffd93d, #ff6b6b);
            color: white;
        }

        .badge-success {
            background: linear-gradient(45deg, #00d2d3, #54a0ff);
            color: white;
            animation: pulse 2s infinite;
        }

        .badge-warning {
            background: linear-gradient(45deg, #ffa726, #ff7043);
            color: white;
            animation: pulse 2s infinite;
        }

        .badge-primary {
            background: linear-gradient(45deg, #667eea, #764ba2);
            color: white;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        .sidebar-divider {
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            margin: 20px 0;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            transition: var(--transition);
            display: flex;
            flex-direction: column;
        }

        .main-content.expanded {
            margin-left: var(--sidebar-collapsed-width);
        }

        /* Topbar */
        .topbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            height: var(--topbar-height);
            padding: 0 30px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: var(--box-shadow);
            position: sticky;
            top: 0;
            z-index: 999;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        .topbar-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .sidebar-toggle {
            background: none;
            border: none;
            padding: 10px;
            border-radius: 8px;
            color: #64748b;
            transition: var(--transition);
            cursor: pointer;
        }

        .sidebar-toggle:hover {
            background: #f1f5f9;
            color: #334155;
        }

        .breadcrumb {
            background: none;
            padding: 0;
            margin: 0;
            font-size: 14px;
        }

        .breadcrumb-item {
            color: #64748b;
        }

        .breadcrumb-item.active {
            color: #334155;
            font-weight: 500;
        }

        .breadcrumb-item + .breadcrumb-item::before {
            content: "›";
            color: #cbd5e1;
            font-weight: 600;
        }

        /* User Dropdown */
        .user-dropdown .dropdown-toggle {
            background: none;
            border: none;
            padding: 8px 16px;
            border-radius: 50px;
            color: #334155;
            font-weight: 500;
            transition: var(--transition);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .user-dropdown .dropdown-toggle:hover {
            background: #f1f5f9;
        }

        .user-dropdown .dropdown-toggle::after {
            display: none;
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: var(--primary-gradient);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
        }

        /* Page Content */
        .page-content {
            flex: 1;
            padding: 30px;
            background: transparent;
        }

        /* Cards */
        .card {
            border: none;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            transition: var(--transition);
            background: white;
            overflow: hidden;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 35px rgba(0, 0, 0, 0.15);
        }

        .card-header {
            background: #f8fafc;
            border-bottom: 1px solid #e2e8f0;
            padding: 20px 24px;
            font-weight: 600;
            color: #1e293b;
        }

        .card-body {
            padding: 24px;
        }

        .card-footer {
            background: #f8fafc;
            border-top: 1px solid #e2e8f0;
            padding: 16px 24px;
        }

        /* Gradient Cards */
        .card-gradient-primary {
            background: var(--primary-gradient);
            color: white;
        }

        .card-gradient-success {
            background: var(--success-gradient);
            color: white;
        }

        .card-gradient-warning {
            background: var(--warning-gradient);
            color: white;
        }

        .card-gradient-danger {
            background: var(--danger-gradient);
            color: white;
        }

        .card-gradient-info {
            background: var(--info-gradient);
            color: white;
        }

        /* Buttons */
        .btn {
            border-radius: 8px;
            font-weight: 500;
            transition: var(--transition);
            border: none;
            padding: 10px 20px;
        }

        .btn-gradient-primary {
            background: var(--primary-gradient);
            color: white;
        }

        .btn-gradient-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }

        .btn-gradient-success {
            background: var(--success-gradient);
            color: white;
        }

        .btn-gradient-success:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 20px rgba(17, 153, 142, 0.4);
            color: white;
        }

        .btn-gradient-warning {
            background: var(--warning-gradient);
            color: white;
        }

        .btn-gradient-warning:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 20px rgba(240, 147, 251, 0.4);
            color: white;
        }

        .btn-gradient-danger {
            background: var(--danger-gradient);
            color: white;
        }

        .btn-gradient-danger:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 20px rgba(255, 65, 108, 0.4);
            color: white;
        }

        /* Stats Cards */
        .stats-card {
            background: white;
            border-radius: var(--border-radius);
            padding: 24px;
            margin-bottom: 20px;
            box-shadow: var(--box-shadow);
            position: relative;
            overflow: hidden;
            transition: var(--transition);
        }

        .stats-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        .stats-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: var(--primary-gradient);
        }

        .stats-icon {
            width: 64px;
            height: 64px;
            border-radius: var(--border-radius);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: white;
            margin-bottom: 16px;
        }

        .stats-icon.bg-primary {
            background: var(--primary-gradient);
        }

        .stats-icon.bg-success {
            background: var(--success-gradient);
        }

        .stats-icon.bg-warning {
            background: var(--warning-gradient);
        }

        .stats-icon.bg-danger {
            background: var(--danger-gradient);
        }

        .stats-icon.bg-info {
            background: var(--info-gradient);
        }

        .stats-icon.bg-pink {
            background: linear-gradient(135deg, #e91e63 0%, #ad1457 100%);
        }

        /* Tables */
        .table {
            background: white;
            border-radius: var(--border-radius);
            overflow: hidden;
            box-shadow: var(--box-shadow);
        }

        .table th {
            background: #f8fafc;
            border: none;
            font-weight: 600;
            color: #475569;
            padding: 16px;
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .table td {
            padding: 16px;
            border-color: #f1f5f9;
            vertical-align: middle;
        }

        .table tbody tr:hover {
            background: #f8fafc;
        }

        /* Form Controls */
        .form-control, .form-select {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 12px 16px;
            transition: var(--transition);
            font-size: 14px;
        }

        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .form-label {
            font-weight: 500;
            color: #374151;
            margin-bottom: 8px;
        }

        /* Alerts */
        .alert {
            border: none;
            border-radius: var(--border-radius);
            padding: 16px 20px;
            margin-bottom: 24px;
            border-left: 4px solid;
        }

        .alert-success {
            background: #ecfdf5;
            color: #065f46;
            border-left-color: #10b981;
        }

        .alert-danger {
            background: #fef2f2;
            color: #991b1b;
            border-left-color: #ef4444;
        }

        .alert-warning {
            background: #fffbeb;
            color: #92400e;
            border-left-color: #f59e0b;
        }

        .alert-info {
            background: #eff6ff;
            color: #1e40af;
            border-left-color: #3b82f6;
        }

        /* Badges */
        .badge {
            padding: 6px 12px;
            border-radius: 6px;
            font-weight: 500;
            font-size: 12px;
        }

        /* Loading Overlay */
        #loading {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(5px);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 9999;
            flex-direction: column;
        }

        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 4px solid #f3f4f6;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .loading-text {
            margin-top: 16px;
            color: #6b7280;
            font-weight: 500;
        }

        /* Toast Notifications */
        .notification-toast {
            position: fixed;
            top: 90px;
            right: 20px;
            z-index: 9999;
            min-width: 320px;
            box-shadow: var(--box-shadow);
            border-radius: var(--border-radius);
        }

        /* Utility Classes */
        .bg-pink {
            background-color: #e91e63 !important;
        }

        .text-pink {
            color: #e91e63 !important;
        }

        .shadow-sm {
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1) !important;
        }

        .shadow {
            box-shadow: var(--box-shadow) !important;
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                z-index: 1050;
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }

            .main-content.expanded {
                margin-left: 0;
            }

            .topbar {
                padding: 0 16px;
            }

            .page-content {
                padding: 20px 16px;
            }

            .sidebar-text {
                display: inline !important;
            }

            .card-body {
                padding: 16px;
            }
        }

        @media (max-width: 576px) {
            .stats-card {
                padding: 16px;
            }

            .page-content {
                padding: 16px 12px;
            }
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .fade-in {
            animation: fadeIn 0.6s ease-out;
        }

        /* Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }

        ::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }

        /* Additional component styles */
        .tracking-wide {
            letter-spacing: 0.05em;
        }
        
        .font-weight-bold {
            font-weight: 600 !important;
        }
        
        .text-xs {
            font-size: 0.75rem;
        }
        
        .fw-500 {
            font-weight: 500;
        }
        
        .avatar {
            width: 32px;
            height: 32px;
        }
        
        .avatar-sm {
            width: 28px;
            height: 28px;
        }
        
        .avatar-img {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: 600;
        }
        
        .opacity-50 {
            opacity: 0.5;
        }
        
        .h3 {
            font-size: 1.75rem;
        }
        
        .h4 {
            font-size: 1.25rem;
        }
        
        .h6 {
            font-size: 1rem;
        }

        /* Table improvements */
        .text-monospace {
            font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
            font-size: 0.875rem;
        }

        /* Enhanced button styles */
        .btn-group .dropdown-toggle::after {
            margin-left: 0.5rem;
        }

        /* Search and filter improvements */
        .form-select, .form-control {
            font-size: 0.875rem;
        }

        .form-label {
            font-weight: 500;
            color: #374151;
            margin-bottom: 0.5rem;
        }

        /* Modal improvements */
        .modal-header {
            background: #f8fafc;
            border-bottom: 1px solid #e2e8f0;
        }

        .modal-title {
            font-weight: 600;
        }

        .modal-footer {
            background: #f8fafc;
            border-top: 1px solid #e2e8f0;
        }

        /* DataTables customization */
        .dataTables_wrapper .dataTables_filter input {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 8px 12px;
        }

        .dataTables_wrapper .dataTables_length select {
            border: 2px solid #e2e8f0;
            border-radius: 8px;
            padding: 4px 8px;
        }

        .dataTables_wrapper .dataTables_info {
            color: #6b7280;
            font-size: 0.875rem;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button {
            border-radius: 6px;
            margin: 0 2px;
        }

        /* Print and export styles */
        @media print {
            .sidebar {
                display: none !important;
            }
            
            .main-content {
                margin-left: 0 !important;
            }
            
            .topbar {
                display: none !important;
            }
            
            .btn {
                display: none !important;
            }
        }

        /* WhatsApp Notification Styles */
        .whatsapp-notification-btn {
            position: relative;
            background: var(--whatsapp-gradient);
            border: none;
            color: white;
            border-radius: 50%;
            width: 45px;
            height: 45px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: var(--box-shadow);
            transition: var(--transition);
            margin-right: 15px;
        }

        .whatsapp-notification-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 30px rgba(37, 211, 102, 0.4);
        }

        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #ff4757;
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            font-size: 10px;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: pulse 2s infinite;
            min-width: 20px;
        }

        .notification-panel {
            position: fixed;
            top: 0;
            right: -400px;
            width: 400px;
            height: 100vh;
            background: white;
            box-shadow: -5px 0 25px rgba(0, 0, 0, 0.15);
            z-index: 1050;
            transition: var(--transition);
            overflow-y: auto;
        }

        .notification-panel.show {
            right: 0;
        }

        .notification-panel-header {
            background: var(--whatsapp-gradient);
            color: white;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 1;
        }

        .notification-panel-title {
            font-weight: 600;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .notification-close-btn {
            background: none;
            border: none;
            color: white;
            font-size: 18px;
            cursor: pointer;
            padding: 5px;
            border-radius: 5px;
            transition: var(--transition);
        }

        .notification-close-btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        .notification-tabs {
            display: flex;
            background: #f8f9fa;
            border-bottom: 1px solid #e9ecef;
        }

        .notification-tab {
            flex: 1;
            padding: 15px;
            background: none;
            border: none;
            text-align: center;
            font-weight: 500;
            color: #6c757d;
            transition: var(--transition);
            position: relative;
        }

        .notification-tab.active {
            color: #25d366;
            background: white;
        }

        .notification-tab.active::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: #25d366;
        }

        .notification-tab-badge {
            background: #ff4757;
            color: white;
            border-radius: 10px;
            padding: 2px 6px;
            font-size: 10px;
            margin-left: 5px;
        }

        .notification-list {
            max-height: calc(100vh - 150px);
            overflow-y: auto;
        }

        .notification-item {
            padding: 15px 20px;
            border-bottom: 1px solid #f1f3f4;
            transition: var(--transition);
            cursor: pointer;
            position: relative;
        }

        .notification-item:hover {
            background: #f8f9fa;
        }

        .notification-item.unread {
            background: #f0f9ff;
            border-left: 4px solid #25d366;
        }

        .notification-item.unread::before {
            content: '';
            position: absolute;
            top: 15px;
            right: 15px;
            width: 8px;
            height: 8px;
            background: #25d366;
            border-radius: 50%;
        }

        .notification-content {
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }

        .notification-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            color: white;
            flex-shrink: 0;
        }

        .notification-icon.success {
            background: var(--success-gradient);
        }

        .notification-icon.warning {
            background: var(--warning-gradient);
        }

        .notification-icon.info {
            background: var(--info-gradient);
        }

        .notification-icon.whatsapp {
            background: var(--whatsapp-gradient);
        }

        .notification-text {
            flex: 1;
            min-width: 0;
        }

        .notification-title {
            font-weight: 600;
            font-size: 14px;
            margin-bottom: 4px;
            color: #2d3748;
        }

        .notification-message {
            font-size: 13px;
            color: #6b7280;
            line-height: 1.4;
            margin-bottom: 4px;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .notification-time {
            font-size: 11px;
            color: #9ca3af;
        }

        .notification-actions {
            display: flex;
            gap: 8px;
            margin-top: 8px;
        }

        .notification-action-btn {
            padding: 4px 8px;
            border: 1px solid #e5e7eb;
            background: white;
            border-radius: 6px;
            font-size: 11px;
            color: #6b7280;
            cursor: pointer;
            transition: var(--transition);
        }

        .notification-action-btn:hover {
            background: #f3f4f6;
            color: #374151;
        }

        .notification-action-btn.primary {
            background: var(--whatsapp-gradient);
            border-color: #25d366;
            color: white;
        }

        .notification-action-btn.primary:hover {
            opacity: 0.9;
        }

        .notification-empty {
            text-align: center;
            padding: 40px 20px;
            color: #9ca3af;
        }

        .notification-empty i {
            font-size: 48px;
            margin-bottom: 15px;
            opacity: 0.5;
        }

        .notification-settings {
            padding: 20px;
            border-top: 1px solid #e9ecef;
            background: #f8f9fa;
        }

        .notification-toggle {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }

        .toggle-switch {
            position: relative;
            width: 44px;
            height: 24px;
            background: #e5e7eb;
            border-radius: 12px;
            cursor: pointer;
            transition: var(--transition);
        }

        .toggle-switch.active {
            background: #25d366;
        }

        .toggle-switch::after {
            content: '';
            position: absolute;
            top: 2px;
            left: 2px;
            width: 20px;
            height: 20px;
            background: white;
            border-radius: 50%;
            transition: var(--transition);
        }

        .toggle-switch.active::after {
            transform: translateX(20px);
        }

        /* Animation for new notifications */
        @keyframes slideInNotification {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        .notification-item.new {
            animation: slideInNotification 0.5s ease-out;
        }

        /* Sound notification styles */
        .sound-notification {
            position: fixed;
            top: 20px;
            right: 20px;
            background: var(--whatsapp-gradient);
            color: white;
            padding: 15px 20px;
            border-radius: 12px;
            box-shadow: var(--box-shadow);
            z-index: 1060;
            transform: translateX(400px);
            transition: var(--transition);
        }

        .sound-notification.show {
            transform: translateX(0);
        }

        .sound-notification-content {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .sound-notification-icon {
            font-size: 20px;
        }

        .sound-notification-text {
            font-weight: 500;
        }

        /* Overlay */
        .notification-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1040;
            opacity: 0;
            visibility: hidden;
            transition: var(--transition);
        }

        .notification-overlay.show {
            opacity: 1;
            visibility: visible;
        }

        <?php echo $__env->yieldPushContent('styles'); ?>
    </style>
</head>
<body>
    <!-- Loading Overlay -->
    <div id="loading">
        <div class="loading-spinner"></div>
        <div class="loading-text">Loading...</div>
    </div>

    <!-- Sidebar -->
    <nav class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <a class="navbar-brand" href="<?php echo e(route('admin.dashboard')); ?>">
                <i class="fas fa-landmark"></i>
                <span>Aplikasi Desa</span>
            </a>
        </div>
        
        <div class="sidebar-nav">
            <div class="nav-section">
                <div class="nav-section-title">Main Navigation</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span class="sidebar-text">Dashboard</span>
                </a>
            </div>

            <!-- 👥 Data Kependudukan -->
            <div class="nav-section">
                <div class="nav-section-title">👥 Data Kependudukan</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.penduduk.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.penduduk.index')); ?>">
                    <i class="fas fa-users"></i>
                    <span class="sidebar-text">Data Penduduk</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.mutasi-penduduk.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.mutasi-penduduk.index')); ?>">
                    <i class="fas fa-exchange-alt"></i>
                    <span class="sidebar-text">Mutasi Penduduk</span>
                    <span class="badge badge-success">🆕</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.keluarga.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.keluarga.index')); ?>">
                    <i class="fas fa-home"></i>
                    <span class="sidebar-text">Data Keluarga</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.pohon-keluarga.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.pohon-keluarga.index')); ?>">
                    <i class="fas fa-project-diagram"></i>
                    <span class="sidebar-text">Pohon Keluarga</span>
                </a>
            </div>

            <!-- 🏘️ Wilayah & Organisasi Desa -->
            <div class="nav-section">
                <div class="nav-section-title">🏘️ Wilayah & Organisasi Desa</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.wilayah-administratif.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.wilayah-administratif.index')); ?>">
                    <i class="fas fa-map-marked-alt"></i>
                    <span class="sidebar-text">Wilayah Administratif</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.struktur-organisasi.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.struktur-organisasi.index')); ?>">
                    <i class="fas fa-sitemap"></i>
                    <span class="sidebar-text">Struktur Organisasi</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.perangkat-desa.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.perangkat-desa.index')); ?>">
                    <i class="fas fa-users-cog"></i>
                    <span class="sidebar-text">Perangkat Desa</span>
                    <span class="badge badge-success">✅</span>
                </a>
            </div>

            <!-- 📨 Pelayanan Surat & Dokumen -->
            <div class="nav-section">
                <div class="nav-section-title">📨 Pelayanan Surat & Dokumen</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.pelayanan-surat.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.pelayanan-surat.index')); ?>">
                    <i class="fas fa-file-alt"></i>
                    <span class="sidebar-text">Pelayanan Surat</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.template-surat.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.template-surat.index')); ?>">
                    <i class="fas fa-file-contract"></i>
                    <span class="sidebar-text">Template Surat</span>
                    <span class="badge badge-info">✅</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.arsip-surat-keluar.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.arsip-surat-keluar.index')); ?>">
                    <i class="fas fa-file-export"></i>
                    <span class="sidebar-text">Arsip Surat Keluar</span>
                    <span class="badge badge-success">✅</span>
                </a>
            </div>

            <!-- 📢 Layanan Sosial & Aspirasi -->
            <div class="nav-section">
                <div class="nav-section-title">📢 Layanan Sosial & Aspirasi</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.pengaduan.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.pengaduan.index')); ?>">
                    <i class="fas fa-comment-dots"></i>
                    <span class="sidebar-text">Pengaduan</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.bantuan.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.bantuan.index')); ?>">
                    <i class="fas fa-hand-holding-heart"></i>
                    <span class="sidebar-text">Bantuan Sosial</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.polling.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.polling.index')); ?>">
                    <i class="fas fa-poll"></i>
                    <span class="sidebar-text">Polling & Aspirasi</span>
                </a>
            </div>

            <!-- 🗞️ Informasi & Peta Desa -->
            <div class="nav-section">
                <div class="nav-section-title">🗞️ Informasi & Peta Desa</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.berita.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.berita.index')); ?>">
                    <i class="fas fa-newspaper"></i>
                    <span class="sidebar-text">Berita</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.peta.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.peta.index')); ?>">
                    <i class="fas fa-map"></i>
                    <span class="sidebar-text">Peta Rumah</span>
                </a>
            </div>

            <!-- 💰 Keuangan & Pembangunan Desa -->
            <div class="nav-section">
                <div class="nav-section-title">💰 Keuangan & Pembangunan Desa</div>
                <div class="nav-item has-submenu">
                    <a class="nav-link dropdown-toggle <?php echo e(request()->routeIs('admin.apbdes.*') ? 'active' : ''); ?>" 
                       href="#" data-bs-toggle="collapse" data-bs-target="#apbdesSubmenu">
                        <i class="fas fa-chart-line"></i>
                        <span class="sidebar-text">APBDes</span>
                    </a>
                    <div class="collapse <?php echo e(request()->routeIs('admin.apbdes.*') ? 'show' : ''); ?>" id="apbdesSubmenu">
                        <div class="submenu">
                            <a class="nav-link submenu-link <?php echo e(request()->routeIs('admin.apbdes.rencana.*') ? 'active' : ''); ?>" 
                               href="<?php echo e(route('admin.apbdes.rencana.index')); ?>">
                                <i class="fas fa-clipboard-list"></i>
                                <span class="sidebar-text">Rencana</span>
                            </a>
                            <a class="nav-link submenu-link <?php echo e(request()->routeIs('admin.apbdes.realisasi.*') ? 'active' : ''); ?>" 
                               href="<?php echo e(route('admin.apbdes.realisasi.index')); ?>">
                                <i class="fas fa-receipt"></i>
                                <span class="sidebar-text">Realisasi</span>
                            </a>
                            <a class="nav-link submenu-link <?php echo e(request()->routeIs('admin.apbdes.laporan.*') ? 'active' : ''); ?>" 
                               href="<?php echo e(route('admin.apbdes.laporan')); ?>">
                                <i class="fas fa-file-invoice"></i>
                                <span class="sidebar-text">Laporan</span>
                            </a>
                        </div>
                    </div>
                </div>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.kegiatan-pembangunan.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.kegiatan-pembangunan.index')); ?>">
                    <i class="fas fa-building"></i>
                    <span class="sidebar-text">Kegiatan Pembangunan</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.pbb.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.pbb.index')); ?>">
                    <i class="fas fa-file-invoice-dollar"></i>
                    <span class="sidebar-text">PBB (Pajak Bumi dan Bangunan)</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.inventaris-desa.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.inventaris-desa.index')); ?>">
                    <i class="fas fa-boxes"></i>
                    <span class="sidebar-text">Inventaris Desa</span>
                </a>
            </div>

            <!-- 🛒 UMKM & Marketplace -->
            <div class="nav-section">
                <div class="nav-section-title">🛒 UMKM & Marketplace</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.umkm.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.umkm.index')); ?>">
                    <i class="fas fa-store"></i>
                    <span class="sidebar-text">Direktori UMKM</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.produk-umkm.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.produk-umkm.index')); ?>">
                    <i class="fas fa-box"></i>
                    <span class="sidebar-text">Produk UMKM</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.marketplace.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.marketplace.index')); ?>">
                    <i class="fas fa-shopping-cart"></i>
                    <span class="sidebar-text">Marketplace Desa</span>
                </a>
            </div>

            <!-- 🏞️ Pariwisata Desa -->
            <div class="nav-section">
                <div class="nav-section-title">🏞️ Pariwisata Desa</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.objek-wisata.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.objek-wisata.index')); ?>">
                    <i class="fas fa-mountain"></i>
                    <span class="sidebar-text">Objek Wisata</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.tiket-wisata.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.tiket-wisata.index')); ?>">
                    <i class="fas fa-ticket-alt"></i>
                    <span class="sidebar-text">Tiket Online</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.wisata.statistik') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.wisata.statistik')); ?>">
                    <i class="fas fa-chart-line"></i>
                    <span class="sidebar-text">Statistik Wisata</span>
                </a>
            </div>

            <!-- 💳 Transaksi & Pembayaran -->
            <div class="nav-section">
                <div class="nav-section-title">💳 Transaksi & Pembayaran</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.transaksi.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.transaksi.index')); ?>">
                    <i class="fas fa-credit-card"></i>
                    <span class="sidebar-text">Semua Transaksi</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.transaksi.pending') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.transaksi.pending')); ?>">
                    <i class="fas fa-clock"></i>
                    <span class="sidebar-text">Menunggu Pembayaran</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.ppob.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.ppob.index')); ?>">
                    <i class="fas fa-mobile-alt"></i>
                    <span class="sidebar-text">PPOB Management</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.transaksi.laporan') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.transaksi.laporan')); ?>">
                    <i class="fas fa-chart-bar"></i>
                    <span class="sidebar-text">Laporan Keuangan</span>
                </a>
            </div>

            <!-- 📅 Agenda & Kegiatan Desa -->
            <div class="nav-section">
                <div class="nav-section-title">📅 Agenda & Kegiatan Desa</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.agenda-desa.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.agenda-desa.index')); ?>">
                    <i class="fas fa-calendar-alt"></i>
                    <span class="sidebar-text">Agenda Desa</span>
                </a>
            </div>

            <!-- 🔔 Notifikasi Sistem -->
            <div class="nav-section">
                <div class="nav-section-title">🔔 Notifikasi Sistem</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.notifikasi.wa') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.notifikasi.wa')); ?>">
                    <i class="fab fa-whatsapp"></i>
                    <span class="sidebar-text">Notifikasi WhatsApp</span>
                    <?php
                        $sidebarUnreadCount = \App\Models\NotifikasiWa::where('is_read', false)->count();
                        $sidebarTotalCount = \App\Models\NotifikasiWa::count();
                    ?>
                    <?php if($sidebarUnreadCount > 0): ?>
                        <span class="badge badge-success" id="wa-notification-count"><?php echo e($sidebarUnreadCount); ?></span>
                    <?php endif; ?>
                </a>
                
                <a class="nav-link" href="#" onclick="toggleNotificationPanel()">
                    <i class="fas fa-bell"></i>
                    <span class="sidebar-text">Semua Notifikasi</span>
                    <?php if($sidebarTotalCount > 0): ?>
                        <span class="badge badge-primary" id="all-notification-count"><?php echo e($sidebarTotalCount); ?></span>
                    <?php endif; ?>
                </a>
            </div>

            <!-- 🐛 Bug Detection & Monitoring -->
            <div class="nav-section">
                <div class="nav-section-title">🐛 Bug Detection & Monitoring</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.bugs.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.bugs.index')); ?>">
                    <i class="fas fa-bug"></i>
                    <span class="sidebar-text">Bug Detection</span>
                    <?php
                        $criticalBugs = \App\Models\Bug::where('severity', 'critical')->where('status', 'open')->count();
                        $openBugs = \App\Models\Bug::where('status', 'open')->count();
                    ?>
                    <?php if($criticalBugs > 0): ?>
                        <span class="badge badge-danger"><?php echo e($criticalBugs); ?></span>
                    <?php elseif($openBugs > 0): ?>
                        <span class="badge badge-warning"><?php echo e($openBugs); ?></span>
                    <?php endif; ?>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.bugs.dashboard') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.bugs.dashboard')); ?>">
                    <i class="fas fa-chart-line"></i>
                    <span class="sidebar-text">Bug Analytics</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.bugs.create') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.bugs.create')); ?>">
                    <i class="fas fa-plus-circle"></i>
                    <span class="sidebar-text">Report Bug</span>
                </a>
            </div>

            <!-- ⚙️ Pengaturan & Manajemen Sistem -->
            <div class="nav-section">
                <div class="nav-section-title">⚙️ Pengaturan & Manajemen Sistem</div>
                <a class="nav-link <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.users.index')); ?>">
                    <i class="fas fa-user-cog"></i>
                    <span class="sidebar-text">User Management</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.roles.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.roles.index')); ?>">
                    <i class="fas fa-user-shield"></i>
                    <span class="sidebar-text">Role Management</span>
                </a>
                
                <a class="nav-link <?php echo e(request()->routeIs('admin.pengaturan.*') ? 'active' : ''); ?>" 
                   href="<?php echo e(route('admin.pengaturan.index')); ?>">
                    <i class="fas fa-cog"></i>
                    <span class="sidebar-text">Pengaturan Desa</span>
                </a>
            </div>

            <div class="sidebar-divider"></div>

            <div class="nav-section">
                <a class="nav-link" href="#" onclick="confirmLogout()">
                    <i class="fas fa-sign-out-alt"></i>
                    <span class="sidebar-text">Logout</span>
                </a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <!-- Topbar -->
        <div class="topbar">
            <div class="topbar-left">
                <button class="sidebar-toggle" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <?php echo $__env->yieldContent('breadcrumb'); ?>
                    </ol>
                </nav>
            </div>
            
            <div class="d-flex align-items-center">
                <!-- WhatsApp Notification Button -->
                <div class="d-flex gap-2">
                    <button class="whatsapp-notification-btn" onclick="toggleNotificationPanel()" title="Notifikasi WhatsApp">
                        <i class="fab fa-whatsapp"></i>
                        <?php
                            $unreadWaCount = \App\Models\NotifikasiWa::where('is_read', false)->count();
                        ?>
                        <?php if($unreadWaCount > 0): ?>
                            <span class="notification-badge" id="notification-badge"><?php echo e($unreadWaCount); ?></span>
                        <?php endif; ?>
                    </button>
                    
                    <a href="<?php echo e(route('admin.notifikasi-wa')); ?>" class="btn btn-outline-success btn-sm d-flex align-items-center" title="Kelola Notifikasi WhatsApp">
                        <i class="fas fa-cog me-1"></i>
                        <span class="d-none d-md-inline">Kelola</span>
                    </a>
                </div>

                <div class="user-dropdown dropdown">
                    <button class="dropdown-toggle" type="button" id="userDropdown" data-bs-toggle="dropdown">
                        <div class="user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <span><?php echo e(Auth::user()->name ?? 'Admin'); ?></span>
                        <i class="fas fa-chevron-down ms-1"></i>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end shadow">
                        <li><a class="dropdown-item" href="<?php echo e(route('profile')); ?>">
                            <i class="fas fa-user me-2"></i>Profile
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="#" onclick="confirmLogout()">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Page Content -->
        <div class="page-content">
            <!-- Flash Messages -->
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('warning')): ?>
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?php echo e(session('warning')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('info')): ?>
                <div class="alert alert-info alert-dismissible fade show" role="alert">
                    <i class="fas fa-info-circle me-2"></i>
                    <?php echo e(session('info')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

    <!-- Logout Form -->
    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
        <?php echo csrf_field(); ?>
    </form>

    <!-- Notification Overlay -->
    <div class="notification-overlay" id="notificationOverlay" onclick="closeNotificationPanel()"></div>

    <!-- WhatsApp Notification Panel -->
    <div class="notification-panel" id="notificationPanel">
        <div class="notification-panel-header">
            <h5 class="notification-panel-title">
                <i class="fab fa-whatsapp"></i>
                Notifikasi WhatsApp
            </h5>
            <div class="d-flex gap-2">
                <a href="<?php echo e(route('admin.notifikasi-wa')); ?>" class="btn btn-sm btn-outline-success" title="Buka Halaman Notifikasi">
                    <i class="fas fa-external-link-alt me-1"></i>Kelola
                </a>
                <button class="notification-close-btn" onclick="closeNotificationPanel()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>

        <div class="notification-tabs">
            <?php
                $recentCount = \App\Models\NotifikasiWa::where('is_read', false)->count();
                $sentCount = \App\Models\NotifikasiWa::where('status', 'Terkirim')->orWhere('status', 'sent')->count();
                $failedCount = \App\Models\NotifikasiWa::where('status', 'Gagal')->orWhere('status', 'failed')->count();
            ?>
            <button class="notification-tab active" data-tab="recent">
                Terbaru
                <span class="notification-tab-badge"><?php echo e($recentCount); ?></span>
            </button>
            <button class="notification-tab" data-tab="sent">
                Terkirim
                <span class="notification-tab-badge"><?php echo e($sentCount); ?></span>
            </button>
            <button class="notification-tab" data-tab="failed">
                Gagal
                <span class="notification-tab-badge"><?php echo e($failedCount); ?></span>
            </button>
        </div>

        <div class="notification-list" id="notificationList">
            <?php
                $panelNotifications = \App\Models\NotifikasiWa::with('penduduk')
                    ->orderBy('created_at', 'desc')
                    ->limit(10)
                    ->get();
            ?>
            
            <?php $__empty_1 = true; $__currentLoopData = $panelNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="notification-item <?php echo e(!$notification->is_read ? 'unread' : ''); ?>" data-id="<?php echo e($notification->id); ?>">
                <div class="notification-content">
                    <div class="notification-icon <?php echo e($notification->status == 'Terkirim' || $notification->status == 'sent' ? 'success' : ($notification->status == 'Gagal' || $notification->status == 'failed' ? 'warning' : 'whatsapp')); ?>">
                        <?php if($notification->status == 'Terkirim' || $notification->status == 'sent'): ?>
                            <i class="fas fa-check-circle"></i>
                        <?php elseif($notification->status == 'Gagal' || $notification->status == 'failed'): ?>
                            <i class="fas fa-exclamation-triangle"></i>
                        <?php else: ?>
                            <i class="fab fa-whatsapp"></i>
                        <?php endif; ?>
                    </div>
                    <div class="notification-text">
                        <div class="notification-title">
                            <?php echo e(ucfirst(str_replace('_', ' ', $notification->message_type ?: $notification->jenis ?: 'Notifikasi WhatsApp'))); ?>

                        </div>
                        <div class="notification-message">
                            <?php echo e(Str::limit($notification->message ?: $notification->pesan, 100)); ?>

                        </div>
                        <div class="notification-time"><?php echo e($notification->created_at->diffForHumans()); ?></div>
                        <?php if(!$notification->is_read): ?>
                        <div class="notification-actions">
                            <button class="notification-action-btn primary" onclick="viewFullNotification(<?php echo e($notification->id); ?>)">Lihat Detail</button>
                            <button class="notification-action-btn" onclick="markAsRead(<?php echo e($notification->id); ?>)">Tandai Dibaca</button>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="notification-empty">
                <i class="fab fa-whatsapp"></i>
                <p>Belum ada notifikasi WhatsApp</p>
            </div>
            <?php endif; ?>
        </div>

        <div class="notification-settings">
            <div class="notification-toggle">
                <span>Notifikasi Suara</span>
                <div class="toggle-switch active" onclick="toggleSoundNotification()"></div>
            </div>
            <div class="notification-toggle">
                <span>Auto-refresh</span>
                <div class="toggle-switch active" onclick="toggleAutoRefresh()"></div>
            </div>
            <div class="notification-toggle">
                <span>Desktop Notifications</span>
                <div class="toggle-switch" onclick="toggleDesktopNotification()"></div>
            </div>
        </div>
    </div>

    <!-- Sound Notification Popup -->
    <div class="sound-notification" id="soundNotification">
        <div class="sound-notification-content">
            <div class="sound-notification-icon">
                <i class="fab fa-whatsapp"></i>
            </div>
            <div class="sound-notification-text">Notifikasi WhatsApp baru!</div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Modal Backdrop Fix -->
    <script src="<?php echo e(asset('js/modal-fix.js')); ?>"></script>
    
    <!-- Modern Scroll Library -->
    <script src="<?php echo e(asset('js/modern-scroll.js')); ?>"></script>
    
    <!-- Admin Session Management -->
    <?php if(request()->is('admin*')): ?>
    <script src="<?php echo e(asset('js/admin-session.js')); ?>"></script>
    <?php endif; ?>
    
    <script>
        // Initialize app
        $(document).ready(function() {
            initializeApp();
        });

        function initializeApp() {
            setupSidebar();
            setupTooltips();
            setupFormValidation();
            hideLoadingAfterDelay();
        }

        // Sidebar functionality
        function setupSidebar() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            const sidebarToggle = document.getElementById('sidebarToggle');

            sidebarToggle.addEventListener('click', function() {
                sidebar.classList.toggle('sidebar-collapsed');
                mainContent.classList.toggle('expanded');
                
                // Save state to localStorage
                const isCollapsed = sidebar.classList.contains('sidebar-collapsed');
                localStorage.setItem('sidebarCollapsed', isCollapsed);
            });

            // Restore sidebar state
            const savedState = localStorage.getItem('sidebarCollapsed');
            if (savedState === 'true') {
                sidebar.classList.add('sidebar-collapsed');
                mainContent.classList.add('expanded');
            }

            // Mobile sidebar
            if (window.innerWidth <= 768) {
                sidebarToggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    sidebar.classList.toggle('show');
                });

                // Close sidebar when clicking outside
                document.addEventListener('click', function(e) {
                    if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                        sidebar.classList.remove('show');
                    }
                });
            }
        }

        // Loading functions
        function showLoading() {
            document.getElementById('loading').style.display = 'flex';
        }

        function hideLoading() {
            document.getElementById('loading').style.display = 'none';
        }

        function hideLoadingAfterDelay() {
            setTimeout(hideLoading, 500);
        }

        // CSRF Token setup
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // CSRF Token refresh function
        function refreshCsrfToken() {
            return $.get('/csrf-token').then(function(response) {
                if (response && response.token) {
                    $('meta[name="csrf-token"]').attr('content', response.token);
                    $('input[name="_token"]').val(response.token);
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': response.token
                        }
                    });
                    return response.token;
                }
            });
        }

        // Auto-refresh CSRF token every 30 minutes
        setInterval(function() {
            refreshCsrfToken().catch(function(error) {
                console.warn('Failed to refresh CSRF token:', error);
            });
        }, 30 * 60 * 1000); // 30 minutes

        // Handle 419 errors globally
        $(document).ajaxError(function(event, xhr, settings) {
            if (xhr.status === 419) {
                // CSRF token mismatch - try to refresh and retry
                refreshCsrfToken().then(function() {
                    // Retry the original request
                    $.ajax(settings);
                }).catch(function() {
                    // If refresh fails, show user-friendly message
                    showToast('Sesi Anda telah berakhir. Silakan refresh halaman dan coba lagi.', 'error');
                });
            }
        });

        // Logout confirmation
        function confirmLogout() {
            showAdminLogoutModal();
        }

        // Show admin logout confirmation modal
        function showAdminLogoutModal() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
            modal.style.zIndex = '9999';
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm shadow-xl">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-sign-out-alt text-red-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Konfirmasi Logout</h3>
                        <p class="text-gray-600 text-sm">Apakah Anda yakin ingin keluar dari sistem?</p>
                    </div>
                    
                    <div class="space-y-3">
                        <button onclick="confirmAdminLogout()" class="w-full bg-red-600 text-white py-3 rounded-xl font-semibold hover:bg-red-700 transition-all">
                            Ya, Logout
                        </button>
                        
                        <button onclick="closeAdminModal()" class="w-full bg-gray-500 text-white py-3 rounded-xl font-semibold hover:bg-gray-600 transition-all">
                            Batal
                        </button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Confirm admin logout action
        function confirmAdminLogout() {
            document.getElementById('logout-form').submit();
        }

        // Close admin modal
        function closeAdminModal() {
            const modals = document.querySelectorAll('.fixed.inset-0');
            modals.forEach(modal => {
                if (modal.classList.contains('bg-black')) {
                    modal.remove();
                }
            });
        }

        // Enhanced toast notifications
        function showToast(message, type = 'success', title = null) {
            const iconMap = {
                success: 'check-circle',
                error: 'exclamation-triangle',
                warning: 'exclamation-circle',
                info: 'info-circle'
            };

            const colorMap = {
                success: '#10b981',
                error: '#ef4444',
                warning: '#f59e0b',
                info: '#3b82f6'
            };

            Swal.fire({
                icon: type,
                title: title || (type.charAt(0).toUpperCase() + type.slice(1)),
                text: message,
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 4000,
                timerProgressBar: true,
                iconColor: colorMap[type],
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer);
                    toast.addEventListener('mouseleave', Swal.resumeTimer);
                }
            });
        }

        // Setup tooltips
        function setupTooltips() {
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        }

        // Form validation
        function setupFormValidation() {
            const forms = document.querySelectorAll('.needs-validation');
            Array.prototype.slice.call(forms).forEach(function (form) {
                form.addEventListener('submit', function (event) {
                    if (!form.checkValidity()) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }

        // Utility functions
        function formatNumber(num) {
            return new Intl.NumberFormat('id-ID').format(num);
        }

        function formatCurrency(num) {
            return new Intl.NumberFormat('id-ID', {
                style: 'currency',
                currency: 'IDR',
                minimumFractionDigits: 0,
                maximumFractionDigits: 0
            }).format(num);
        }

        function formatDate(dateString) {
            const options = { 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                timeZone: 'Asia/Jakarta'
            };
            return new Date(dateString).toLocaleDateString('id-ID', options);
        }

        // Auto-resize textareas
        document.addEventListener('input', function(e) {
            if (e.target.tagName === 'TEXTAREA') {
                e.target.style.height = 'auto';
                e.target.style.height = e.target.scrollHeight + 'px';
            }
        });

        // Window resize handler
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                document.getElementById('sidebar').classList.remove('show');
            }
        });

        // Add fade-in animation to page content
        document.querySelector('.page-content').classList.add('fade-in');

        // WhatsApp Notification System Variables
        let notificationSettings = {
            sound: true,
            autoRefresh: true,
            desktop: false
        };

        let notificationInterval;
        let unreadCount = 0;

        // WhatsApp Notification Functions
        function initializeWhatsAppNotifications() {
            try {
                loadNotificationSettings();
                setupNotificationTabs();
                if (notificationSettings.autoRefresh) {
                    startAutoRefresh();
                }
                requestNotificationPermission();
                console.log('WhatsApp notifications initialized successfully');
            } catch (error) {
                console.warn('Error initializing WhatsApp notifications:', error);
            }
        }

        // Panel Controls
        function toggleNotificationPanel() {
            const panel = document.getElementById('notificationPanel');
            const overlay = document.getElementById('notificationOverlay');
            
            if (panel.classList.contains('show')) {
                closeNotificationPanel();
            } else {
                panel.classList.add('show');
                overlay.classList.add('show');
                loadNotifications();
            }
        }

        function closeNotificationPanel() {
            const panel = document.getElementById('notificationPanel');
            const overlay = document.getElementById('notificationOverlay');
            
            panel.classList.remove('show');
            overlay.classList.remove('show');
        }

        // Tab Management
        function setupNotificationTabs() {
            const tabs = document.querySelectorAll('.notification-tab');
            if (tabs.length > 0) {
                tabs.forEach(tab => {
                    tab.addEventListener('click', function() {
                        tabs.forEach(t => t.classList.remove('active'));
                        this.classList.add('active');
                        loadNotifications(this.getAttribute('data-tab'));
                    });
                });
            }
        }

        // Load Notifications via AJAX
        function loadNotifications(type = 'recent') {
            const listContainer = document.getElementById('notificationList');
            if (!listContainer) {
                console.log('Notification list container not found');
                return;
            }
            
            // Show loading
            listContainer.innerHTML = '<div class="text-center p-4"><i class="fas fa-spinner fa-spin"></i> Memuat notifikasi...</div>';
            
            $.ajax({
                url: '/admin/api/notifications/' + type,
                method: 'GET',
                timeout: 10000,
                success: function(response) {
                    if (response && response.success) {
                        renderNotifications(response.data || [], type);
                        if (response.counts) {
                            updateBadgeCounts(response.counts);
                        }
                    } else {
                        showEmptyNotifications(type);
                    }
                },
                error: function(xhr, status, error) {
                    if (listContainer) {
                        listContainer.innerHTML = '<div class="notification-empty"><i class="fas fa-exclamation-triangle"></i><p>Gagal memuat notifikasi</p></div>';
                    }
                    console.warn('Error loading notifications:', error);
                }
            });
        }

        function renderNotifications(notifications, type) {
            const listContainer = document.getElementById('notificationList');
            if (!listContainer) return;
            
            if (!notifications || notifications.length === 0) {
                showEmptyNotifications(type);
                return;
            }

            let html = '';
            notifications.forEach(notification => {
                html += `
                    <div class="notification-item ${!notification.is_read ? 'unread' : ''}">
                        <div class="notification-content">
                            <div class="notification-header">
                                <span class="notification-type">${notification.message_type || 'general'}</span>
                                <span class="notification-time">${formatTimeAgo(notification.created_at)}</span>
                            </div>
                            <div class="notification-message">${notification.message || notification.pesan || 'No message'}</div>
                            <div class="notification-recipient">${notification.phone_number || notification.no_wa || 'Unknown'}</div>
                        </div>
                        <div class="notification-actions">
                            ${!notification.is_read ? `<button onclick="markAsRead(${notification.id})" class="btn-mark-read" title="Tandai sudah dibaca"><i class="fas fa-check"></i></button>` : ''}
                        </div>
                    </div>
                `;
            });
            
            listContainer.innerHTML = html;
        }

        function markAsRead(notificationId) {
            $.ajax({
                url: `/admin/api/notifications/${notificationId}/read`,
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        loadNotifications(); // Reload notifications
                        updateUnreadCount(-1); // Decrease unread count
                    }
                },
                error: function() {
                    console.warn('Failed to mark notification as read');
                }
            });
        }


        function createNotificationItem(notification) {
            const timeAgo = formatTimeAgo(notification.created_at);
            const iconClass = getNotificationIcon(notification.type);
            const unreadClass = notification.is_read ? '' : 'unread';
            
            return `
                <div class="notification-item ${unreadClass}" data-id="${notification.id}">
                    <div class="notification-content">
                        <div class="notification-icon ${notification.type}">
                            <i class="${iconClass}"></i>
                        </div>
                        <div class="notification-text">
                            <div class="notification-title">${notification.title}</div>
                            <div class="notification-message">${notification.message}</div>
                            <div class="notification-time">${timeAgo}</div>
                            <div class="notification-actions">
                                ${createNotificationActions(notification)}
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }

        function createNotificationActions(notification) {
            let actions = '';
            
            if (!notification.is_read) {
                actions += `<button class="notification-action-btn" onclick="markAsRead(${notification.id})">Tandai Dibaca</button>`;
            }
            
            if (notification.type === 'whatsapp' && notification.status === 'pending') {
                actions += `<button class="notification-action-btn primary" onclick="resendMessage(${notification.id})">Kirim Ulang</button>`;
            }
            
            if (notification.type === 'broadcast') {
                actions += `<button class="notification-action-btn primary" onclick="sendBroadcast(${notification.id})">Kirim Sekarang</button>`;
            }
            
            return actions;
        }

        function showEmptyNotifications(type = 'recent') {
            const messages = {
                recent: 'Tidak ada notifikasi terbaru',
                sent: 'Belum ada pesan terkirim',
                failed: 'Tidak ada pesan gagal'
            };
            
            document.getElementById('notificationList').innerHTML = `
                <div class="notification-empty">
                    <i class="fab fa-whatsapp"></i>
                    <p>${messages[type] || messages.recent}</p>
                </div>
            `;
        }

        // Notification Actions
        function markAsRead(notificationId) {
            // Show loading state
            const item = document.querySelector(`[data-id="${notificationId}"]`);
            if (item) {
                item.classList.remove('unread');
                const actions = item.querySelector('.notification-actions');
                if (actions) actions.style.display = 'none';
                
                // Update badges
                updateUnreadCount(-1);
                showToast('Notifikasi ditandai sudah dibaca', 'success');
            }
        }
        
        function viewFullNotification(notificationId) {
            // Navigate to WhatsApp notifications page with specific notification
            window.location.href = `/admin/notifikasi/wa?highlight=${notificationId}`;
        }

        function resendMessage(notificationId) {
            $.ajax({
                url: `/admin/api/notifications/${notificationId}/resend`,
                method: 'POST',
                success: function(response) {
                    if (response.success) {
                        showToast('Pesan berhasil dikirim ulang', 'success');
                        loadNotifications();
                    } else {
                        showToast('Gagal mengirim ulang pesan', 'error');
                    }
                }
            });
        }

        function sendBroadcast(notificationId) {
            Swal.fire({
                title: 'Kirim Broadcast?',
                text: 'Pesan akan dikirim ke semua warga yang terdaftar',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#25d366',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, Kirim',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `/admin/api/notifications/${notificationId}/broadcast`,
                        method: 'POST',
                        success: function(response) {
                            if (response.success) {
                                showToast(`Broadcast terkirim ke ${response.sent_count} nomor`, 'success');
                                loadNotifications();
                            } else {
                                showToast('Gagal mengirim broadcast', 'error');
                            }
                        }
                    });
                }
            });
        }

        // Settings Toggle
        function toggleSoundNotification() {
            const toggle = event.target;
            notificationSettings.sound = !notificationSettings.sound;
            toggle.classList.toggle('active');
            saveNotificationSettings();
            
            showToast(
                notificationSettings.sound ? 'Notifikasi suara diaktifkan' : 'Notifikasi suara dinonaktifkan',
                'info'
            );
        }

        function toggleAutoRefresh() {
            const toggle = event.target;
            notificationSettings.autoRefresh = !notificationSettings.autoRefresh;
            toggle.classList.toggle('active');
            saveNotificationSettings();
            
            if (notificationSettings.autoRefresh) {
                startAutoRefresh();
                showToast('Auto-refresh diaktifkan', 'info');
            } else {
                stopAutoRefresh();
                showToast('Auto-refresh dinonaktifkan', 'info');
            }
        }

        function toggleDesktopNotification() {
            const toggle = event.target;
            
            if (!notificationSettings.desktop && Notification.permission !== 'granted') {
                requestNotificationPermission().then(granted => {
                    if (granted) {
                        notificationSettings.desktop = true;
                        toggle.classList.add('active');
                        saveNotificationSettings();
                        showToast('Desktop notifications diaktifkan', 'info');
                    }
                });
            } else {
                notificationSettings.desktop = !notificationSettings.desktop;
                toggle.classList.toggle('active');
                saveNotificationSettings();
                
                showToast(
                    notificationSettings.desktop ? 'Desktop notifications diaktifkan' : 'Desktop notifications dinonaktifkan',
                    'info'
                );
            }
        }

        // Auto Refresh
        function startAutoRefresh() {
            try {
                if (notificationInterval) clearInterval(notificationInterval);
                
                notificationInterval = setInterval(() => {
                    checkNewNotifications();
                }, 30000); // Check every 30 seconds
                
                console.log('Auto-refresh started for WhatsApp notifications');
            } catch (error) {
                console.warn('Error starting auto-refresh:', error);
            }
        }

        function stopAutoRefresh() {
            if (notificationInterval) {
                clearInterval(notificationInterval);
                notificationInterval = null;
            }
        }

        function checkNewNotifications() {
            // Temporarily disabled - API endpoint not ready
            console.log('checkNewNotifications temporarily disabled');
            return;
            
            // Check if we're on the notifications page and don't interrupt user interaction
            if (window.location.pathname.includes('/admin/notifikasi/wa')) {
                return;
            }
            
            $.ajax({
                url: '/admin/api/notifications/check',
                method: 'GET',
                timeout: 5000,
                success: function(response) {
                    if (response && response.new_notifications > 0) {
                        updateUnreadCount(response.new_notifications);
                        
                        if (notificationSettings.sound) {
                            playNotificationSound();
                        }
                        
                        if (notificationSettings.desktop && response.latest) {
                            showDesktopNotification(response.latest);
                        }
                        
                        showSoundNotification();
                        
                        // Refresh if panel is open
                        const panel = document.getElementById('notificationPanel');
                        if (panel && panel.classList.contains('show')) {
                            loadNotifications();
                        }
                    }
                },
                error: function(xhr, status, error) {
                    if (status !== 'timeout') {
                        console.warn('Error checking notifications:', error);
                    }
                }
            });
        }

        // Notification Features
        function playNotificationSound() {
            try {
                // Create audio element for notification sound
                const audio = new Audio('/sounds/notification.mp3');
                audio.volume = 0.3;
                audio.play().catch(e => console.log('Could not play notification sound:', e));
            } catch (error) {
                console.log('Error playing notification sound:', error);
            }
        }

        function showDesktopNotification(notification) {
            try {
                if (Notification.permission === 'granted' && notification) {
                    new Notification(notification.title || 'WhatsApp Notification', {
                        body: notification.message || notification.pesan || 'New notification',
                        icon: '/images/whatsapp-icon.png',
                        tag: 'whatsapp-notification'
                    });
                }
            } catch (error) {
                console.warn('Error showing desktop notification:', error);
            }
        }

        function requestNotificationPermission() {
            return new Promise((resolve) => {
                try {
                    if (!('Notification' in window)) {
                        console.log('Browser does not support notifications');
                        resolve(false);
                        return;
                    }
                    
                    if (Notification.permission === 'granted') {
                        resolve(true);
                    } else if (Notification.permission !== 'denied') {
                        Notification.requestPermission().then(permission => {
                            resolve(permission === 'granted');
                        }).catch(() => {
                            resolve(false);
                        });
                    } else {
                        resolve(false);
                    }
                } catch (error) {
                    console.warn('Error requesting notification permission:', error);
                    resolve(false);
                }
            });
        }

        // Utility Functions
        function updateBadgeCounts(counts) {
            if (counts) {
                const badge = document.getElementById('notification-badge');
                if (badge) {
                    badge.textContent = counts.unread || counts.whatsapp || 0;
                }
                
                const waCount = document.getElementById('wa-notification-count');
                if (waCount) {
                    waCount.textContent = counts.whatsapp || 0;
                }
                
                const allCount = document.getElementById('all-notification-count');
                if (allCount) {
                    allCount.textContent = counts.total || 0;
                }
            }
        }

        function updateUnreadCount(change) {
            unreadCount = Math.max(0, unreadCount + change);
            const badge = document.getElementById('notification-badge');
            if (badge) {
                badge.textContent = unreadCount;
                if (unreadCount > 0) {
                    badge.style.display = 'block';
                } else {
                    badge.style.display = 'none';
                }
            }
        }

        function showEmptyNotifications(type = 'recent') {
            const listContainer = document.getElementById('notificationList');
            if (listContainer) {
                const typeText = {
                    'recent': 'Belum ada notifikasi terbaru',
                    'sent': 'Belum ada notifikasi terkirim',
                    'failed': 'Tidak ada notifikasi gagal'
                };
                
                listContainer.innerHTML = `
                    <div class="notification-empty">
                        <i class="fas fa-inbox"></i>
                        <p>${typeText[type] || 'Belum ada notifikasi'}</p>
                    </div>
                `;
            }
        }

        function getNotificationIcon(type) {
            const icons = {
                whatsapp: 'fab fa-whatsapp',
                success: 'fas fa-check-circle',
                warning: 'fas fa-exclamation-triangle',
                info: 'fas fa-info-circle',
                error: 'fas fa-times-circle'
            };
            return icons[type] || 'fas fa-bell';
        }

        function formatTimeAgo(dateString) {
            const now = new Date();
            const date = new Date(dateString);
            const diff = now - date;
            
            const minutes = Math.floor(diff / 60000);
            const hours = Math.floor(diff / 3600000);
            const days = Math.floor(diff / 86400000);
            
            if (minutes < 1) return 'Baru saja';
            if (minutes < 60) return `${minutes} menit yang lalu`;
            if (hours < 24) return `${hours} jam yang lalu`;
            return `${days} hari yang lalu`;
        }

        // Local Storage
        function saveNotificationSettings() {
            localStorage.setItem('whatsapp_notification_settings', JSON.stringify(notificationSettings));
        }

        function loadNotificationSettings() {
            try {
                const saved = localStorage.getItem('whatsapp_notification_settings');
                if (saved) {
                    notificationSettings = { ...notificationSettings, ...JSON.parse(saved) };
                    
                    // Apply saved settings to toggles if they exist
                    const toggles = document.querySelectorAll('.toggle-switch');
                    if (toggles.length > 0) {
                        toggles.forEach((toggle, index) => {
                            const settings = ['sound', 'autoRefresh', 'desktop'];
                            if (notificationSettings[settings[index]]) {
                                toggle.classList.add('active');
                            }
                        });
                    }
                }
            } catch (error) {
                console.warn('Error loading notification settings:', error);
            }
        }

        // Keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            // Ctrl/Cmd + Shift + N to toggle notifications
            if ((e.ctrlKey || e.metaKey) && e.shiftKey && e.key === 'N') {
                e.preventDefault();
                toggleNotificationPanel();
            }
            
            // Escape to close notification panel
            if (e.key === 'Escape' && document.getElementById('notificationPanel').classList.contains('show')) {
                closeNotificationPanel();
            }
        });

        // Initialize WhatsApp Notifications when DOM is ready
        $(document).ready(function() {
            initializeWhatsAppNotifications();
        });
    </script>
    
    <!-- Quill Editor Debug & Error Handling -->
    <script>
        // Enhanced Quill Error Handler
        window.QuillErrorHandler = {
            enabled: true,
            errors: [],
            
            log: function(error, context = 'unknown') {
                this.errors.push({error, context, timestamp: new Date()});
                console.error(`[Quill Error - ${context}]:`, error);
                
                if (this.enabled) {
                    this.showUserFriendlyError(error, context);
                }
            },
            
            showUserFriendlyError: function(error, context) {
                // Create user-friendly error message
                const alertDiv = document.createElement('div');
                alertDiv.className = 'alert alert-warning alert-dismissible fade show position-fixed';
                alertDiv.style.cssText = 'top: 20px; right: 20px; z-index: 9999; max-width: 400px;';
                alertDiv.innerHTML = `
                    <strong>Editor Notice:</strong> Editor konten menggunakan mode fallback.
                    <br><small>Semua fitur tetap berfungsi normal.</small>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                `;
                
                document.body.appendChild(alertDiv);
                
                // Auto-remove after 5 seconds
                setTimeout(() => {
                    if (alertDiv.parentNode) {
                        alertDiv.remove();
                    }
                }, 5000);
            },
            
            enableFallback: function() {
                const editor = document.getElementById('editor');
                const hiddenTextarea = document.getElementById('kontenHidden');
                
                // Only enable fallback if we're on a page that actually has editor elements
                if (!editor && !hiddenTextarea) {
                    // No editor elements found, this page doesn't need Quill
                    return true;
                }
                
                console.log('🔄 Enabling Quill fallback mode...');
                
                if (editor && hiddenTextarea) {
                    // Hide Quill editor
                    editor.style.display = 'none';
                    
                    // Show and style textarea
                    hiddenTextarea.style.display = 'block';
                    hiddenTextarea.className = 'form-control';
                    hiddenTextarea.rows = 12;
                    hiddenTextarea.style.minHeight = '300px';
                    hiddenTextarea.placeholder = 'Tulis konten berita di sini... (Mode Text)';
                    
                    // Add label
                    const label = document.createElement('div');
                    label.className = 'badge bg-info mb-2';
                    label.textContent = 'Mode Text Editor - Semua fitur tersedia';
                    hiddenTextarea.parentNode.insertBefore(label, hiddenTextarea);
                    
                    console.log('✅ Fallback editor enabled');
                    return true;
                }
                
                console.log('❌ Could not enable fallback editor - missing elements');
                return false;
            }
        };
        
        // Monitor and override original Quill initialization
        document.addEventListener('DOMContentLoaded', function() {
            // Wait for other scripts to load
            setTimeout(() => {
                // Check if this page actually needs Quill
                const editor = document.getElementById('editor');
                const hiddenTextarea = document.getElementById('kontenHidden');
                
                // Only proceed if we're on a page with editor elements
                if (!editor && !hiddenTextarea) {
                    return; // Exit early for pages without editors
                }
                
                // Check if Quill exists
                if (typeof Quill === 'undefined') {
                    console.log('ℹ️ Quill not loaded, using fallback editor');
                    window.QuillErrorHandler.enableFallback();
                    return;
                }
                
                // Override initQuillEditor if it exists
                if (typeof window.initQuillEditor === 'function') {
                    const originalInit = window.initQuillEditor;
                    window.initQuillEditor = function() {
                        try {
                            return originalInit.apply(this, arguments);
                        } catch (error) {
                            window.QuillErrorHandler.log(error, 'initialization');
                            window.QuillErrorHandler.enableFallback();
                        }
                    };
                }
            }, 500);
        });
        
        // Global error handler for Quill-related errors
        window.addEventListener('error', function(event) {
            if (event.error && event.error.message && 
                (event.error.message.includes('Quill') || event.filename.includes('quill'))) {
                window.QuillErrorHandler.log(event.error, 'runtime');
                event.preventDefault();
            }
        });
        
        console.log('✅ Quill Error Handler initialized');
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html> <?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/layouts/app.blade.php ENDPATH**/ ?>