<?php
require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Umkm;
use App\Models\ProdukUmkm;

echo "Testing UMKM Models...\n";

try {
    // Test 1: Create UMKM instance
    $umkm = new Umkm();
    echo "✓ UMKM model instantiated successfully\n";
    
    // Test 2: Test logo URL accessor
    $umkm->logo = 'sample-logo.png';
    $logoUrl = $umkm->logo_url;
    echo "✓ Logo URL: $logoUrl\n";
    
    // Test 3: Test gallery URL accessor
    $umkm->galeri_foto = ['sample-gallery1.png', 'sample-gallery2.png'];
    $galleryUrls = $umkm->galeri_foto_urls;
    echo "✓ Gallery URLs: " . implode(', ', $galleryUrls) . "\n";
    
    // Test 4: Create ProdukUmkm instance
    $produk = new ProdukUmkm();
    echo "✓ ProdukUmkm model instantiated successfully\n";
    
    // Test 5: Test product photo URL accessor
    $produk->foto_utama = 'sample-product.jpg';
    $photoUrl = $produk->foto_utama_url;
    echo "✓ Product Photo URL: $photoUrl\n";
    
    echo "✅ All model tests passed!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
?>
