<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing authentication and user data...\n\n";

// Check if users exist
$userCount = App\Models\User::count();
echo "Total users: " . $userCount . "\n";

if ($userCount > 0) {
    $user = App\Models\User::first();
    echo "First user: " . $user->name . " (" . $user->email . ")\n";
    echo "User role: " . ($user->role ?? 'N/A') . "\n";
    echo "Is active: " . ($user->is_active ? 'Yes' : 'No') . "\n";
    echo "Is admin: " . ($user->is_admin ? 'Yes' : 'No') . "\n";
    echo "Can access admin: " . ($user->canAccessAdmin() ? 'Yes' : 'No') . "\n";
} else {
    echo "No users found in database!\n";
}

echo "\nChecking UMKM data...\n";
$umkmCount = App\Models\Umkm::count();
echo "Total UMKM: " . $umkmCount . "\n";

$aktifUmkm = App\Models\Umkm::aktif()->with('pemilik')->count();
echo "Active UMKM: " . $aktifUmkm . "\n";

if ($aktifUmkm > 0) {
    $umkm = App\Models\Umkm::aktif()->with('pemilik')->first();
    echo "Sample UMKM: " . $umkm->nama_umkm . "\n";
    echo "Owner: " . ($umkm->pemilik ? $umkm->pemilik->nama : 'N/A') . "\n";
}

echo "\nDone!\n";
