<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing Database Connection...\n\n";

try {
    // Test database connection
    echo "1. Testing database connection...\n";
    $count = App\Models\Umkm::count();
    echo "   ✓ UMKM count: " . $count . "\n";
    
    // Test penduduk table
    $pendudukCount = App\Models\Penduduk::count();
    echo "   ✓ Penduduk count: " . $pendudukCount . "\n";
    
    // Test table structure
    echo "\n2. Testing table structure...\n";
    $umkm = new App\Models\Umkm();
    $fillable = $umkm->getFillable();
    echo "   ✓ UMKM fillable fields: " . implode(', ', $fillable) . "\n";
    
    // Test required fields
    echo "\n3. Testing required fields...\n";
    $requiredFields = ['nama_umkm', 'kategori', 'pemilik_id', 'deskripsi', 'alamat', 'skala_usaha'];
    foreach ($requiredFields as $field) {
        if (in_array($field, $fillable)) {
            echo "   ✓ Field '{$field}' is fillable\n";
        } else {
            echo "   ✗ Field '{$field}' is NOT fillable\n";
        }
    }
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\nTesting completed!\n";
