<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing Penduduk Model...\n";

try {
    // Test 1: Check if Penduduk model can be loaded
    echo "1. Testing Penduduk model loading...\n";
    $penduduk = \App\Models\Penduduk::first();
    
    if (!$penduduk) {
        echo "   ERROR: No penduduk data found\n";
        exit(1);
    }
    
    echo "   SUCCESS: Found penduduk with NIK: " . $penduduk->nik . "\n";
    echo "   Name: " . $penduduk->nama . "\n";
    
    // Test 2: Check password methods
    echo "\n2. Testing password methods...\n";
    
    // Check if password column exists
    $columns = \Illuminate\Support\Facades\Schema::getColumnListing('penduduk');
    echo "   Password column exists: " . (in_array('password', $columns) ? "Yes" : "No") . "\n";
    
    if (in_array('password', $columns)) {
        echo "   Password value: " . ($penduduk->password ? "Set" : "Not set") . "\n";
        
        // Test hasPassword method
        try {
            $hasPassword = $penduduk->hasPassword();
            echo "   hasPassword(): " . ($hasPassword ? "Yes" : "No") . "\n";
        } catch (Exception $e) {
            echo "   hasPassword() ERROR: " . $e->getMessage() . "\n";
        }
        
        // Test mustChangePassword method
        try {
            $mustChange = $penduduk->mustChangePassword();
            echo "   mustChangePassword(): " . ($mustChange ? "Yes" : "No") . "\n";
        } catch (Exception $e) {
            echo "   mustChangePassword() ERROR: " . $e->getMessage() . "\n";
        }
        
        // Test checkPassword method
        try {
            $checkPassword = $penduduk->checkPassword('test123');
            echo "   checkPassword('test123'): " . ($checkPassword ? "Valid" : "Invalid") . "\n";
        } catch (Exception $e) {
            echo "   checkPassword() ERROR: " . $e->getMessage() . "\n";
        }
    }
    
    // Test 3: Check if password_must_change column exists
    echo "\n3. Testing password_must_change column...\n";
    echo "   password_must_change column exists: " . (in_array('password_must_change', $columns) ? "Yes" : "No") . "\n";
    
    if (in_array('password_must_change', $columns)) {
        echo "   password_must_change value: " . ($penduduk->password_must_change ? "Yes" : "No") . "\n";
    }
    
    // Test 4: Check last_login_at column
    echo "\n4. Testing last_login_at column...\n";
    echo "   last_login_at column exists: " . (in_array('last_login_at', $columns) ? "Yes" : "No") . "\n";
    
    if (in_array('last_login_at', $columns)) {
        echo "   last_login_at value: " . ($penduduk->last_login_at ?? "null") . "\n";
    }
    
    // Test 5: Test update method
    echo "\n5. Testing update method...\n";
    try {
        $penduduk->update(['last_login_at' => now()]);
        echo "   update() method: SUCCESS\n";
    } catch (Exception $e) {
        echo "   update() method ERROR: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}
