<?php
// Simple test to check if CAPTCHA works outside Laravel

require_once 'vendor/autoload.php';

try {
    echo "Testing CAPTCHA...\n";
    
    // Check if class exists
    if (!class_exists('Gregwar\Captcha\CaptchaBuilder')) {
        echo "ERROR: CaptchaBuilder class not found\n";
        exit(1);
    }
    
    echo "CaptchaBuilder class found\n";
    
    // Check GD
    if (!extension_loaded('gd')) {
        echo "ERROR: GD extension not loaded\n";
        exit(1);
    }
    
    echo "GD extension loaded\n";
    
    // Create CAPTCHA
    $builder = new \Gregwar\Captcha\CaptchaBuilder();
    echo "Builder created\n";
    
    $builder->build();
    echo "Builder built\n";
    
    $phrase = $builder->getPhrase();
    echo "Phrase: $phrase\n";
    
    $imageData = $builder->get();
    echo "Image data size: " . strlen($imageData) . " bytes\n";
    
    if (strlen($imageData) > 0) {
        // Try to save to file
        file_put_contents('test_captcha.jpg', $imageData);
        echo "CAPTCHA saved to test_captcha.jpg\n";
        echo "SUCCESS: CAPTCHA generation works!\n";
    } else {
        echo "ERROR: No image data generated\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
