<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing UMKM Store Method...\n\n";

try {
    // Test UMKM model creation
    echo "1. Testing UMKM model creation...\n";
    
    // Get a penduduk for testing
    $penduduk = App\Models\Penduduk::first();
    if (!$penduduk) {
        echo "   ✗ No penduduk found for testing\n";
        exit;
    }
    
    echo "   ✓ Penduduk found: " . $penduduk->nama . " (ID: " . $penduduk->id . ")\n";
    
    // Test data
    $testData = [
        'nama_umkm' => 'Test UMKM ' . time(),
        'kategori' => 'makanan_minuman',
        'pemilik_id' => $penduduk->id,
        'deskripsi' => 'Test deskripsi UMKM',
        'alamat' => 'Test alamat',
        'nomor_telepon' => '081234567890',
        'email' => 'test@example.com',
        'skala_usaha' => 'mikro',
        'user_id' => 1,
        'slug' => 'test-umkm-' . time(),
        'status' => 'aktif',
        'is_verified' => false,
        'aktif_marketplace' => false,
        'bisa_cod' => false,
        'bisa_transfer' => false,
    ];
    
    echo "   ✓ Test data prepared\n";
    
    // Test UMKM creation
    try {
        $umkm = App\Models\Umkm::create($testData);
        echo "   ✓ UMKM created successfully: " . $umkm->nama_umkm . " (ID: " . $umkm->id . ")\n";
        
        // Clean up
        $umkm->delete();
        echo "   ✓ Test UMKM deleted\n";
        
    } catch (Exception $e) {
        echo "   ✗ UMKM creation failed: " . $e->getMessage() . "\n";
        echo "   ✗ Stack trace: " . $e->getTraceAsString() . "\n";
    }
    
    // Test validation
    echo "\n2. Testing validation...\n";
    
    $validator = \Illuminate\Support\Facades\Validator::make($testData, [
        'nama_umkm' => 'required|string|max:255',
        'kategori' => 'required|in:makanan_minuman,kerajinan_tangan,fashion_tekstil,jasa_layanan,pertanian_perkebunan,peternakan_perikanan,teknologi_digital,perdagangan_retail,pariwisata_budaya,lainnya',
        'pemilik_id' => 'required|exists:penduduk,id',
        'deskripsi' => 'required|string',
        'alamat' => 'required|string',
        'nomor_telepon' => 'nullable|string|max:15',
        'email' => 'nullable|email',
        'website' => 'nullable|url',
        'skala_usaha' => 'required|in:mikro,kecil,menengah',
    ]);
    
    if ($validator->fails()) {
        echo "   ✗ Validation failed: " . json_encode($validator->errors()) . "\n";
    } else {
        echo "   ✓ Validation passed\n";
    }
    
    // Test FileUploadService
    echo "\n3. Testing FileUploadService...\n";
    
    try {
        $uploadService = new \App\Services\FileUploadService();
        echo "   ✓ FileUploadService instantiated successfully\n";
    } catch (Exception $e) {
        echo "   ✗ FileUploadService error: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\nTesting completed!\n";
